<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// code external to the class is included here

// declare_class is output here
#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 109 "smarty_internal_templateparser.php"
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->cacher = $this->template->cacher_object; 
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }
    
#line 147 "smarty_internal_templateparser.php"

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const TP_OTHER                          =  1;
    const TP_XML                            =  2;
    const TP_PHP                            =  3;
    const TP_SHORTTAGSTART                  =  4;
    const TP_SHORTTAGEND                    =  5;
    const TP_PHPSTART                       =  6;
    const TP_PHPEND                         =  7;
    const TP_COMMENT                        =  8;
    const TP_SINGLEQUOTE                    =  9;
    const TP_LITERALSTART                   = 10;
    const TP_LITERALEND                     = 11;
    const TP_LDELIMTAG                      = 12;
    const TP_RDELIMTAG                      = 13;
    const TP_LDELSLASH                      = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_ISIN                           = 17;
    const TP_AS                             = 18;
    const TP_BOOLEAN                        = 19;
    const TP_NULL                           = 20;
    const TP_IDENTITY                       = 21;
    const TP_NONEIDENTITY                   = 22;
    const TP_EQUALS                         = 23;
    const TP_NOTEQUALS                      = 24;
    const TP_GREATEREQUAL                   = 25;
    const TP_LESSEQUAL                      = 26;
    const TP_GREATERTHAN                    = 27;
    const TP_LESSTHAN                       = 28;
    const TP_NOT                            = 29;
    const TP_LAND                           = 30;
    const TP_LOR                            = 31;
    const TP_LXOR                           = 32;
    const TP_ISODDBY                        = 33;
    const TP_ISNOTODDBY                     = 34;
    const TP_ISODD                          = 35;
    const TP_ISNOTODD                       = 36;
    const TP_ISEVENBY                       = 37;
    const TP_ISNOTEVENBY                    = 38;
    const TP_ISEVEN                         = 39;
    const TP_ISNOTEVEN                      = 40;
    const TP_ISDIVBY                        = 41;
    const TP_ISNOTDIVBY                     = 42;
    const TP_OPENP                          = 43;
    const TP_CLOSEP                         = 44;
    const TP_OPENB                          = 45;
    const TP_CLOSEB                         = 46;
    const TP_PTR                            = 47;
    const TP_APTR                           = 48;
    const TP_EQUAL                          = 49;
    const TP_INTEGER                        = 50;
    const TP_INCDEC                         = 51;
    const TP_UNIMATH                        = 52;
    const TP_MATH                           = 53;
    const TP_DOLLAR                         = 54;
    const TP_COLON                          = 55;
    const TP_DOUBLECOLON                    = 56;
    const TP_SEMICOLON                      = 57;
    const TP_AT                             = 58;
    const TP_HATCH                          = 59;
    const TP_QUOTE                          = 60;
    const TP_BACKTICK                       = 61;
    const TP_VERT                           = 62;
    const TP_DOT                            = 63;
    const TP_COMMA                          = 64;
    const TP_ANDSYM                         = 65;
    const TP_ID                             = 66;
    const TP_SPACE                          = 67;
    const TP_INSTANCEOF                     = 68;
    const TP_QMARK                          = 69;
    const YY_NO_ACTION = 478;
    const YY_ACCEPT_ACTION = 477;
    const YY_ERROR_ACTION = 476;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 996;
static public $yy_action = array(
 /*     0 */   222,  220,  247,    9,    3,  208,  215,    7,    4,  254,
 /*    10 */   249,   10,   12,  182,  222,  220,  247,    9,    3,  208,
 /*    20 */   215,    7,    4,  254,  249,   10,   12,  201,  291,  222,
 /*    30 */   220,  247,    9,    3,  208,  215,    7,    4,  254,  249,
 /*    40 */    10,   12,   43,  171,  149,  222,  220,  247,    9,    3,
 /*    50 */   208,  215,    7,    4,  254,  249,   10,   12,   63,  111,
 /*    60 */   144,   63,  277,  217,   64,  223,  134,   64,  207,  213,
 /*    70 */   152,  207,  213,  239,  241,  184,  186,  240,    8,  259,
 /*    80 */   252,  150,   73,  125,  235,  234,  124,    2,   69,   26,
 /*    90 */   163,   24,   11,   49,   14,   33,  259,   14,  285,  196,
 /*   100 */   197,   41,  196,   72,   41,  302,   69,  263,   49,   58,
 /*   110 */   226,   49,   58,   63,  295,  161,   63,   19,  154,   64,
 /*   120 */   279,  280,   64,  207,  213,   23,  207,  213,  195,  150,
 /*   130 */   104,   18,   77,  276,  179,   24,    8,   36,  174,   43,
 /*   140 */   210,  293,  272,  100,  106,  229,  199,   33,  190,   14,
 /*   150 */    11,  219,   14,   31,  196,   45,   41,  196,   72,   41,
 /*   160 */    69,   65,  266,   49,   58,   49,   49,   58,   63,   23,
 /*   170 */    44,   63,  166,  153,   64,  102,   25,   64,  207,  213,
 /*   180 */    21,  207,  213,  170,   18,   39,  272,   77,  204,  251,
 /*   190 */   233,  225,  205,  248,  246,  211,  255,  106,  477,   94,
 /*   200 */   238,  299,   33,  163,   14,    6,  219,   14,    1,  196,
 /*   210 */   283,   41,  196,   72,   41,   69,   72,  163,   49,   58,
 /*   220 */    49,   49,   58,   63,   95,  161,   63,  117,  161,   64,
 /*   230 */   163,  195,   64,  207,  213,   77,  207,  213,  195,  306,
 /*   240 */   104,  244,   77,  210,  293,   24,   98,  163,  229,   35,
 /*   250 */   210,  293,  177,  100,  219,  229,   77,   33,  203,   14,
 /*   260 */    33,  219,   14,  163,  196,  139,   41,  196,   69,   41,
 /*   270 */   223,   72,  143,   49,   58,  219,   49,   58,   63,   60,
 /*   280 */   162,   63,   24,  155,   64,  259,  195,   64,  207,  213,
 /*   290 */    77,  207,  213,  195,  274,  104,  168,   77,  210,  293,
 /*   300 */    36,   96,  163,  229,   17,  210,  293,  127,  100,  219,
 /*   310 */   229,  147,   33,  176,   14,    6,  219,   14,   45,  196,
 /*   320 */   259,   41,  196,   69,   41,  179,   72,   61,   49,   58,
 /*   330 */   290,   49,   58,  272,   77,  157,  304,  169,   44,  195,
 /*   340 */   305,   57,  274,   77,  288,   24,   88,  200,  156,   63,
 /*   350 */   300,  158,  172,  219,  100,   64,  229,  105,  163,  207,
 /*   360 */   213,  122,  219,  182,   39,  279,  280,  297,  251,  233,
 /*   370 */   225,  205,  248,  246,  211,  255,  279,  280,  276,   34,
 /*   380 */   195,  281,  148,   33,   77,   14,   77,   40,  304,  276,
 /*   390 */   196,  236,  210,  293,   69,   97,  272,  229,  242,   49,
 /*   400 */    58,  228,  300,  219,   53,  219,  162,  260,   39,  163,
 /*   410 */   110,   67,  251,  233,  225,  205,  248,  246,  211,  255,
 /*   420 */    18,  277,  183,   50,  181,   32,   62,   24,   54,   76,
 /*   430 */    66,  119,  101,  106,   63,  175,   63,  304,  210,  293,
 /*   440 */    64,  100,   64,  229,  207,  213,  207,  213,  195,  219,
 /*   450 */    57,  300,   77,  163,  180,   87,  347,    5,  304,   51,
 /*   460 */   202,  293,  236,  100,  130,  229,  301,  283,   33,  163,
 /*   470 */    33,  219,  300,  257,  182,  196,  297,  196,  272,   69,
 /*   480 */   163,   69,  204,   18,   49,   58,   49,   58,  195,   22,
 /*   490 */    57,  162,   77,  159,   37,   89,  106,  163,  218,  273,
 /*   500 */   202,  293,    1,  100,  113,  229,  182,  347,  195,  178,
 /*   510 */    57,  219,   77,  344,   19,   84,  297,  278,  191,  274,
 /*   520 */   202,  293,  195,  100,   57,  229,   77,  132,  136,   90,
 /*   530 */   193,  219,  150,  145,  202,  293,  297,  100,  258,  229,
 /*   540 */   195,  259,   57,  206,   77,  219,  259,   86,  214,  128,
 /*   550 */   297,   79,  202,  293,  195,  100,   57,  229,   77,  224,
 /*   560 */   231,   91,  259,  219,  182,  116,  202,  293,  297,  100,
 /*   570 */   230,  229,  195,   99,   56,  224,   77,  219,   18,   82,
 /*   580 */   274,  287,  297,  275,  202,  293,   68,  100,  274,  229,
 /*   590 */   195,  106,   57,   22,   77,  219,  129,   93,  165,   59,
 /*   600 */   297,  274,  202,  293,  195,  100,   57,  229,   77,  259,
 /*   610 */    43,   85,   16,  219,  274,   27,  202,  293,  297,  100,
 /*   620 */   141,  229,  163,  214,  195,  223,   57,  219,   77,  163,
 /*   630 */   133,   92,  297,  194,  150,  135,  202,  293,   29,  100,
 /*   640 */   262,  229,  195,  259,   55,  163,   77,  219,  259,   83,
 /*   650 */    40,   75,  297,   80,  202,  293,  195,  100,  120,  229,
 /*   660 */    77,  142,  151,  195,  333,  219,  223,   77,  210,  293,
 /*   670 */   297,  100,   38,  229,  308,  216,  227,  198,  298,  219,
 /*   680 */   229,  195,   16,  108,  185,   66,  219,  160,  286,  237,
 /*   690 */    28,  173,   74,  210,  293,  292,  100,  195,  229,  126,
 /*   700 */   212,   77,  267,   71,  219,  284,  192,  294,  163,  210,
 /*   710 */   293,   69,  100,  261,  229,  195,   49,   52,   78,   77,
 /*   720 */   219,   30,  250,  256,  187,  245,  253,  210,  293,  221,
 /*   730 */   100,  195,  229,  120,  270,   77,  268,  167,  219,   81,
 /*   740 */   189,  217,  296,  210,  293,  115,  100,  195,  229,  104,
 /*   750 */    42,   77,   13,  277,  219,  243,  271,   20,  265,  210,
 /*   760 */   293,   47,  100,  264,  229,  195,  188,  269,   48,   77,
 /*   770 */   219,   70,  195,   37,  121,  282,   77,  289,  282,  195,
 /*   780 */   282,  118,  229,   77,  210,  293,  224,  100,  219,  229,
 /*   790 */   282,  210,  293,  282,  100,  219,  229,  195,  282,  107,
 /*   800 */   282,   77,  219,  282,  282,  282,  282,  282,  282,  210,
 /*   810 */   293,  195,  100,  138,  229,   77,  282,  282,  282,  282,
 /*   820 */   219,  282,  282,  210,  293,  195,  100,  146,  229,   77,
 /*   830 */   282,  282,  282,  282,  219,  282,  282,  210,  293,  195,
 /*   840 */   100,  112,  229,   77,  282,  282,  282,  282,  219,  282,
 /*   850 */   303,  210,  293,  195,  100,  114,  229,   77,  282,  282,
 /*   860 */   282,  282,  219,  282,   15,  210,  293,  282,  100,  282,
 /*   870 */   229,  195,  282,  123,  282,   77,  219,  282,  195,  282,
 /*   880 */   140,  282,   77,  210,  293,  282,  100,  282,  229,  282,
 /*   890 */   210,  293,  282,  100,  219,  229,  282,  282,  282,  282,
 /*   900 */   282,  219,  195,  164,  131,  282,   77,  282,  282,  307,
 /*   910 */    46,  282,  282,  282,  210,  293,  195,  100,  103,  229,
 /*   920 */    77,  282,  282,  282,  282,  219,  282,  282,  210,  293,
 /*   930 */   195,  100,  109,  229,   77,  303,  282,  282,  282,  219,
 /*   940 */   282,  282,  210,  293,  195,  100,  137,  229,   77,   15,
 /*   950 */   282,  282,  282,  219,  195,  282,  210,  293,   77,  100,
 /*   960 */   282,  229,  282,  282,  282,  282,  209,  219,  282,  195,
 /*   970 */   282,  229,  282,   77,  282,  282,  282,  219,  282,  282,
 /*   980 */   282,  232,  282,  282,  282,  282,  229,  282,  164,  282,
 /*   990 */   282,  282,  219,  282,  282,   46,
    );
    static public $yy_lookahead = array(
 /*     0 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*    10 */    40,   41,   42,   67,   30,   31,   32,   33,   34,   35,
 /*    20 */    36,   37,   38,   39,   40,   41,   42,   57,   44,   30,
 /*    30 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   47,   44,   16,   30,   31,   32,   33,   34,
 /*    50 */    35,   36,   37,   38,   39,   40,   41,   42,    9,  100,
 /*    60 */    99,    9,  103,  102,   15,  104,   79,   15,   19,   20,
 /*    70 */    83,   19,   20,    1,    2,    3,    4,    5,   29,   92,
 /*    80 */     8,   83,   10,   79,   12,   13,   14,   15,   54,   15,
 /*    90 */    62,   15,   43,   59,   45,   43,   92,   45,   46,   50,
 /*   100 */    66,   52,   50,   54,   52,    1,   54,    1,   59,   60,
 /*   110 */   104,   59,   60,    9,   46,   66,    9,   43,   66,   15,
 /*   120 */    52,   53,   15,   19,   20,   49,   19,   20,   78,   83,
 /*   130 */    80,   43,   82,   65,   58,   15,   29,   45,   74,   47,
 /*   140 */    90,   91,   66,   93,   56,   95,   82,   43,   98,   45,
 /*   150 */    43,  101,   45,  107,   50,   63,   52,   50,   54,   52,
 /*   160 */    54,   54,   46,   59,   60,   59,   59,   60,    9,   49,
 /*   170 */    66,    9,   66,   66,   15,   77,   15,   15,   19,   20,
 /*   180 */    64,   19,   20,   78,   43,   17,   66,   82,   47,   21,
 /*   190 */    22,   23,   24,   25,   26,   27,   28,   56,   71,   72,
 /*   200 */    73,   16,   43,   62,   45,   43,  101,   45,   67,   50,
 /*   210 */   112,   52,   50,   54,   52,   54,   54,   62,   59,   60,
 /*   220 */    59,   59,   60,    9,   96,   66,    9,   66,   66,   15,
 /*   230 */    62,   78,   15,   19,   20,   82,   19,   20,   78,  111,
 /*   240 */    80,   92,   82,   90,   91,   15,   93,   62,   95,   48,
 /*   250 */    90,   91,   78,   93,  101,   95,   82,   43,   98,   45,
 /*   260 */    43,  101,   45,   62,   50,   99,   52,   50,   54,   52,
 /*   270 */   104,   54,   79,   59,   60,  101,   59,   60,    9,   88,
 /*   280 */    66,    9,   15,   66,   15,   92,   78,   15,   19,   20,
 /*   290 */    82,   19,   20,   78,  103,   80,   66,   82,   90,   91,
 /*   300 */    45,   93,   62,   95,   64,   90,   91,   79,   93,  101,
 /*   310 */    95,   83,   43,   98,   45,   43,  101,   45,   63,   50,
 /*   320 */    92,   52,   50,   54,   52,   58,   54,   88,   59,   60,
 /*   330 */    78,   59,   60,   66,   82,   66,    1,   18,   66,   78,
 /*   340 */    16,   80,  103,   82,    9,   15,   85,   86,   87,    9,
 /*   350 */    15,   90,   91,  101,   93,   15,   95,  100,   62,   19,
 /*   360 */    20,   84,  101,   67,   17,   52,   53,  106,   21,   22,
 /*   370 */    23,   24,   25,   26,   27,   28,   52,   53,   65,   49,
 /*   380 */    78,   51,   78,   43,   82,   45,   82,   68,    1,   65,
 /*   390 */    50,   44,   90,   91,   54,   93,   66,   95,   11,   59,
 /*   400 */    60,   97,   15,  101,   84,  101,   66,   89,   17,   62,
 /*   410 */   100,   54,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   420 */    43,  103,   74,   66,   76,   48,   78,   15,   80,   81,
 /*   430 */    82,  100,   77,   56,    9,   44,    9,    1,   90,   91,
 /*   440 */    15,   93,   15,   95,   19,   20,   19,   20,   78,  101,
 /*   450 */    80,   15,   82,   62,   47,   85,   16,   57,    1,   84,
 /*   460 */    90,   91,   44,   93,   64,   95,    9,  112,   43,   62,
 /*   470 */    43,  101,   15,    1,   67,   50,  106,   50,   66,   54,
 /*   480 */    62,   54,   47,   43,   59,   60,   59,   60,   78,   49,
 /*   490 */    80,   66,   82,   66,   55,   85,   56,   62,   66,   66,
 /*   500 */    90,   91,   67,   93,   88,   95,   67,   67,   78,   58,
 /*   510 */    80,  101,   82,   16,   43,   85,  106,   66,   54,  103,
 /*   520 */    90,   91,   78,   93,   80,   95,   82,   66,   79,   85,
 /*   530 */    66,  101,   83,   79,   90,   91,  106,   93,   66,   95,
 /*   540 */    78,   92,   80,   50,   82,  101,   92,   85,   51,   79,
 /*   550 */   106,   44,   90,   91,   78,   93,   80,   95,   82,  105,
 /*   560 */     5,   85,   92,  101,   67,   88,   90,   91,  106,   93,
 /*   570 */    16,   95,   78,   88,   80,  105,   82,  101,   43,   85,
 /*   580 */   103,   46,  106,   16,   90,   91,   88,   93,  103,   95,
 /*   590 */    78,   56,   80,   49,   82,  101,   79,   85,   63,   88,
 /*   600 */   106,  103,   90,   91,   78,   93,   80,   95,   82,   92,
 /*   610 */    47,   85,   49,  101,  103,   55,   90,   91,  106,   93,
 /*   620 */    99,   95,   62,   51,   78,  104,   80,  101,   82,   62,
 /*   630 */    79,   85,  106,   63,   83,   79,   90,   91,   55,   93,
 /*   640 */    44,   95,   78,   92,   80,   62,   82,  101,   92,   85,
 /*   650 */    68,   54,  106,   66,   90,   91,   78,   93,   80,   95,
 /*   660 */    82,   99,   16,   78,   16,  101,  104,   82,   90,   91,
 /*   670 */   106,   93,   15,   95,   59,   90,   91,   74,   16,  101,
 /*   680 */    95,   78,   49,   80,    1,   82,  101,  109,  110,    5,
 /*   690 */    69,   18,   54,   90,   91,   59,   93,   78,   95,   80,
 /*   700 */    81,   82,   61,   54,  101,   46,   55,   50,   62,   90,
 /*   710 */    91,   54,   93,   16,   95,   78,   59,   80,   81,   82,
 /*   720 */   101,   69,   16,   66,    1,   16,   66,   90,   91,   44,
 /*   730 */    93,   78,   95,   80,   66,   82,   61,   66,  101,   97,
 /*   740 */    66,  102,  112,   90,   91,  100,   93,   78,   95,   80,
 /*   750 */    94,   82,  108,  103,  101,   73,   86,   43,  111,   90,
 /*   760 */    91,  100,   93,  110,   95,   78,   75,   98,   66,   82,
 /*   770 */   101,   54,   78,   55,   80,  113,   82,   90,  113,   78,
 /*   780 */   113,   80,   95,   82,   90,   91,  105,   93,  101,   95,
 /*   790 */   113,   90,   91,  113,   93,  101,   95,   78,  113,   80,
 /*   800 */   113,   82,  101,  113,  113,  113,  113,  113,  113,   90,
 /*   810 */    91,   78,   93,   80,   95,   82,  113,  113,  113,  113,
 /*   820 */   101,  113,  113,   90,   91,   78,   93,   80,   95,   82,
 /*   830 */   113,  113,  113,  113,  101,  113,  113,   90,   91,   78,
 /*   840 */    93,   80,   95,   82,  113,  113,  113,  113,  101,  113,
 /*   850 */     1,   90,   91,   78,   93,   80,   95,   82,  113,  113,
 /*   860 */   113,  113,  101,  113,   15,   90,   91,  113,   93,  113,
 /*   870 */    95,   78,  113,   80,  113,   82,  101,  113,   78,  113,
 /*   880 */    80,  113,   82,   90,   91,  113,   93,  113,   95,  113,
 /*   890 */    90,   91,  113,   93,  101,   95,  113,  113,  113,  113,
 /*   900 */   113,  101,   78,   54,   80,  113,   82,  113,  113,   60,
 /*   910 */    61,  113,  113,  113,   90,   91,   78,   93,   80,   95,
 /*   920 */    82,  113,  113,  113,  113,  101,  113,  113,   90,   91,
 /*   930 */    78,   93,   80,   95,   82,    1,  113,  113,  113,  101,
 /*   940 */   113,  113,   90,   91,   78,   93,   80,   95,   82,   15,
 /*   950 */   113,  113,  113,  101,   78,  113,   90,   91,   82,   93,
 /*   960 */   113,   95,  113,  113,  113,  113,   90,  101,  113,   78,
 /*   970 */   113,   95,  113,   82,  113,  113,  113,  101,  113,  113,
 /*   980 */   113,   90,  113,  113,  113,  113,   95,  113,   54,  113,
 /*   990 */   113,  113,  101,  113,   60,   61,
);
    const YY_SHIFT_USE_DFLT = -55;
    const YY_SHIFT_MAX = 204;
    static public $yy_shift_ofst = array(
 /*     0 */    72,  107,  272,   49,   49,   49,   49,   49,   49,   49,
 /*    10 */    49,   49,   49,   49,  217,  104,  162,  159,  159,  159,
 /*    20 */   159,  217,  162,  159,  159,  159,  159,  159,  159,  159,
 /*    30 */   159,  159,  159,  159,  159,  159,   52,  269,  214,  340,
 /*    40 */   427,  425,  425,  161,  141,  657,  106,   92,  407,   34,
 /*    50 */   435,  439,  296,  439,  296,  347,  391,  168,  849,  330,
 /*    60 */    76,  267,  497,  457,  357,  230,  563,  412,  412,  412,
 /*    70 */   412,  412,  230,  436,  412,  412,  -54,   -5,  -54,   -5,
 /*    80 */   -54,   -5,   -1,  -16,  -30,   15,   15,   15,   15,   15,
 /*    90 */    15,   15,   15,   15,   72,  934,  324,   68,  313,  120,
 /*   100 */   313,  387,  335,  418,  240,  255,  464,  560,  185,   28,
 /*   110 */   255,  255,  583,  412,  567,  255,  412,   74,  646,  255,
 /*   120 */   201,  155,  718,  155,  702,  -54,  155,  -54,  -54,  -54,
 /*   130 */   717,  155,  714,  -54,  -54,  -54,  -54,  155,  155,   -5,
 /*   140 */   155,   -5,   -5,  -54,   -5,  -54,  155,  -55,  -55,  -55,
 /*   150 */   -55,  -55,  -55,  440,  535,  377,  400,   88,  319,   88,
 /*   160 */   116,   88,   88,  451,  472,  671,  641,  659,  651,  649,
 /*   170 */   636,  621,  673,  638,  697,  652,  685,  675,  668,  432,
 /*   180 */   660,  709,  674,  706,  723,  684,  683,  555,  554,  544,
 /*   190 */   507,  461,  433,  471,  493,  572,  570,  615,  662,  633,
 /*   200 */   648,  597,  582,  596,  587,
);
    const YY_REDUCE_USE_DFLT = -42;
    const YY_REDUCE_MAX = 152;
    static public $yy_reduce_ofst = array(
 /*     0 */   127,  261,  348,  462,  444,  430,  494,  526,  410,  512,
 /*    10 */   546,  564,  370,  476,  578,  603,  637,  669,  160,  215,
 /*    20 */    50,  653,  619,  824,  775,  701,  852,  866,  719,  733,
 /*    30 */   761,  747,  793,  838,  800,  694,  302,  153,  208,  585,
 /*    40 */   891,  876,  687,  304,  -13,  252,  174,  -39,  228,  105,
 /*    50 */   -13,  454,  449,  470,  551,   46,   46,   46,  128,  318,
 /*    60 */   -41,  -41,    4,   98,   64,  191,  166,  498,  -41,  239,
 /*    70 */   485,  416,  239,  355,  477,  511,  517,  166,  556,  562,
 /*    80 */   193,  521,  644,  644,  644,  644,  644,  644,  644,  644,
 /*    90 */   644,  644,  644,  644,  682,  647,  656,  656,  656,  650,
 /*   100 */   656,  630,  630,   -2,   -2,  639,  642,   -2,   -2,   -2,
 /*   110 */   639,  639,   -2,  650,   -2,  639,  650,  645,   -2,  639,
 /*   120 */    -2,   -2,  681,   -2,  691,  149,   -2,  149,  149,  149,
 /*   130 */   670,   -2,  661,  149,  149,  149,  149,   -2,   -2,    6,
 /*   140 */    -2,    6,    6,  149,    6,  149,   -2,  320,  257,  310,
 /*   150 */   277,  331,  375,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(1, 2, 3, 4, 5, 8, 10, 12, 13, 14, 15, ),
        /* 1 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 2 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 3 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 4 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 5 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 6 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 7 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 8 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 9 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 10 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 11 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 12 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 13 */ array(9, 15, 19, 20, 29, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 14 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 15 */ array(1, 9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 16 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 17 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 18 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 19 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 20 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 21 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 22 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 23 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 24 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 25 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 26 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 27 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 28 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 29 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 30 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 31 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 32 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 33 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 34 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 35 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 36 */ array(9, 15, 19, 20, 43, 45, 46, 50, 52, 54, 59, 60, 66, ),
        /* 37 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 38 */ array(9, 15, 19, 20, 43, 45, 50, 52, 54, 59, 60, 66, ),
        /* 39 */ array(9, 15, 19, 20, 43, 45, 50, 54, 59, 60, 66, ),
        /* 40 */ array(9, 15, 19, 20, 43, 50, 54, 59, 60, 66, ),
        /* 41 */ array(9, 15, 19, 20, 43, 50, 54, 59, 60, 66, ),
        /* 42 */ array(9, 15, 19, 20, 43, 50, 54, 59, 60, 66, ),
        /* 43 */ array(15, 54, 59, 66, ),
        /* 44 */ array(43, 47, 56, 62, 67, ),
        /* 45 */ array(15, 50, 54, 59, 66, ),
        /* 46 */ array(1, 54, 59, 66, ),
        /* 47 */ array(45, 47, 63, ),
        /* 48 */ array(47, 62, 67, ),
        /* 49 */ array(54, 59, 66, ),
        /* 50 */ array(47, 62, 67, ),
        /* 51 */ array(55, 67, ),
        /* 52 */ array(62, 67, ),
        /* 53 */ array(55, 67, ),
        /* 54 */ array(62, 67, ),
        /* 55 */ array(17, 21, 22, 23, 24, 25, 26, 27, 28, 44, 62, ),
        /* 56 */ array(17, 21, 22, 23, 24, 25, 26, 27, 28, 44, 62, ),
        /* 57 */ array(17, 21, 22, 23, 24, 25, 26, 27, 28, 62, ),
        /* 58 */ array(1, 15, 54, 60, 61, ),
        /* 59 */ array(15, 49, 51, 66, ),
        /* 60 */ array(15, 49, 58, 66, ),
        /* 61 */ array(15, 58, 66, ),
        /* 62 */ array(16, 51, 67, ),
        /* 63 */ array(1, 9, 15, ),
        /* 64 */ array(54, 66, ),
        /* 65 */ array(15, 66, ),
        /* 66 */ array(47, 49, ),
        /* 67 */ array(15, 66, ),
        /* 68 */ array(15, 66, ),
        /* 69 */ array(15, 66, ),
        /* 70 */ array(15, 66, ),
        /* 71 */ array(15, 66, ),
        /* 72 */ array(15, 66, ),
        /* 73 */ array(1, 15, ),
        /* 74 */ array(15, 66, ),
        /* 75 */ array(15, 66, ),
        /* 76 */ array(67, ),
        /* 77 */ array(47, ),
        /* 78 */ array(67, ),
        /* 79 */ array(47, ),
        /* 80 */ array(67, ),
        /* 81 */ array(47, ),
        /* 82 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, ),
        /* 83 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, ),
        /* 84 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 57, ),
        /* 85 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 86 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 87 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 88 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 89 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 90 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 91 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 92 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 93 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, ),
        /* 94 */ array(1, 2, 3, 4, 5, 8, 10, 12, 13, 14, 15, ),
        /* 95 */ array(1, 15, 54, 60, 61, ),
        /* 96 */ array(16, 52, 53, 65, ),
        /* 97 */ array(46, 52, 53, 65, ),
        /* 98 */ array(52, 53, 65, ),
        /* 99 */ array(15, 49, 66, ),
        /* 100 */ array(52, 53, 65, ),
        /* 101 */ array(1, 11, 15, ),
        /* 102 */ array(1, 9, 15, ),
        /* 103 */ array(44, 62, ),
        /* 104 */ array(62, 64, ),
        /* 105 */ array(45, 63, ),
        /* 106 */ array(54, 66, ),
        /* 107 */ array(55, 62, ),
        /* 108 */ array(16, 62, ),
        /* 109 */ array(16, 62, ),
        /* 110 */ array(45, 63, ),
        /* 111 */ array(45, 63, ),
        /* 112 */ array(55, 62, ),
        /* 113 */ array(15, 66, ),
        /* 114 */ array(16, 62, ),
        /* 115 */ array(45, 63, ),
        /* 116 */ array(15, 66, ),
        /* 117 */ array(15, 43, ),
        /* 118 */ array(16, 62, ),
        /* 119 */ array(45, 63, ),
        /* 120 */ array(48, 62, ),
        /* 121 */ array(62, ),
        /* 122 */ array(55, ),
        /* 123 */ array(62, ),
        /* 124 */ array(66, ),
        /* 125 */ array(67, ),
        /* 126 */ array(62, ),
        /* 127 */ array(67, ),
        /* 128 */ array(67, ),
        /* 129 */ array(67, ),
        /* 130 */ array(54, ),
        /* 131 */ array(62, ),
        /* 132 */ array(43, ),
        /* 133 */ array(67, ),
        /* 134 */ array(67, ),
        /* 135 */ array(67, ),
        /* 136 */ array(67, ),
        /* 137 */ array(62, ),
        /* 138 */ array(62, ),
        /* 139 */ array(47, ),
        /* 140 */ array(62, ),
        /* 141 */ array(47, ),
        /* 142 */ array(47, ),
        /* 143 */ array(67, ),
        /* 144 */ array(47, ),
        /* 145 */ array(67, ),
        /* 146 */ array(62, ),
        /* 147 */ array(),
        /* 148 */ array(),
        /* 149 */ array(),
        /* 150 */ array(),
        /* 151 */ array(),
        /* 152 */ array(),
        /* 153 */ array(16, 43, 49, 56, 67, ),
        /* 154 */ array(43, 46, 56, 63, ),
        /* 155 */ array(43, 48, 56, ),
        /* 156 */ array(57, 64, ),
        /* 157 */ array(43, 56, ),
        /* 158 */ array(18, 68, ),
        /* 159 */ array(43, 56, ),
        /* 160 */ array(46, 64, ),
        /* 161 */ array(43, 56, ),
        /* 162 */ array(43, 56, ),
        /* 163 */ array(58, 66, ),
        /* 164 */ array(1, 66, ),
        /* 165 */ array(66, ),
        /* 166 */ array(61, ),
        /* 167 */ array(46, ),
        /* 168 */ array(55, ),
        /* 169 */ array(54, ),
        /* 170 */ array(59, ),
        /* 171 */ array(69, ),
        /* 172 */ array(18, ),
        /* 173 */ array(54, ),
        /* 174 */ array(16, ),
        /* 175 */ array(69, ),
        /* 176 */ array(44, ),
        /* 177 */ array(61, ),
        /* 178 */ array(66, ),
        /* 179 */ array(66, ),
        /* 180 */ array(66, ),
        /* 181 */ array(16, ),
        /* 182 */ array(66, ),
        /* 183 */ array(16, ),
        /* 184 */ array(1, ),
        /* 185 */ array(5, ),
        /* 186 */ array(1, ),
        /* 187 */ array(5, ),
        /* 188 */ array(16, ),
        /* 189 */ array(49, ),
        /* 190 */ array(44, ),
        /* 191 */ array(66, ),
        /* 192 */ array(66, ),
        /* 193 */ array(43, ),
        /* 194 */ array(50, ),
        /* 195 */ array(51, ),
        /* 196 */ array(63, ),
        /* 197 */ array(59, ),
        /* 198 */ array(16, ),
        /* 199 */ array(49, ),
        /* 200 */ array(16, ),
        /* 201 */ array(54, ),
        /* 202 */ array(68, ),
        /* 203 */ array(44, ),
        /* 204 */ array(66, ),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(),
        /* 210 */ array(),
        /* 211 */ array(),
        /* 212 */ array(),
        /* 213 */ array(),
        /* 214 */ array(),
        /* 215 */ array(),
        /* 216 */ array(),
        /* 217 */ array(),
        /* 218 */ array(),
        /* 219 */ array(),
        /* 220 */ array(),
        /* 221 */ array(),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
);
    static public $yy_default = array(
 /*     0 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*    10 */   476,  476,  476,  476,  457,  476,  476,  416,  416,  416,
 /*    20 */   416,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*    30 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*    40 */   476,  476,  476,  476,  344,  476,  476,  381,  344,  476,
 /*    50 */   344,  344,  344,  344,  344,  426,  426,  426,  476,  476,
 /*    60 */   391,  391,  364,  476,  476,  476,  384,  476,  391,  476,
 /*    70 */   476,  476,  476,  476,  476,  476,  344,  384,  344,  377,
 /*    80 */   344,  376,  476,  476,  476,  435,  440,  432,  332,  424,
 /*    90 */   436,  430,  431,  439,  309,  476,  476,  476,  421,  476,
 /*   100 */   352,  476,  476,  476,  415,  408,  476,  476,  476,  476,
 /*   110 */   410,  389,  476,  337,  476,  407,  338,  391,  476,  409,
 /*   120 */   460,  458,  354,  459,  476,  324,  345,  339,  340,  326,
 /*   130 */   476,  350,  391,  325,  329,  328,  327,  359,  360,  404,
 /*   140 */   335,  378,  379,  330,  382,  331,  427,  420,  391,  391,
 /*   150 */   420,  391,  420,  351,  476,  351,  476,  422,  355,  441,
 /*   160 */   476,  351,  476,  476,  476,  476,  476,  476,  402,  476,
 /*   170 */   476,  476,  358,  476,  476,  371,  476,  476,  476,  476,
 /*   180 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  347,
 /*   190 */   476,  476,  476,  380,  476,  364,  366,  476,  476,  476,
 /*   200 */   348,  476,  355,  476,  476,  444,  367,  368,  437,  356,
 /*   210 */   355,  445,  346,  369,  365,  438,  429,  390,  385,  386,
 /*   220 */   452,  413,  451,  405,  419,  443,  406,  428,  411,  370,
 /*   230 */   313,  319,  442,  450,  318,  317,  371,  320,  310,  323,
 /*   240 */   322,  321,  316,  311,  342,  314,  448,  453,  447,  434,
 /*   250 */   312,  449,  315,  341,  433,  446,  392,  468,  465,  343,
 /*   260 */   334,  383,  412,  470,  456,  461,  454,  463,  464,  414,
 /*   270 */   417,  349,  402,  353,  400,  403,  363,  401,  418,  361,
 /*   280 */   362,  336,  374,  473,  397,  399,  455,  396,  372,  357,
 /*   290 */   394,  425,  388,  358,  393,  398,  472,  423,  467,  466,
 /*   300 */   475,  373,  469,  471,  474,  395,  462,  375,  387,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 114;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 309;
    const YYNRULE = 167;
    const YYERRORSYMBOL = 70;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 1;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    0,  /*          $ => nothing */
    0,  /*      OTHER => nothing */
    1,  /*        XML => OTHER */
    1,  /*        PHP => OTHER */
    1,  /* SHORTTAGSTART => OTHER */
    1,  /* SHORTTAGEND => OTHER */
    1,  /*   PHPSTART => OTHER */
    1,  /*     PHPEND => OTHER */
    1,  /*    COMMENT => OTHER */
    1,  /* SINGLEQUOTE => OTHER */
    1,  /* LITERALSTART => OTHER */
    1,  /* LITERALEND => OTHER */
    1,  /*  LDELIMTAG => OTHER */
    1,  /*  RDELIMTAG => OTHER */
    1,  /*  LDELSLASH => OTHER */
    1,  /*       LDEL => OTHER */
    1,  /*       RDEL => OTHER */
    1,  /*       ISIN => OTHER */
    1,  /*         AS => OTHER */
    1,  /*    BOOLEAN => OTHER */
    1,  /*       NULL => OTHER */
    1,  /*   IDENTITY => OTHER */
    1,  /* NONEIDENTITY => OTHER */
    1,  /*     EQUALS => OTHER */
    1,  /*  NOTEQUALS => OTHER */
    1,  /* GREATEREQUAL => OTHER */
    1,  /*  LESSEQUAL => OTHER */
    1,  /* GREATERTHAN => OTHER */
    1,  /*   LESSTHAN => OTHER */
    1,  /*        NOT => OTHER */
    1,  /*       LAND => OTHER */
    1,  /*        LOR => OTHER */
    1,  /*       LXOR => OTHER */
    1,  /*    ISODDBY => OTHER */
    1,  /* ISNOTODDBY => OTHER */
    1,  /*      ISODD => OTHER */
    1,  /*   ISNOTODD => OTHER */
    1,  /*   ISEVENBY => OTHER */
    1,  /* ISNOTEVENBY => OTHER */
    1,  /*     ISEVEN => OTHER */
    1,  /*  ISNOTEVEN => OTHER */
    1,  /*    ISDIVBY => OTHER */
    1,  /* ISNOTDIVBY => OTHER */
    1,  /*      OPENP => OTHER */
    1,  /*     CLOSEP => OTHER */
    1,  /*      OPENB => OTHER */
    1,  /*     CLOSEB => OTHER */
    1,  /*        PTR => OTHER */
    1,  /*       APTR => OTHER */
    1,  /*      EQUAL => OTHER */
    1,  /*    INTEGER => OTHER */
    1,  /*     INCDEC => OTHER */
    1,  /*    UNIMATH => OTHER */
    1,  /*       MATH => OTHER */
    1,  /*     DOLLAR => OTHER */
    1,  /*      COLON => OTHER */
    1,  /* DOUBLECOLON => OTHER */
    1,  /*  SEMICOLON => OTHER */
    1,  /*         AT => OTHER */
    1,  /*      HATCH => OTHER */
    1,  /*      QUOTE => OTHER */
    1,  /*   BACKTICK => OTHER */
    1,  /*       VERT => OTHER */
    1,  /*        DOT => OTHER */
    1,  /*      COMMA => OTHER */
    1,  /*     ANDSYM => OTHER */
    1,  /*         ID => OTHER */
    1,  /*      SPACE => OTHER */
    1,  /* INSTANCEOF => OTHER */
    1,  /*      QMARK => OTHER */
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    public $yyTokenName = array( 
  '$',             'OTHER',         'XML',           'PHP',         
  'SHORTTAGSTART',  'SHORTTAGEND',   'PHPSTART',      'PHPEND',      
  'COMMENT',       'SINGLEQUOTE',   'LITERALSTART',  'LITERALEND',  
  'LDELIMTAG',     'RDELIMTAG',     'LDELSLASH',     'LDEL',        
  'RDEL',          'ISIN',          'AS',            'BOOLEAN',     
  'NULL',          'IDENTITY',      'NONEIDENTITY',  'EQUALS',      
  'NOTEQUALS',     'GREATEREQUAL',  'LESSEQUAL',     'GREATERTHAN', 
  'LESSTHAN',      'NOT',           'LAND',          'LOR',         
  'LXOR',          'ISODDBY',       'ISNOTODDBY',    'ISODD',       
  'ISNOTODD',      'ISEVENBY',      'ISNOTEVENBY',   'ISEVEN',      
  'ISNOTEVEN',     'ISDIVBY',       'ISNOTDIVBY',    'OPENP',       
  'CLOSEP',        'OPENB',         'CLOSEB',        'PTR',         
  'APTR',          'EQUAL',         'INTEGER',       'INCDEC',      
  'UNIMATH',       'MATH',          'DOLLAR',        'COLON',       
  'DOUBLECOLON',   'SEMICOLON',     'AT',            'HATCH',       
  'QUOTE',         'BACKTICK',      'VERT',          'DOT',         
  'COMMA',         'ANDSYM',        'ID',            'SPACE',       
  'INSTANCEOF',    'QMARK',         'error',         'start',       
  'template',      'template_element',  'smartytag',     'smartyclosetag',
  'outputtag',     'text',          'variable',      'attributes',  
  'expr',          'ternary',       'varindexed',    'modifier',    
  'modparameters',  'ifexprs',       'statement',     'statements',  
  'varvar',        'foraction',     'value',         'array',       
  'attribute',     'exprs',         'math',          'function',    
  'doublequoted',  'method',        'params',        'objectchain', 
  'arrayindex',    'object',        'indexdef',      'varvarele',   
  'objectelement',  'modparameter',  'ifexpr',        'ifcond',      
  'lop',           'arrayelements',  'arrayelement',  'doublequotedcontent',
  'textelement', 
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= LDEL smartytag RDEL",
 /*   4 */ "template_element ::= LDELSLASH smartyclosetag RDEL",
 /*   5 */ "template_element ::= LDEL outputtag RDEL",
 /*   6 */ "template_element ::= COMMENT",
 /*   7 */ "template_element ::= LITERALSTART text LITERALEND",
 /*   8 */ "template_element ::= LDELIMTAG",
 /*   9 */ "template_element ::= RDELIMTAG",
 /*  10 */ "template_element ::= PHP OTHER SHORTTAGEND",
 /*  11 */ "template_element ::= SHORTTAGSTART OTHER SHORTTAGEND",
 /*  12 */ "template_element ::= XML",
 /*  13 */ "template_element ::= SHORTTAGEND",
 /*  14 */ "template_element ::= OTHER",
 /*  15 */ "outputtag ::= variable attributes",
 /*  16 */ "outputtag ::= expr attributes",
 /*  17 */ "outputtag ::= ternary attributes",
 /*  18 */ "smartytag ::= varindexed EQUAL expr attributes",
 /*  19 */ "smartytag ::= varindexed EQUAL ternary attributes",
 /*  20 */ "smartytag ::= ID attributes",
 /*  21 */ "smartytag ::= ID PTR ID attributes",
 /*  22 */ "smartytag ::= ID modifier modparameters attributes",
 /*  23 */ "smartytag ::= ID SPACE ifexprs",
 /*  24 */ "smartytag ::= ID SPACE statement",
 /*  25 */ "smartytag ::= ID SPACE statements SEMICOLON ifexprs SEMICOLON DOLLAR varvar foraction",
 /*  26 */ "foraction ::= EQUAL expr",
 /*  27 */ "foraction ::= INCDEC",
 /*  28 */ "smartytag ::= ID SPACE value AS DOLLAR varvar",
 /*  29 */ "smartytag ::= ID SPACE array AS DOLLAR varvar",
 /*  30 */ "smartyclosetag ::= ID attributes",
 /*  31 */ "smartyclosetag ::= ID modifier modparameters attributes",
 /*  32 */ "smartyclosetag ::= ID PTR ID",
 /*  33 */ "attributes ::= attributes attribute",
 /*  34 */ "attributes ::= attribute",
 /*  35 */ "attributes ::=",
 /*  36 */ "attribute ::= SPACE ID EQUAL expr",
 /*  37 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  38 */ "attribute ::= SPACE ID",
 /*  39 */ "statements ::= statement",
 /*  40 */ "statements ::= statements COMMA statement",
 /*  41 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  42 */ "expr ::= ID",
 /*  43 */ "expr ::= exprs",
 /*  44 */ "expr ::= DOLLAR ID COLON ID",
 /*  45 */ "expr ::= expr modifier modparameters",
 /*  46 */ "exprs ::= value",
 /*  47 */ "exprs ::= UNIMATH value",
 /*  48 */ "exprs ::= exprs math value",
 /*  49 */ "exprs ::= array",
 /*  50 */ "ternary ::= OPENP ifexprs CLOSEP QMARK expr COLON expr",
 /*  51 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  52 */ "math ::= UNIMATH",
 /*  53 */ "math ::= MATH",
 /*  54 */ "math ::= ANDSYM",
 /*  55 */ "value ::= variable",
 /*  56 */ "value ::= variable INCDEC",
 /*  57 */ "value ::= INTEGER",
 /*  58 */ "value ::= INTEGER DOT INTEGER",
 /*  59 */ "value ::= BOOLEAN",
 /*  60 */ "value ::= NULL",
 /*  61 */ "value ::= function",
 /*  62 */ "value ::= OPENP expr CLOSEP",
 /*  63 */ "value ::= SINGLEQUOTE text SINGLEQUOTE",
 /*  64 */ "value ::= SINGLEQUOTE SINGLEQUOTE",
 /*  65 */ "value ::= QUOTE doublequoted QUOTE",
 /*  66 */ "value ::= QUOTE QUOTE",
 /*  67 */ "value ::= ID DOUBLECOLON method",
 /*  68 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP",
 /*  69 */ "value ::= ID DOUBLECOLON method objectchain",
 /*  70 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP objectchain",
 /*  71 */ "value ::= ID DOUBLECOLON ID",
 /*  72 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex",
 /*  73 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex objectchain",
 /*  74 */ "value ::= LDEL smartytag RDEL",
 /*  75 */ "variable ::= varindexed",
 /*  76 */ "variable ::= DOLLAR varvar AT ID",
 /*  77 */ "variable ::= object",
 /*  78 */ "variable ::= HATCH ID HATCH",
 /*  79 */ "variable ::= HATCH variable HATCH",
 /*  80 */ "varindexed ::= DOLLAR varvar arrayindex",
 /*  81 */ "arrayindex ::= arrayindex indexdef",
 /*  82 */ "arrayindex ::=",
 /*  83 */ "indexdef ::= DOT ID",
 /*  84 */ "indexdef ::= DOT INTEGER",
 /*  85 */ "indexdef ::= DOT variable",
 /*  86 */ "indexdef ::= DOT LDEL exprs RDEL",
 /*  87 */ "indexdef ::= OPENB ID CLOSEB",
 /*  88 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /*  89 */ "indexdef ::= OPENB exprs CLOSEB",
 /*  90 */ "indexdef ::= OPENB CLOSEB",
 /*  91 */ "varvar ::= varvarele",
 /*  92 */ "varvar ::= varvar varvarele",
 /*  93 */ "varvarele ::= ID",
 /*  94 */ "varvarele ::= LDEL expr RDEL",
 /*  95 */ "object ::= varindexed objectchain",
 /*  96 */ "objectchain ::= objectelement",
 /*  97 */ "objectchain ::= objectchain objectelement",
 /*  98 */ "objectelement ::= PTR ID arrayindex",
 /*  99 */ "objectelement ::= PTR variable arrayindex",
 /* 100 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 101 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 102 */ "objectelement ::= PTR method",
 /* 103 */ "function ::= ID OPENP params CLOSEP",
 /* 104 */ "method ::= ID OPENP params CLOSEP",
 /* 105 */ "params ::= expr COMMA params",
 /* 106 */ "params ::= expr",
 /* 107 */ "params ::=",
 /* 108 */ "modifier ::= VERT AT ID",
 /* 109 */ "modifier ::= VERT ID",
 /* 110 */ "modparameters ::= modparameters modparameter",
 /* 111 */ "modparameters ::=",
 /* 112 */ "modparameter ::= COLON exprs",
 /* 113 */ "modparameter ::= COLON ID",
 /* 114 */ "ifexprs ::= ifexpr",
 /* 115 */ "ifexprs ::= NOT ifexprs",
 /* 116 */ "ifexprs ::= OPENP ifexprs CLOSEP",
 /* 117 */ "ifexpr ::= expr",
 /* 118 */ "ifexpr ::= expr ifcond expr",
 /* 119 */ "ifexpr ::= expr ISIN array",
 /* 120 */ "ifexpr ::= expr ISIN value",
 /* 121 */ "ifexpr ::= ifexprs lop ifexprs",
 /* 122 */ "ifexpr ::= ifexprs ISDIVBY ifexprs",
 /* 123 */ "ifexpr ::= ifexprs ISNOTDIVBY ifexprs",
 /* 124 */ "ifexpr ::= ifexprs ISEVEN",
 /* 125 */ "ifexpr ::= ifexprs ISNOTEVEN",
 /* 126 */ "ifexpr ::= ifexprs ISEVENBY ifexprs",
 /* 127 */ "ifexpr ::= ifexprs ISNOTEVENBY ifexprs",
 /* 128 */ "ifexpr ::= ifexprs ISODD",
 /* 129 */ "ifexpr ::= ifexprs ISNOTODD",
 /* 130 */ "ifexpr ::= ifexprs ISODDBY ifexprs",
 /* 131 */ "ifexpr ::= ifexprs ISNOTODDBY ifexprs",
 /* 132 */ "ifexpr ::= value INSTANCEOF ID",
 /* 133 */ "ifexpr ::= value INSTANCEOF value",
 /* 134 */ "ifcond ::= EQUALS",
 /* 135 */ "ifcond ::= NOTEQUALS",
 /* 136 */ "ifcond ::= GREATERTHAN",
 /* 137 */ "ifcond ::= LESSTHAN",
 /* 138 */ "ifcond ::= GREATEREQUAL",
 /* 139 */ "ifcond ::= LESSEQUAL",
 /* 140 */ "ifcond ::= IDENTITY",
 /* 141 */ "ifcond ::= NONEIDENTITY",
 /* 142 */ "lop ::= LAND",
 /* 143 */ "lop ::= LOR",
 /* 144 */ "lop ::= LXOR",
 /* 145 */ "array ::= OPENB arrayelements CLOSEB",
 /* 146 */ "arrayelements ::= arrayelement",
 /* 147 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 148 */ "arrayelements ::=",
 /* 149 */ "arrayelement ::= expr APTR expr",
 /* 150 */ "arrayelement ::= ID APTR expr",
 /* 151 */ "arrayelement ::= expr",
 /* 152 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 153 */ "doublequoted ::= doublequotedcontent",
 /* 154 */ "doublequotedcontent ::= BACKTICK ID BACKTICK",
 /* 155 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 156 */ "doublequotedcontent ::= DOLLAR ID",
 /* 157 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 158 */ "doublequotedcontent ::= LDEL smartytag RDEL",
 /* 159 */ "doublequotedcontent ::= DOLLAR OTHER",
 /* 160 */ "doublequotedcontent ::= LDEL OTHER",
 /* 161 */ "doublequotedcontent ::= BACKTICK OTHER",
 /* 162 */ "doublequotedcontent ::= OTHER",
 /* 163 */ "text ::= text textelement",
 /* 164 */ "text ::= textelement",
 /* 165 */ "textelement ::= OTHER",
 /* 166 */ "textelement ::= LDEL",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param TP_yyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 72, 'rhs' => 1 ),
  array( 'lhs' => 72, 'rhs' => 2 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 3 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 2 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 3 ),
  array( 'lhs' => 74, 'rhs' => 3 ),
  array( 'lhs' => 74, 'rhs' => 9 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 74, 'rhs' => 6 ),
  array( 'lhs' => 74, 'rhs' => 6 ),
  array( 'lhs' => 75, 'rhs' => 2 ),
  array( 'lhs' => 75, 'rhs' => 4 ),
  array( 'lhs' => 75, 'rhs' => 3 ),
  array( 'lhs' => 79, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 0 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 4 ),
  array( 'lhs' => 80, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 7 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 90, 'rhs' => 8 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 5 ),
  array( 'lhs' => 90, 'rhs' => 6 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 0 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 4 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 5 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 5 ),
  array( 'lhs' => 104, 'rhs' => 6 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 0 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 0 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 2 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        46 => 0,
        55 => 0,
        57 => 0,
        59 => 0,
        60 => 0,
        61 => 0,
        77 => 0,
        146 => 0,
        1 => 1,
        43 => 1,
        49 => 1,
        52 => 1,
        53 => 1,
        91 => 1,
        114 => 1,
        153 => 1,
        162 => 1,
        164 => 1,
        165 => 1,
        166 => 1,
        2 => 2,
        81 => 2,
        152 => 2,
        160 => 2,
        163 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 15,
        17 => 15,
        18 => 18,
        19 => 18,
        20 => 20,
        21 => 21,
        22 => 22,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        34 => 27,
        106 => 27,
        151 => 27,
        28 => 28,
        29 => 29,
        30 => 30,
        31 => 31,
        32 => 32,
        33 => 33,
        35 => 35,
        36 => 36,
        37 => 36,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        44 => 44,
        45 => 45,
        47 => 47,
        56 => 47,
        48 => 48,
        50 => 50,
        51 => 50,
        54 => 54,
        58 => 58,
        62 => 62,
        63 => 63,
        64 => 64,
        66 => 64,
        65 => 65,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        78 => 78,
        79 => 79,
        80 => 80,
        82 => 82,
        111 => 82,
        83 => 83,
        84 => 84,
        85 => 85,
        86 => 86,
        89 => 86,
        87 => 87,
        88 => 88,
        90 => 90,
        92 => 92,
        93 => 93,
        94 => 94,
        116 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        112 => 112,
        113 => 113,
        115 => 115,
        117 => 117,
        118 => 118,
        121 => 118,
        132 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        123 => 123,
        124 => 124,
        129 => 124,
        125 => 125,
        128 => 125,
        126 => 126,
        131 => 126,
        127 => 127,
        130 => 127,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 158,
        159 => 159,
        161 => 161,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 79 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1967 "smarty_internal_templateparser.php"
#line 85 "smarty_internal_templateparser.y"
    function yy_r1(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 1970 "smarty_internal_templateparser.php"
#line 87 "smarty_internal_templateparser.y"
    function yy_r2(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 1973 "smarty_internal_templateparser.php"
#line 93 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->cacher->processNocacheCode($tmp.$this->yystack[$this->yyidx + -1]->minor, $this->compiler,true);
                                         } else { $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;}  $this->compiler->has_variable_string = false;    }
#line 1980 "smarty_internal_templateparser.php"
#line 99 "smarty_internal_templateparser.y"
    function yy_r4(){ 
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->cacher->processNocacheCode($tmp.$this->yystack[$this->yyidx + -1]->minor, $this->compiler,true);
                                         } else { $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;} $this->compiler->has_variable_string = false;    }
#line 1987 "smarty_internal_templateparser.php"
#line 105 "smarty_internal_templateparser.y"
    function yy_r5(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->cacher->processNocacheCode($tmp.$this->yystack[$this->yyidx + -1]->minor, $this->compiler,true);
                                         } else { $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;} $this->compiler->has_variable_string = false;    }
#line 1994 "smarty_internal_templateparser.php"
#line 111 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = '';    }
#line 1997 "smarty_internal_templateparser.php"
#line 113 "smarty_internal_templateparser.y"
    function yy_r7(){ $this->_retvalue = $this->cacher->processNocacheCode($this->yystack[$this->yyidx + -1]->minor, $this->compiler,false);    }
#line 2000 "smarty_internal_templateparser.php"
#line 115 "smarty_internal_templateparser.y"
    function yy_r8(){$this->_retvalue = $this->cacher->processNocacheCode($this->smarty->left_delimiter, $this->compiler,false);    }
#line 2003 "smarty_internal_templateparser.php"
#line 117 "smarty_internal_templateparser.y"
    function yy_r9(){ $this->_retvalue = $this->cacher->processNocacheCode($this->smarty->right_delimiter, $this->compiler,false);    }
#line 2006 "smarty_internal_templateparser.php"
#line 119 "smarty_internal_templateparser.y"
    function yy_r10(){if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
                                       $this->_retvalue = $this->cacher->processNocacheCode("<?php echo htmlspecialchars('<?php".str_replace("'","\'",$this->yystack[$this->yyidx + -1]->minor)."?>', ENT_QUOTES);?>\n", $this->compiler, false);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->cacher->processNocacheCode(htmlspecialchars('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), $this->compiler, false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->cacher->processNocacheCode('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', $this->compiler, true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2018 "smarty_internal_templateparser.php"
#line 130 "smarty_internal_templateparser.y"
    function yy_r11(){ 
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU || $this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '<?=".$this->yystack[$this->yyidx + -1]->minor."?>'?>\n", $this->compiler, false);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->cacher->processNocacheCode(htmlspecialchars('<?='.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), $this->compiler, false);
                                      }elseif ($this->sec_obj == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2029 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true; $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true);    }
#line 2032 "smarty_internal_templateparser.php"
#line 142 "smarty_internal_templateparser.y"
    function yy_r13(){$this->compiler->tag_nocache = true; $this->_retvalue = $this->cacher->processNocacheCode("<?php echo '?>';?>\n", $this->compiler, true);    }
#line 2035 "smarty_internal_templateparser.php"
#line 145 "smarty_internal_templateparser.y"
    function yy_r14(){$this->_retvalue = $this->cacher->processNocacheCode($this->yystack[$this->yyidx + 0]->minor, $this->compiler,false);    }
#line 2038 "smarty_internal_templateparser.php"
#line 152 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = $this->compiler->compileTag('print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + 0]->minor));    }
#line 2041 "smarty_internal_templateparser.php"
#line 162 "smarty_internal_templateparser.y"
    function yy_r18(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + 0]->minor));    }
#line 2044 "smarty_internal_templateparser.php"
#line 165 "smarty_internal_templateparser.y"
    function yy_r20(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2047 "smarty_internal_templateparser.php"
#line 167 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + 0]->minor));    }
#line 2050 "smarty_internal_templateparser.php"
#line 169 "smarty_internal_templateparser.y"
    function yy_r22(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + 0]->minor).'<?php echo ';
															                                   if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -2]->minor[0],'modifier')) {
                                                                      $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -2]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -1]->minor. "),".$this->yystack[$this->yyidx + -2]->minor[1].");?>";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -2]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -2]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -2]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -1]->minor. "),".$this->yystack[$this->yyidx + -2]->minor[1].");?>";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -2]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                        }
#line 2065 "smarty_internal_templateparser.php"
#line 183 "smarty_internal_templateparser.y"
    function yy_r23(){if (!in_array($this->yystack[$this->yyidx + -2]->minor,array('if','elseif','while'))) {
                                                            $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -2]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2071 "smarty_internal_templateparser.php"
#line 187 "smarty_internal_templateparser.y"
    function yy_r24(){ if (!in_array($this->yystack[$this->yyidx + -2]->minor,array('if','elseif','while'))) {
                                                            $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -2]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2077 "smarty_internal_templateparser.php"
#line 192 "smarty_internal_templateparser.y"
    function yy_r25(){
                                                            if ($this->yystack[$this->yyidx + -8]->minor != 'for') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -8]->minor . "\""); 
                                                            }
                                                             $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -8]->minor,array('start'=>$this->yystack[$this->yyidx + -6]->minor,'ifexp'=>$this->yystack[$this->yyidx + -4]->minor,'varloop'=>$this->yystack[$this->yyidx + -1]->minor,'loop'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2084 "smarty_internal_templateparser.php"
#line 197 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2087 "smarty_internal_templateparser.php"
#line 198 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2090 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r28(){
                                                            if ($this->yystack[$this->yyidx + -5]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -5]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,array('from'=>$this->yystack[$this->yyidx + -3]->minor,'item'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2097 "smarty_internal_templateparser.php"
#line 205 "smarty_internal_templateparser.y"
    function yy_r29(){ 
                                                            if ($this->yystack[$this->yyidx + -5]->minor != 'foreach') {
                                                               $this->compiler->trigger_template_error ("wrong syntax for tag \"" . $this->yystack[$this->yyidx + -5]->minor . "\""); 
                                                            }
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,array('from'=>$this->yystack[$this->yyidx + -3]->minor,'item'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2104 "smarty_internal_templateparser.php"
#line 212 "smarty_internal_templateparser.y"
    function yy_r30(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',$this->yystack[$this->yyidx + 0]->minor);    }
#line 2107 "smarty_internal_templateparser.php"
#line 213 "smarty_internal_templateparser.y"
    function yy_r31(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',$this->yystack[$this->yyidx + 0]->minor).'<?php echo ';
															                                   if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -2]->minor[0],'modifier')) {
                                                                      $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -2]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -1]->minor. "),".$this->yystack[$this->yyidx + -2]->minor[1].");?>";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -2]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -2]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue .= "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -2]->minor[0] . "',array(ob_get_clean()" . $this->yystack[$this->yyidx + -1]->minor. "),".$this->yystack[$this->yyidx + -2]->minor[1].");?>";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -2]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                        }
#line 2122 "smarty_internal_templateparser.php"
#line 227 "smarty_internal_templateparser.y"
    function yy_r32(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + 0]->minor));    }
#line 2125 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2128 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = array();    }
#line 2131 "smarty_internal_templateparser.php"
#line 241 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2134 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2137 "smarty_internal_templateparser.php"
#line 248 "smarty_internal_templateparser.y"
    function yy_r39(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2140 "smarty_internal_templateparser.php"
#line 249 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2143 "smarty_internal_templateparser.php"
#line 251 "smarty_internal_templateparser.y"
    function yy_r41(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2146 "smarty_internal_templateparser.php"
#line 257 "smarty_internal_templateparser.y"
    function yy_r42(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';     }
#line 2149 "smarty_internal_templateparser.php"
#line 260 "smarty_internal_templateparser.y"
    function yy_r44(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2152 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r45(){            
                                                            if ($this->smarty->plugin_handler->loadSmartyPlugin($this->yystack[$this->yyidx + -1]->minor[0],'modifier')) {
                                                                      $this->_retvalue = "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -1]->minor[0] . "',array(". $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + 0]->minor. "),".$this->yystack[$this->yyidx + -1]->minor[1].")";
                                                                 } else {
                                                                   if (is_callable($this->yystack[$this->yyidx + -1]->minor[0])) {
																					                            if (!$this->template->security || $this->smarty->security_handler->isTrustedModifier($this->yystack[$this->yyidx + -1]->minor[0], $this->compiler)) {
                                                                         $this->_retvalue = "\$_smarty_tpl->smarty->plugin_handler->executeModifier('".$this->yystack[$this->yyidx + -1]->minor[0] . "',array(". $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + 0]->minor. "),".$this->yystack[$this->yyidx + -1]->minor[1].")";
																					                            }
																					                         } else {
                                                                      $this->compiler->trigger_template_error ("unknown modifier \"" . $this->yystack[$this->yyidx + -1]->minor[0] . "\"");
                                                                 }
                                                              }
                                                                }
#line 2167 "smarty_internal_templateparser.php"
#line 278 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2170 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2173 "smarty_internal_templateparser.php"
#line 287 "smarty_internal_templateparser.y"
    function yy_r50(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2176 "smarty_internal_templateparser.php"
#line 301 "smarty_internal_templateparser.y"
    function yy_r54(){$this->_retvalue = ' & ';    }
#line 2179 "smarty_internal_templateparser.php"
#line 308 "smarty_internal_templateparser.y"
    function yy_r58(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2182 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r62(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2185 "smarty_internal_templateparser.php"
#line 318 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + -1]->minor."'";     }
#line 2188 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r64(){ $this->_retvalue = "''";     }
#line 2191 "smarty_internal_templateparser.php"
#line 321 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = '"'.$this->yystack[$this->yyidx + -1]->minor.'"';     }
#line 2194 "smarty_internal_templateparser.php"
#line 324 "smarty_internal_templateparser.y"
    function yy_r67(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2197 "smarty_internal_templateparser.php"
#line 325 "smarty_internal_templateparser.y"
    function yy_r68(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';     }
#line 2200 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r69(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.'::'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2203 "smarty_internal_templateparser.php"
#line 328 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -4]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -7]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -2]->minor .')'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2206 "smarty_internal_templateparser.php"
#line 330 "smarty_internal_templateparser.y"
    function yy_r71(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2209 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r72(){ $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.'::$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2212 "smarty_internal_templateparser.php"
#line 334 "smarty_internal_templateparser.y"
    function yy_r73(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.'::$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2215 "smarty_internal_templateparser.php"
#line 336 "smarty_internal_templateparser.y"
    function yy_r74(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + -1]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2218 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r75(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('special_smarty_variable',$this->yystack[$this->yyidx + 0]->minor['index']);} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['index']; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"))->nocache;}    }
#line 2222 "smarty_internal_templateparser.php"
#line 348 "smarty_internal_templateparser.y"
    function yy_r76(){ $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"))->nocache;    }
#line 2225 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2228 "smarty_internal_templateparser.php"
#line 353 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2231 "smarty_internal_templateparser.php"
#line 356 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2234 "smarty_internal_templateparser.php"
#line 364 "smarty_internal_templateparser.y"
    function yy_r82(){return;    }
#line 2237 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r83(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2240 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r84(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2243 "smarty_internal_templateparser.php"
#line 370 "smarty_internal_templateparser.y"
    function yy_r85(){ $this->_retvalue = "[".$this->yystack[$this->yyidx + 0]->minor."]";    }
#line 2246 "smarty_internal_templateparser.php"
#line 371 "smarty_internal_templateparser.y"
    function yy_r86(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2249 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r87(){ $this->_retvalue = '['.$this->compiler->compileTag('special_smarty_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2252 "smarty_internal_templateparser.php"
#line 374 "smarty_internal_templateparser.y"
    function yy_r88(){ $this->_retvalue = '['.$this->compiler->compileTag('special_smarty_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2255 "smarty_internal_templateparser.php"
#line 378 "smarty_internal_templateparser.y"
    function yy_r90(){$this->_retvalue = '';    }
#line 2258 "smarty_internal_templateparser.php"
#line 386 "smarty_internal_templateparser.y"
    function yy_r92(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2261 "smarty_internal_templateparser.php"
#line 388 "smarty_internal_templateparser.y"
    function yy_r93(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2264 "smarty_internal_templateparser.php"
#line 390 "smarty_internal_templateparser.y"
    function yy_r94(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2267 "smarty_internal_templateparser.php"
#line 395 "smarty_internal_templateparser.y"
    function yy_r95(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('internal_smarty_var',$this->yystack[$this->yyidx + -1]->minor['index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"))->nocache;}    }
#line 2271 "smarty_internal_templateparser.php"
#line 398 "smarty_internal_templateparser.y"
    function yy_r96(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2274 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r97(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2277 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r98(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2280 "smarty_internal_templateparser.php"
#line 403 "smarty_internal_templateparser.y"
    function yy_r99(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2283 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2286 "smarty_internal_templateparser.php"
#line 405 "smarty_internal_templateparser.y"
    function yy_r101(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2289 "smarty_internal_templateparser.php"
#line 407 "smarty_internal_templateparser.y"
    function yy_r102(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2292 "smarty_internal_templateparser.php"
#line 413 "smarty_internal_templateparser.y"
    function yy_r103(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2301 "smarty_internal_templateparser.php"
#line 424 "smarty_internal_templateparser.y"
    function yy_r104(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2304 "smarty_internal_templateparser.php"
#line 428 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2307 "smarty_internal_templateparser.php"
#line 432 "smarty_internal_templateparser.y"
    function yy_r107(){ return;    }
#line 2310 "smarty_internal_templateparser.php"
#line 437 "smarty_internal_templateparser.y"
    function yy_r108(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor,'false');    }
#line 2313 "smarty_internal_templateparser.php"
#line 438 "smarty_internal_templateparser.y"
    function yy_r109(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor,'true');    }
#line 2316 "smarty_internal_templateparser.php"
#line 450 "smarty_internal_templateparser.y"
    function yy_r110(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2319 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r112(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2322 "smarty_internal_templateparser.php"
#line 455 "smarty_internal_templateparser.y"
    function yy_r113(){$this->_retvalue = ',\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2325 "smarty_internal_templateparser.php"
#line 462 "smarty_internal_templateparser.y"
    function yy_r115(){$this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2328 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r117(){$this->_retvalue =$this->yystack[$this->yyidx + 0]->minor;    }
#line 2331 "smarty_internal_templateparser.php"
#line 469 "smarty_internal_templateparser.y"
    function yy_r118(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2334 "smarty_internal_templateparser.php"
#line 470 "smarty_internal_templateparser.y"
    function yy_r119(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2337 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r120(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2340 "smarty_internal_templateparser.php"
#line 473 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2343 "smarty_internal_templateparser.php"
#line 474 "smarty_internal_templateparser.y"
    function yy_r123(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2346 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2349 "smarty_internal_templateparser.php"
#line 476 "smarty_internal_templateparser.y"
    function yy_r125(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2352 "smarty_internal_templateparser.php"
#line 477 "smarty_internal_templateparser.y"
    function yy_r126(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2355 "smarty_internal_templateparser.php"
#line 478 "smarty_internal_templateparser.y"
    function yy_r127(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2358 "smarty_internal_templateparser.php"
#line 484 "smarty_internal_templateparser.y"
    function yy_r133(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2361 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r134(){$this->_retvalue = '==';    }
#line 2364 "smarty_internal_templateparser.php"
#line 487 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue = '!=';    }
#line 2367 "smarty_internal_templateparser.php"
#line 488 "smarty_internal_templateparser.y"
    function yy_r136(){$this->_retvalue = '>';    }
#line 2370 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r137(){$this->_retvalue = '<';    }
#line 2373 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue = '>=';    }
#line 2376 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue = '<=';    }
#line 2379 "smarty_internal_templateparser.php"
#line 492 "smarty_internal_templateparser.y"
    function yy_r140(){$this->_retvalue = '===';    }
#line 2382 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r141(){$this->_retvalue = '!==';    }
#line 2385 "smarty_internal_templateparser.php"
#line 495 "smarty_internal_templateparser.y"
    function yy_r142(){$this->_retvalue = '&&';    }
#line 2388 "smarty_internal_templateparser.php"
#line 496 "smarty_internal_templateparser.y"
    function yy_r143(){$this->_retvalue = '||';    }
#line 2391 "smarty_internal_templateparser.php"
#line 497 "smarty_internal_templateparser.y"
    function yy_r144(){$this->_retvalue = ' XOR ';    }
#line 2394 "smarty_internal_templateparser.php"
#line 502 "smarty_internal_templateparser.y"
    function yy_r145(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2397 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r147(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2400 "smarty_internal_templateparser.php"
#line 505 "smarty_internal_templateparser.y"
    function yy_r148(){ return;     }
#line 2403 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r149(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2406 "smarty_internal_templateparser.php"
#line 507 "smarty_internal_templateparser.y"
    function yy_r150(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2409 "smarty_internal_templateparser.php"
#line 516 "smarty_internal_templateparser.y"
    function yy_r154(){$this->_retvalue = "`".$this->yystack[$this->yyidx + -1]->minor."`";    }
#line 2412 "smarty_internal_templateparser.php"
#line 517 "smarty_internal_templateparser.y"
    function yy_r155(){$this->_retvalue = '".'.$this->yystack[$this->yyidx + -1]->minor.'."'; $this->compiler->has_variable_string = true;    }
#line 2415 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = '".'.'$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + 0]->minor .'\')->value'.'."'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"))->nocache; $this->compiler->has_variable_string = true;    }
#line 2418 "smarty_internal_templateparser.php"
#line 519 "smarty_internal_templateparser.y"
    function yy_r157(){ $this->_retvalue = '".('.$this->yystack[$this->yyidx + -1]->minor.')."'; $this->compiler->has_variable_string = true;    }
#line 2421 "smarty_internal_templateparser.php"
#line 520 "smarty_internal_templateparser.y"
    function yy_r158(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + -1]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '".$_tmp'.$this->prefix_number.'."'; $this->compiler->has_variable_string = true;    }
#line 2424 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = '$'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2427 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r161(){$this->_retvalue = '`'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2430 "smarty_internal_templateparser.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //TP_yyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 60 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2548 "smarty_internal_templateparser.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 52 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2573 "smarty_internal_templateparser.php"
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int the token number
     * @param mixed the token value
     * @param mixed any extra arguments that should be passed to handlers
     */
    function doParse($yymajor, $yytokenvalue)
    {
//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
