--
--create table commonloginfo
--
CREATE TABLE commonloginfo
(
  optime timestamp without time zone,
  "operator" character varying(20) NOT NULL,
  loglev smallint NOT NULL,
  optype smallint NOT NULL,
  remark text,
  "domain" character varying(20),
  remoteip character varying(16) NOT NULL
) 
WITHOUT OIDS;

--
--create table keyinfo
--
CREATE TABLE keyinfo
(
  serialnum character varying(20) NOT NULL,
  userkey character varying(20) NOT NULL,
  hcounter bigint NOT NULL DEFAULT 0,
  lcounter bigint NOT NULL DEFAULT 0,
  tktype smallint NOT NULL DEFAULT 1,
  predate timestamp without time zone NOT NULL,
  state smallint DEFAULT 0,
  "domain" character varying(20),
  importdate timestamp without time zone NOT NULL,
  diglen smallint NOT NULL DEFAULT 6,
  authwnd int NOT NULL DEFAULT 30,
  tmstep int NOT NULL DEFAULT 60,
  CONSTRAINT keyinfo_pkey PRIMARY KEY (serialnum)
) 
WITHOUT OIDS;

--
--create table operatorinfo
--

CREATE TABLE operatorinfo
(
  operatorid bigint NOT NULL,
  passwd character(40) NOT NULL,
  operatorlev smallint NOT NULL,
  operatorname character varying(20) NOT NULL,
  "domain" character varying(20),
  CONSTRAINT operatorinfo_pkey PRIMARY KEY (operatorid)
) 
WITHOUT OIDS;

--
--create table sysloginfo
--

CREATE TABLE sysloginfo
(
  optime timestamp without time zone NOT NULL,
  "operator" character varying(20) NOT NULL,
  loglev smallint NOT NULL,
  optype smallint NOT NULL,
  remark text NOT NULL,
  "domain" character varying(20)
) 
WITHOUT OIDS;

--
--create table userinfo
--

CREATE TABLE userinfo
(
  username character varying(20) NOT NULL,
  userid character varying(30) NOT NULL,
  contacttel character varying(16) NOT NULL,
  islocked smallint DEFAULT 0,
  failaccum smallint DEFAULT 0,
  preusedate timestamp without time zone,
  serialnum character varying(20),
  isdeleted smallint DEFAULT 0,
  remark text,
  user_email character varying(30),
  "domain" character varying(20),
  pin character varying(20),
  authtype smallint NOT NULL DEFAULT 2,
  CONSTRAINT userinfo_pkey PRIMARY KEY (username)
) 
WITHOUT OIDS;

--
--set intial information
--
insert into operatorinfo values(1000000001, '7c4a8d09ca3762af61e59520943dc26494f8941b', 1, 'super_administrator', NULL);