<?php
header("Content-Type: text/html; charset=utf-8");
session_start();
require_once ("otp_header.php");
include_once("otp_func.php");
include_once("otp_config.php");
include_once($userconf['reldb']."otp_myclass.php");
include_once("otp_const.php");

//optype
$optype = TOKEN_REPAIR;
check_login();
require_once("smarty_header.php");//include smarty header
require_once("smarty_func_reg.php");
$smarty->assign("bgcolor", BODY_BGCOLOR);
$smarty->assign("LANG", $LANG);

//check level
if($_SESSION['valid_lev'] > 4)//operator with a 4+ level is not allowed
{
	$smarty->assign("invalid_lev", $_SESSION["valid_lev"]);
	$smarty->assign("warninfo", $LANG[11162]);
	$smarty->assign("rd_url", "otp_desktop.php");
}
else//user valid
{	//query token information
	if(isset($_GET['page_size']))
	{
		$page_size = $_GET['page_size'];
	}
	else
	{
		$page_size = OTP_PAGE_SIZE;	
	}
	try
	{
		$cur_page = 1;//current page
		//$page_size = 15;
		$offset = 0;
		if(isset($_POST['token_query']))//token query
		{
			if(isset($_SESSION['bind_tk']))
			{
				unset($_SESSION['bind_tk']);
			}
			if(isset($_SESSION['unbound_tk']))
			{
				unset($_SESSION['unbound_tk']);
			}
			if(isset($_SESSION['expired_tk']))
			{
				unset($_SESSION['expired_tk']);
			}
			$conditioncount = 0;
			if(isset($_POST['bind_tk']))
			{
				$conditioncount++;
				$_SESSION['bind_tk'] = 1;
			}
			if(isset($_POST['unbound_tk']))
			{
				$conditioncount++;
				$_SESSION['unbound_tk'] = 1;
			}
			if(isset($_POST['expired_tk']))
			{
				$conditioncount++;
				$_SESSION['expired_tk'] = 1;
			}
			if(0 === $conditioncount)
			{
				throw new Exception($LANG[100]);
			}
			
		}//
		else if(!isset($_GET['cur']) || !isset($_GET['page_size']) || (!isset($_SESSION['bind_tk']) && !isset($_SESSION['unbound_tk']) && !isset($_SESSION['expired_tk'])))
		{
			throw new Exception($LANG[80]);
		}
		else
		{
			$cur_page = $_GET['cur'];
			$page_size = $_GET['page_size'];
			if($cur_page <= 0 || $page_size <= 0)
			{
				throw new Exception($LANG[80]);	
			}
			$offset = ($cur_page-1)*$page_size;
		}		
	
		//bd connector
		$mydb = new mydb();
		if(!@($mydb->connect($mydbhost, $mydbuser, $mydbpw, $port, $mydbname,$mydbcharset)))
		{
			throw new Exception($LANG[11017]);
		}
		else
		{
			//construct sql statement
			//unbound-0 bind-1 expired-2
			$sql_condition = "";
			if(isset($_SESSION['bind_tk']))
			{
				$sql_condition .= " where state=1";
				if(isset($_SESSION['unbound_tk']))
				{
					$sql_condition .= " or state=0";
				}
				if(isset($_SESSION['expired_tk']))
				{
					$sql_condition .= " or state=2";
				}
			}
			else if(isset($_SESSION['unbound_tk']))
			{
				$sql_condition .= " where state=0";
				if(isset($_SESSION['expired_tk']))
				{
					$sql_condition .= " or state=2";
				}
			}
			else
			{
				$sql_condition .= " where state=2";
			}
			//sql/total_page/
			
			$sql = "select count(serialnum) from keyinfo ".$sql_condition;			
			if(!(@($result=$mydb->query($sql))))//query token information
			{
				throw new Exception($LANG[10013]);
			}
			if(@!($re=$mydb->fetch_row($result)))//no related item
			{
				throw new Exception($LANG[96]);	
			}
			//total page
			if(0 == $re[0])
			{
				throw new Exception($LANG[96]);	
			}
			$total_page = ceil($re[0]/$page_size);
			$sql = "select serialnum, tktype, state, "._to_char('predate', $dbtype).", "._to_char('importdate', $dbtype)." from keyinfo ".$sql_condition;
			if($cur_page <= $total_page)
			{
				switch($dbtype)
				{
					case 1:
						$sql .= " limit ".$offset.", ".$page_size;
						break;
					case 2:
						$sql .= " limit ".$page_size." offset ".$offset;
						break;
					case 3:
						$endrow = $offset+$page_size;
						$sql =	"select serialnum, tktype, state, predate, importdate from (select ROW_NUMBER() OVER (ORDER BY serialnum asc) as rownum,serialnum, tktype, state, "._to_char('predate', $dbtype).", "._to_char('importdate', $dbtype)." from keyinfo ".$sql_condition.") 
					as t where t.rownum >= ".$offset." and t.rownum < ".$endrow;
						break;
					case 4:
						$endrow = $offset+$page_size;
						$sql="SELECT * FROM (SELECT A.*, ROWNUM RN FROM (select serialnum, tktype, state, "._to_char('predate', $dbtype).", "._to_char('importdate', $dbtype)." from keyinfo ".$sql_condition.")".
							 'A WHERE ROWNUM <= '.$endrow.') WHERE RN >= '.$offset;		
						break;
				}
			}
			else
			{
				throw new Exception($LANG[80]);	
			}
			$smarty->assign("total_page", $total_page);
			$smarty->assign("cur_page", $cur_page);
			$smarty->assign("page_size", $page_size);
			$smarty->assign("pre_page", $cur_page-1);
			$smarty->assign("next_page", $cur_page+1);
			$smarty->assign("page_size", $page_size);
			$smarty->assign("count", 30);
			
			if(!(@($result=$mydb->query($sql))))//query token information
			{
				throw new Exception($LANG[10013]);
			}
			$res_arr = array();
			while(@($re=$mydb->fetch_row($result)))//no related item
			{
				array_push($res_arr, $re);	
			}
			$smarty->assign("res_arr", $res_arr);
		}
	}
	catch(Exception $e)
	{
		$smarty->assign("excp_info", $e->GetMessage());
		$smarty->assign("errinfo", $e->GetMessage());
		$smarty->assign("rd_url", "otp_token_mg.php");
	}
}
$smarty->display("otp_token_mg_pg.tpl");
?>