<?php
ini_set( "display_errors", 0);
header("Content-Type: text/html; charset=utf-8");
session_start();
require_once("otp_header.php");
include_once("otp_func.php");
include_once("otp_config.php");
include_once($userconf['reldb'] . "otp_myclass.php");
include_once("otp_const.php");
include_once("otp_AES.php");

check_login();
require_once("smarty_header.php");
require_once("smarty_func_reg.php");
$smarty->assign("bgcolor", BODY_BGCOLOR);
$smarty->assign("LANG", $LANG);
$smarty->assign("sharekeylen", OTP_SHAREKEY_SIZE);

$optype = USER_TOKEN_IMPORT;

if ($_SESSION['valid_lev'] > 4) {
    $smarty->assign("invalid_lev", $_SESSION['valid_lev']);
    $smarty->assign("warninfo", $LANG[11162]);
    $smarty->assign("rd_url", "otp_usermg_m1.php");
}

// ==================== Support functions ====================
// The backoff function during contention
function backoff()
{
    $miliSeconds = rand(0, 100);
    //Sleep for 0 - 100 miliseconds, to avoid collision
    usleep(round($miliSeconds * 1000));
}

// Replace a Setting in the ini
// bool set_ini(string $old_filename, string $new_filename)
// $old_filename = The old log file name
// $new_filename = the new log file name
function set_ini($old_filename, $new_filename)
{
    // Open the file for writing
    $fp       = fopen('feedback_server.ini', 'c+');
    $canWrite = false;
    //Waiting until file is locked for writing
    while (!$canWrite) {
        $canWrite = flock($fp, LOCK_EX);
        backoff();
    }
    $content     = fread($fp, filesize('feedback_server.ini'));
    $new_content = str_replace($old_filename, $new_filename, $content);
    ftruncate($fp, 0);
    fseek($fp, SEEK_SET);
    fwrite($fp, $new_content);
    fclose($fp);
}
// The function to convert ANY integers to hex
// We use it in the script to convert 64-bit integer to hex
// Input: Decimal string
// Output: Hex string
// ******** In this function we pad zeros in front of the result hex to represent the number as 64-bits
function dec2hex($str)
{
    $hex      = array(
        '0',
        '1',
        '2',
        '3',
        '4',
        '5',
        '6',
        '7',
        '8',
        '9',
        'A',
        'B',
        'C',
        'D',
        'E',
        'F'
    );
    // Result value
    $hexval   = '';
    // The quotient of each division operation
    $quotient = $str;
    $divisor  = $str;
    // The ending condition
    $flag     = true;
    while ($flag) {
        $len       = strlen($divisor);
        $pos       = 1;
        $quotient  = 0;
        // Take the first two digits as temp divisor and advance by 1 each iteration
        $div       = substr($divisor, 0, 2);
        $remainder = $div[0];
        while ($pos < $len) {
            // Calculate the next div
            $div       = $remainder == 0 ? $divisor[$pos] : $remainder . $divisor[$pos];
            $remainder = $div % 16;
            $quotient  = $quotient . floor($div / 16);
            $pos++;
        }
        // Recast the divisor as string to make the $divisor[$pos] work
        $quotient = trim_left_zeros($quotient);
        $divisor  = "$quotient";
        $hexval   = $hex[$remainder] . $hexval;
        // If the divisor is smaller than 15 then end the iteration
        if (strlen($divisor) <= 2) {
            if ($divisor < 15) {
                $flag = false;
            }
        }
    }
    $hexval = $hex[$quotient] . $hexval;
    $hexval = trim_left_zeros($hexval);
    // Pad zeros (only because we are using this function for 64-bit integers)
    //$hexval = str_repeat('0', 16-strlen($hexval)).$hexval;
    return $hexval;
}

// Trim the zeros at the left of a number
function trim_left_zeros($str)
{
    $str = ltrim($str, '0');
    if (empty($str)) {
        $str = '0';
    }
    return $str;
}

function parse_counter($str)
{
    // Convert the decimal string to hex
    $hexstr = dec2hex("" . $str);
	
	$hexstr = str_pad($hexstr, 16, "0", STR_PAD_LEFT);//pads the hext string to 16 to avoid problem described below
	
    // Split the hex string into two halves, the first half containing hcounter, the second half containing lcounter
    // Note: This is on the assumption that the resulting hex value from the passed decimal string will always result in a hex value 8 digits in length
    // Convert the hex string to decimal, and return the two values in an array
    $array = array(hexdec(substr($hexstr, 0, strlen($hexstr)/2)), hexdec(substr($hexstr, strlen($hexstr)/2, strlen($hexstr)/2)));
    return $array;
}

try {
    // Token import
    if (isset($_POST['imtoken1'])) {
        //check share key validation
        if (!isset($_POST['serialn']) || !isset($_POST['userkey']) || ($serialnum = $_POST['serialn']) == "" || ($userkey = $_POST['userkey']) == "") {
            throw new Exception($LANG[11148]);
        }

        $mydb = new mydb();

        if (!@($mydb->connect($mydbhost, $mydbuser, $mydbpw, $port, $mydbname, $mydbcharset))) {
            throw new Exception($LANG[11017]);
        }

        $sql = 'INSERT INTO keyinfo (serialnum,userkey) VALUES (\'' . $serialnum . '\',\'' . $userkey . '\')';
        
        if (!(@($result = $mydb->query($sql)))) {
            throw new Exception($LANG[10013]);
        }
        
        switch (_makelog($mydb, $_SESSION['valid_optor'], $_SESSION['valid_lev'], _date("Y-m-d H:i:s", $dbtype), $LANG[1048] . $serialnum, $optype)) {
            case -2:
                echo $LANG[10020];
                break;
            case -1:
                echo $LANG[10021];
                break;
            default:
                break;
        }
        echo $LANG[11142];
        echo '<br>
			<a href="otp_optormg_m4.php">' . $LANG[11006] . '</a>
			';
        exit;
    }
    // Import one token
    else if (isset($_POST['imtoken2'])) {
        $err_tmp = "";
     //   if (!isset($_POST['share_key']) || (strlen($_POST['share_key']) != OTP_SHAREKEY_SIZE)) {
     //       throw new Exception($LANG[24]);
     //   }
        $share_key = $_POST['share_key'];
        $ext       = explode(".", $_FILES['imfile']['name']);
        if (strtolower($ext[count($ext) - 1]) != "uinf") {
		if (strtolower($ext[count($ext) - 1]) != "xml"){
            throw new Exception($LANG[11047]);
			}
        }
        
        // ".uinf" file extension
        if (strtolower($ext[count($ext) - 1]) == "uinf") {
            // Check for errors
            if ($_FILES["imfile"]["error"] > 0) {
                throw new Exception($LANG[1051] . $_FILES["imfile"]["error"]);
            }
            // Check existing files
            if (file_exists("upload/" . $_FILES["imfile"]["name"])) {
                throw new Exception($LANG[1054]);
            }
            if (!@move_uploaded_file($_FILES["imfile"]["tmp_name"], "upload/" . $_FILES["imfile"]["name"])) {
                throw new Exception($LANG[21]);
            }

            $srcfile = "upload/" . $_FILES["imfile"]["name"];

            // Decrypt file
			if (strlen ($share_key)>0){
				$aes = new AES();
				if (!$aes->decryptFile(dirname($srcfile), basename($srcfile), $share_key)) {
					throw new Exception($LANG[25]);
				}
			
            @unlink($srcfile);
            $srcfile = dirname($srcfile) . "/de" . basename($srcfile);
            }
            // Connect to database
            $mydb = new mydb();
            if (!@($mydb->connect($mydbhost, $mydbuser, $mydbpw, $port, $mydbname, $mydbcharset))) {
                throw new Exception($LANG[11017]);
            }
           
            // Open file
            if (!@($fp = fopen($srcfile, "rb"))) {
                throw new Exception($LANG[11048]);
            }

            // Validate file tag
            if (!feof($fp)) {
                $tkcheck_tag = trim(fgets($fp));
                
                if (strtolower($tkcheck_tag) != "secu_uniotp") {
                    fclose($fp);
                    throw new Exception($LANG[26]);
                }
            }
            
            $curline = 1;
            $nullnum = 0;
            $str_add = "";
			 
            // Loop through file by line
            //key information  format:serialnum|userkey|hcounter|lcounter|token type|start date|diglen|auth wnd|time step|
            while (!feof($fp)) {
                $cur = fgets($fp);
                @list($serialnum, $userkey, $hcounter, $lcounter, $tktype, $predate, $diglen, $authwnd, $tmstep) = explode("|", $cur);
                $serialnum = trim($serialnum);
                $userkey   = trim($userkey);
                if (!isset($serialnum) || !isset($userkey) || !isset($hcounter) || !isset($lcounter) || !isset($tktype) || !isset($predate) || "" === $serialnum || "" === $userkey || "" == $predate || (strlen($serialnum) > OTP_SERIALNUM_SIZE) || (strlen($userkey) != OTP_KEY_LEN)) {
                    $str_add = $str_add . "Notice:bad line " . ($curline + $nullnum) . " in file" . $srcfile . ".<br>";
                    ++$nullnum;
                    continue;
                }
				/*
				//perform the predate time correction function
				// ><><><><><><| inserted not tested |><><><><><><
				//grab details from uinf
				$uinfmins = substr($predate, 14, 2);//gets the mins from the uinf entry (needed for india)
				$uinfhour = substr($predate, 11, 2);//gets the hour from the uinf entry
				$uinfday = substr($predate, 8, 2);//incase they did it at midnight
				$uinfmonth = substr($predate, 5, 2);//incase they did it on the first or last day of the month
				$uinfyear = substr($predate, 0, 4);//incase they're working on years day?
				$uinfremainder = substr($predate, 16);//grabs remainder of the uinf entry

				//gets the current server time offset, based off... Magic? Not sure if this will actually work
				$timestamp = time(); 
				//$DSTserver = date('I'); //true for DST, false for not NOT NEEDED
				$servertime =  date('c', $timestamp);//get time in server, use this instead of Unix seconds for UTC time
				$timezonevalue = substr($servertime, 20, 2); //0~x hour offset
				$timezonevalueodd = substr($servertime, 23, 2); //minutes offset
				$timezonesign = substr($servertime, 19, 1); //+ or -
				$timezonehours = intval($timezonevalue);
				$timezoneminutes = intval($timezonevalueodd);
				*/
				 /* DST RULE: The clock moves ahead (= losing one hour) when DST starts, and falls back one hour (= gaining one hour) when DST ends 
				 Remember that DST offsets are not always an integer number of hours (e.g. Indian Standard Time is UTC+05:30).
					function date('c', $timestamp); does daylight saving automatically
				 if ($DSTserver === true){
					$timezonehours = $timezonehours + 1; //IDK if this is done automatically by date('c', $timestamp);
				}
				 */
					/*
				//needed for calculating offset
				if ($timezonesign === "-"){
					$timezonehours = $timezonehours * -1;
					$timezoneminutes = $timezoneminutes * -1;
				}

				$uinfhourint = intval($uinfhour);
				//calculates minute zone differences
				if ($timezoneminutes != 0){
					$uinfminsint = intval($uinfmins);
					$uinfminsint = $uinfminsint - $timezoneminutes;
					if ($uinfminsint < 0){
					$uinfhourint=$uinfhourint-1;
					}else if ($uinfminsint > 59){
					$uinfhourint=$uinfhourint+1;
					}
					$uinfmins = strval($uinfminsint);
				}

				//calculate hour and possibly date offset
				$timeoffset = 8 - $timezonehours; //8 is china, eg. 8 - 10(syd) = -2
				$uinfhourint = intval($uinfhour);
				$uinfhourint = $uinfhourint - $timeoffset; //subtract offset eg. china time needs +2 for syd as it's -2
				$uinfdayint = intval($uinfday);
				//if has to go back a day
				if ($uinfhourint < 0){
					$uinfhourint = 24 + $uinfhourint;
					$uinfdayint = $uinfdayint - 1;
					//if that day is first day of month
					if ($uinfdayint === 0){
						$uinfmonthint = intval($uinfmonth);
						$uinfmonthint = $uinfmonthint - 1;
						$uinfyearint = intval($uinfyear);
						//if Janurary, at new years day....
						if ($uinfmonthint === 0){//was Janurary
							$uinfmonthint = 12;//now December
							$uinfyearint = $uinfyearint - 1;
						}
						$uinfyear = strval($uinfyearint);
						$uinfmonth = strval($uinfmonthint);
						$uinfdayint = cal_days_in_month(CAL_GREGORIAN, $uinfmonthint, $uinfyearint);
					}
					//if has to go forward a day
				}else if ($uinfhourint > 23){
					$uinfhourint = $uinfhourint - 24;
					$uinfdayint = $uinfdayint + 1;
					$uinfmonthint = intval($uinfmonth);
					$uinfyearint = intval($uinfyear);
					//get last day of the month
					$maxdayint = cal_days_in_month(CAL_GREGORIAN, $uinfmonthint, $uinfyearint);
					//if last day of month, need to inc month
					if ($uinfdayint > $maxdayint){
					$uinfdayint = 1;
					$uinfmonthint = $uinfmonthint + 1;
						//if december, at midnight....
						if ($uinfmonthint === 13){
							$uinfmonthint = 1;
							$uinfyearint = $uinfyearint + 1;
							$uinfyear = strval($uinfyearint);
						}
					}
					$uinfmonth = strval($uinfmonthint);
				}

				//to make sure string is correct format
				if (strlen($uinfmonth) === 1){
				$uinfhour = "0" . $uinfhour;
				}
				if (strlen($uinfmins) === 1){
				$uinfmins = "0" . $uinfmins;
				}
				$uinfhour = strval($uinfhourint);
				if (strlen($uinfhour) === 1){
				$uinfhour = "0" . $uinfhour;
				}
				$uinfday = strval($uinfdayint);
				if (strlen($uinfday) === 1){
				$uinfday = "0" . $uinfday;
				}

				$predate = $uinfyear . "-" . $uinfmonth . "-" . $uinfday . " " . $uinfhour . ":" . $uinfmins . $uinfremainder;
				*/
				//><><><><| end inserted code |><><><><><
				
                $sql = "INSERT INTO keyinfo (serialnum, userkey, hcounter, lcounter, tktype, predate, importdate, diglen, authwnd, tmstep) VALUES ('$serialnum','$userkey', $hcounter, $lcounter, $tktype, " . _to_date($predate, $dbtype) . ", " . _to_date(gmdate('Y-m-d H:i:s'), $dbtype) . ", $diglen, $authwnd, $tmstep)";
                //sql execute
                if (!(@($result = $mydb->query($sql)))) {
                    //$err_tmp = $str_add.$serialnum.$LANG[11]." <br> ";
                    $str_add = $str_add . $serialnum . $LANG[11] . " <br> ";
                    //@ fclose($fp);
                    //throw new Exception($LANG[10013].$LANG[11049].$curline);
                    --$curline;
                }
                ++$curline;
            }
           
            --$curline;
            $str_add2 = "";
            switch (_makelog($mydb, $_SESSION['valid_optor'], $_SESSION['valid_lev'], _date("Y-m-d H:i:s", $dbtype), $LANG[1051] . $curline . $LANG[1052], $optype)) {
                case -2:
                    $str_add2 = $str_add2 . $LANG[10020] . " <br> ";
                    break;
                case -1:
                    $str_add2 = $str_add2 . $LANG[10021] . " <br> ";
                    break;
                default:
                    break;
            }
            @fclose($fp);
            if (!unlink($srcfile)) {
                $str_add2 = $str_add2 . $LANG[1055] . " <br> ";
            }
            if ($str_add == "" && $str_add2 == "") {
                $smarty->assign("import_succ", 1);
                $smarty->assign("doneinfo", $LANG[11142] . " <br> " . $curline . $LANG[10]);
                $smarty->assign("rd_url", "otp_optormg_m4.php");
            } else if ($str_add != "") {
                throw new Exception($LANG[9] . " <br> " . $str_add);
            } else {
                throw new Exception($str_add2);
            }
        }
        // ".xml" file extension
        else if(strtolower($ext[count($ext) - 1]) == "xml") {
		
		
            // Check for errors
            if ($_FILES["imfile"]["error"] > 0) {
                //throw new Exception($LANG[1051] . $_FILES["imfile"]["error"]);
            }
            // Check existing files
            if (file_exists("upload/" . $_FILES["imfile"]["name"])) {
                throw new Exception($LANG[1054]);
            }
            if (!@move_uploaded_file($_FILES["imfile"]["tmp_name"], "upload/" . $_FILES["imfile"]["name"])) {
                throw new Exception($LANG[21]);
            }

            $srcfile = "upload/" . $_FILES["imfile"]["name"];

            // Decrypt file
			if (strlen ($share_key)>0){
            $aes = new AES();
            if (!$aes->decryptFile(dirname($srcfile), basename($srcfile), $share_key)) {
                throw new Exception($LANG[25]);
            }
			
            @unlink($srcfile);
            $srcfile = dirname($srcfile) . "/de" . basename($srcfile);
			}
            // Connect to database
            $mydb = new mydb();
            if (!@($mydb->connect($mydbhost, $mydbuser, $mydbpw, $port, $mydbname, $mydbcharset))) {
                throw new Exception($LANG[11017]);
            }
          
            // Open file
            if (!@($fp = fopen($srcfile, "rb"))) {
                throw new Exception($LANG[11048]);
            }

            // Validate file tag
            /*if (!feof($fp)) {
                $tkcheck_tag = trim(fgets($fp));
                
                if (strtolower($tkcheck_tag) != "secu_uniotp") {
                    fclose($fp);
                    throw new Exception($LANG[26]);
                }
            }*/
               
            $curline = 1;
            $nullnum = 0;
            $str_add = "";

            // Parse XML
		//	$contents = fread($fp, filesize($srcfile));

            $xml = new SimpleXMLElement($srcfile, null, true); // TODO Check $fp is the XML file we're looking for

            foreach($xml as $KeyPackage) {
			
                $serialnum  = $KeyPackage->DeviceInfo->SerialNo;
                $userkey    = base64_decode($KeyPackage->Key->Data->Secret->PlainValue);
				$tktypetemp = $KeyPackage->Key->attributes(); //Gets Algorithm="urn:ietf:params:xml:ns:keyprov:pskc:hotp" Id="1"
				$tktypetemp = strtolower($tktypetemp); //just incase
				$pos = strpos($tktypetemp, "hotp");
				if ($pos === false){
				$tktype=2;//TOTP UniOTP500
				 $counter    = parse_counter($KeyPackage->Key->Data->Time->PlainValue);
				 $tmstep     = $KeyPackage->Key->Data->TimeInterval->PlainValue;
				 $authwnd    = "30"; //Assumed
				}else{
				$tktype=1;//HOTP UniOTP300
				 $counter    = parse_counter($KeyPackage->Key->Data->Counter->PlainValue);
				$authwnd    = "30"; //Assumed
                $tmstep     = "60"; //Given even though not used
				}
                $hcounter   = $counter[0];
                $lcounter   = $counter[1];
                $predate    = "1970-01-01 00:00:00";//not sure if this works
                $importdate = gmdate('Y-m-d H:i:s');//not sure if this works
				$diglentemp = $KeyPackage->Key->AlgorithmParameters->ResponseFormat->attributes();
				$diglentemp = strtolower($diglentemp); //just incase
				$pos = strpos($diglentemp, "length");//gives the position of where L is, want to find number
				$diglenfound = false;
				$temppoint = $pos;
				
				while ($diglenfound == false){
				$tempvaluefound = substr($diglentemp,$temppoint,1);
					if (is_numeric($tempvaluefound)==true){
					$diglenfound=true;
					$diglen = $tempvaluefound;
					}
				$temppoint = $temppoint + 1;
				}

				/*
				//perform the predate time correction function
				// ><><><><><><| inserted not tested |><><><><><><
				//grab details from uinf
				$uinfmins = substr($predate, 14, 2);//gets the mins from the uinf entry (needed for india)
				$uinfhour = substr($predate, 11, 2);//gets the hour from the uinf entry
				$uinfday = substr($predate, 8, 2);//incase they did it at midnight
				$uinfmonth = substr($predate, 5, 2);//incase they did it on the first or last day of the month
				$uinfyear = substr($predate, 0, 4);//incase they're working on years day?
				$uinfremainder = substr($predate, 16);//grabs remainder of the uinf entry

				//gets the current server time offset, based off... Magic? Not sure if this will actually work
				$timestamp = time(); 
				//$DSTserver = date('I'); //true for DST, false for not NOT NEEDED
				$servertime =  date('c', $timestamp);//get time in server, use this instead of Unix seconds for UTC time
				$timezonevalue = substr($servertime, 20, 2); //0~x hour offset
				$timezonevalueodd = substr($servertime, 23, 2); //minutes offset
				$timezonesign = substr($servertime, 19, 1); //+ or -
				$timezonehours = intval($timezonevalue);
				$timezoneminutes = intval($timezonevalueodd);
				*/
				 /* DST RULE: The clock moves ahead (= losing one hour) when DST starts, and falls back one hour (= gaining one hour) when DST ends 
				 Remember that DST offsets are not always an integer number of hours (e.g. Indian Standard Time is UTC+05:30).
					function date('c', $timestamp); does daylight saving automatically
				 if ($DSTserver === true){
					$timezonehours = $timezonehours + 1; //IDK if this is done automatically by date('c', $timestamp);
				}
				 */
					/*
				//needed for calculating offset
				if ($timezonesign === "-"){
					$timezonehours = $timezonehours * -1;
					$timezoneminutes = $timezoneminutes * -1;
				}

				$uinfhourint = intval($uinfhour);
				//calculates minute zone differences
				if ($timezoneminutes != 0){
					$uinfminsint = intval($uinfmins);
					$uinfminsint = $uinfminsint - $timezoneminutes;
					if ($uinfminsint < 0){
					$uinfhourint=$uinfhourint-1;
					}else if ($uinfminsint > 59){
					$uinfhourint=$uinfhourint+1;
					}
					$uinfmins = strval($uinfminsint);
				}

				//calculate hour and possibly date offset
				$timeoffset = 8 - $timezonehours; //8 is china, eg. 8 - 10(syd) = -2
				$uinfhourint = intval($uinfhour);
				$uinfhourint = $uinfhourint - $timeoffset; //subtract offset eg. china time needs +2 for syd as it's -2
				$uinfdayint = intval($uinfday);
				//if has to go back a day
				if ($uinfhourint < 0){
					$uinfhourint = 24 + $uinfhourint;
					$uinfdayint = $uinfdayint - 1;
					//if that day is first day of month
					if ($uinfdayint === 0){
						$uinfmonthint = intval($uinfmonth);
						$uinfmonthint = $uinfmonthint - 1;
						$uinfyearint = intval($uinfyear);
						//if Janurary, at new years day....
						if ($uinfmonthint === 0){//was Janurary
							$uinfmonthint = 12;//now December
							$uinfyearint = $uinfyearint - 1;
						}
						$uinfyear = strval($uinfyearint);
						$uinfmonth = strval($uinfmonthint);
						$uinfdayint = cal_days_in_month(CAL_GREGORIAN, $uinfmonthint, $uinfyearint);
					}
					//if has to go forward a day
				}else if ($uinfhourint > 23){
					$uinfhourint = $uinfhourint - 24;
					$uinfdayint = $uinfdayint + 1;
					$uinfmonthint = intval($uinfmonth);
					$uinfyearint = intval($uinfyear);
					//get last day of the month
					$maxdayint = cal_days_in_month(CAL_GREGORIAN, $uinfmonthint, $uinfyearint);
					//if last day of month, need to inc month
					if ($uinfdayint > $maxdayint){
					$uinfdayint = 1;
					$uinfmonthint = $uinfmonthint + 1;
						//if december, at midnight....
						if ($uinfmonthint === 13){
							$uinfmonthint = 1;
							$uinfyearint = $uinfyearint + 1;
							$uinfyear = strval($uinfyearint);
						}
					}
					$uinfmonth = strval($uinfmonthint);
				}

				//to make sure string is correct format
				if (strlen($uinfmonth) === 1){
				$uinfhour = "0" . $uinfhour;
				}
				if (strlen($uinfmins) === 1){
				$uinfmins = "0" . $uinfmins;
				}
				$uinfhour = strval($uinfhourint);
				if (strlen($uinfhour) === 1){
				$uinfhour = "0" . $uinfhour;
				}
				$uinfday = strval($uinfdayint);
				if (strlen($uinfday) === 1){
				$uinfday = "0" . $uinfday;
				}

				$predate = $uinfyear . "-" . $uinfmonth . "-" . $uinfday . " " . $uinfhour . ":" . $uinfmins . $uinfremainder;
				//><><><><| end inserted code |><><><><><
					*/

                $sql = "INSERT INTO keyinfo (serialnum, userkey, hcounter, lcounter, tktype, predate, importdate, diglen, authwnd, tmstep) VALUES ('$serialnum','$userkey', $hcounter, $lcounter, $tktype, " . _to_date($predate, $dbtype) . ", " . _to_date(gmdate('Y-m-d H:i:s'), $dbtype) . ", $diglen, $authwnd, $tmstep)";
                //sql execute
                if (!(@($result = $mydb->query($sql)))) {
                    //$err_tmp = $str_add.$serialnum.$LANG[11]." <br> ";
                    $str_add = $str_add . $serialnum . $LANG[11] . " <br> ";
                    //@ fclose($fp);
                    //throw new Exception($LANG[10013].$LANG[11049].$curline);
                    --$curline;
                }
                
                ++$curline;
            }
            
            --$curline;
            $str_add2 = "";
            switch (_makelog($mydb, $_SESSION['valid_optor'], $_SESSION['valid_lev'], _date("Y-m-d H:i:s", $dbtype), $LANG[1051] . $curline . $LANG[1052], $optype)) {
                case -2:
                    $str_add2 = $str_add2 . $LANG[10020] . " <br> ";
                    break;
                case -1:
                    $str_add2 = $str_add2 . $LANG[10021] . " <br> ";
                    break;
                default:
                    break;
            }
            @fclose($fp);
            if (!unlink($srcfile)) {
                $str_add2 = $str_add2 . $LANG[1055] . " <br> ";
            }
            if ($str_add == "" && $str_add2 == "") {
                $smarty->assign("import_succ", 1);
                $smarty->assign("doneinfo", $LANG[11142] . " <br> " . $curline . $LANG[10]);
                $smarty->assign("rd_url", "otp_optormg_m4.php");
            } else if ($str_add != "") {
                throw new Exception($LANG[9] . " <br> " . $str_add);
            } else {
                throw new Exception($str_add2);
            }
        }
        // Unknown file type
        else {
            //throw new Exception($LANG[11047]);
        }
    }
}
catch (Exception $e) {
    $str_add = "";
    if (isset($srcfile) && file_exists($srcfile)) {
        if (!unlink($srcfile)) {
            $str_add = $str_add . $LANG[1055] . " <br> ";
        }
    }
    if (!isset($mydb) || !$mydb) {
        $mydb = new mydb();
        if (!($mydb->connect($mydbhost, $mydbuser, $mydbpw, $port, $mydbname, $mydbcharset))) {
            $str_add = $str_add . $LANG[11017];
        }
    }
    // Generate log
    switch (_makelog($mydb, $_SESSION['valid_optor'], $_SESSION['valid_lev'], _date("Y-m-d H:i:s", $dbtype), $e->GetMessage(), $optype)) {
        case -2:
            $str_add = $str_add . $LANG[10020] . " <br> ";
            break;
        case -1:
            $str_add = $str_add . $LANG[10021] . " <br> ";
            break;
        default:
            break;
    }
    $str_add .= $e->GetMessage();
    $str_add .= "<br/><a href='tkerr_export.php'>" . $LANG[34] . "</a>";
    $smarty->assign("excp_info", 1);
    $smarty->assign("errinfo", $str_add);
    $smarty->assign("rd_url", "otp_optormg_m4.php");
    
    // Token error
    $_SESSION['import_token_error'] = $str_add;
}
$smarty->display("otp_optormg_m4.tpl");

?>
