<?php
require_once ("otp_header.php");
include_once("otp_config.php");
include_once("lang/".$userconf['lang']."/otp_user.php");
include_once("otp_const.php");
include_once("secu_otp_hmac.php");

/*
//SYNCHRONIZE OTP MGS TO EXTERNAL WEBSITE TIME, not feasible

  // ntp time servers to contact
  // we try them one at a time if the previous failed (failover)
  // if all fail then wait till tomorrow
  $time_servers = array("time.nist.gov",
                        "nist1.datum.com",
                        "time-a.timefreq.bldrdoc.gov",
                        "utcnist.colorado.edu");

  // date and clock programs (change for your system)
  //might look into this and see if it is possible to force a change in the server
 // $date_app  = "/bin/date";
 // $clock_app = "/sbin/clock";

  // a flag and number of servers
  $valid_response = false;
  $ts_count = sizeof($time_servers);

  // time adjustment
  // I'm in California and the clock will be set to -0800 UTC [8 hours] for PST
  // you will need to change this value for your region (seconds)
  $time_adjustment = 0;

  for ($i=0; $i<$ts_count; $i++) {
    $time_server = $time_servers[$i];
    $fp = fsockopen($time_server, 37, $errno, $errstr, 2);
    if (!$fp) {
		//external server is down
    } else {
      $data = NULL;
      while (!feof($fp)) {
        $data .= fgets($fp, 128);
      }
      fclose($fp);
		// we have a response...is it valid? (4 char string -> 32 bits)
      if (strlen($data) != 4) {
		//invalid response
      } else {
		//should of received time correctly
        $valid_response = true;
        break;
      }
    }
  }

  if ($valid_response) {
    // time server response is a string - convert to numeric
    $NTPtime = ord($data{0})*pow(256, 3) + ord($data{1})*pow(256, 2) + ord($data{2})*256 + ord($data{3});

    // convert the seconds to the present date & time
    // 2840140800 = Thu, 1 Jan 2060 00:00:00 UTC
    // 631152000  = Mon, 1 Jan 1990 00:00:00 UTC
    $TimeFrom1990 = $NTPtime - 2840140800;
    $TimeNow = $TimeFrom1990 + 631152000; //supposedly the correct number of seconds since UTC

	date_timestamp_set($TimeNow);
    // set the system time
   // $TheDate = date("m/d/Y H:i:s", $TimeNow + $time_adjustment);
  //  $success = exec("$date_app -s \"$TheDate\"");

    // set the hardware clock (optional) - you may want to comment this out
   // exec("$clock_app --systohc");

  //  echo "The server's date and time was set to $success\n";
  } else {
  
  //failed to synchronize, use local server time
  //  echo "The system time could not be updated. No time servers available.\n";
  }
*/
date_default_timezone_set (OTP_TIMEZONE);
/********************************************************
* function: display top header of web page
* in parameter:		 $info -- header information
* out parameter:    N/A
* return  N/A
********************************************************/
function dis_header($info)
{
	echo '
	<head>
		<title>'.$info.
		'</title>
	</head>
	';
}
/********************************************************
* function: smarty function for displaying top header
* in parameter:		 $info 
* out parameter:    N/A
* return  N/A
********************************************************/
function smarty_dis_header($params)
{//$info
	extract($params);
	echo '
	<head>
		<title>'.$info.
		'</title>
	</head>
	';
}
/********************************************************
* function: display content
* in parameter: $cont
* out parameter:	N/A
* return N/A
********************************************************/
function dis_content($cont)
{
	echo "<div style=\"background-color:#aaaaaa\">";
	echo $cont;
	echo "</div>";
}
/********************************************************
* function: display content
* in parameter: $cont
* out parameter:	N/A
* return N/A
********************************************************/
function smarty_dis_content($params)
{//$cont
	extract($params);
	
	echo "<div style=\"background-color:#aaaaaa\">";
	echo $cont;
	echo "</div>";
}

/*******************************************************
* function: display bottom
* in parameter: $url
* out parameter: N/A
* return N/A
*******************************************************/
function dis_footer($url)
{
	echo '
	<hr>
	<meta http-equiv = "refresh" content = 3; URL ='.$url.'>
	<center>OTPMS</center>
	';
	exit;
}

/*******************************************************
* function: smarty function for displaying bottom
* in parameter: $url
* out parameter: N/A
* return N/A
*******************************************************/
function smarty_dis_footer($params)
{//$url
	extract($params);
	echo '
	<hr>
	<meta http-equiv = "refresh" content = 3; URL ='.$url.'>
	<center>OTPMS</center>
	';
	exit;
}

//show authentication result
/********************************************************
* function: show authentication result
* in parameter: $info 
*								$ref  URL for goback
* out parameter: N/A
* return N/A
*******************************************************/
Function dis_Authresult($info,$ref="index.php")
{
	if($ref == "index.php")
	{
		unset($db);	
	}
	echo '
	<title>Authentication Result</title>
	<body bgcolor=#D2D5D8><font size="4"> Authentication Result: '.$info.'</font>
	</body>
	';
	echo "<br><form action='otp_usermg_m4.php'><input  type='submit' value='Back'/></form>";
	//echo "<meta http-equiv = 'refresh' content = 3;URL=otp_usermg_m4.php>";
	exit;
}

//smarty function for show authentication result
/********************************************************
* function: show authentication result
* in parameter: $info 
*				$ref  URL for goback
* out parameter: N/A
* return N/A
*******************************************************/
Function smarty_dis_Authresult()
{
	//$info,$ref="index.php"
	extract($params);
	if(!isset($ref))
	{
		$ref="index.php";
	}
	if($ref == "index.php")
	{
		unset($db);	
	}
	echo '
	<title>Authentication Result</title>
	<body bgcolor=#f0faff><font size="4">'.$info.'</font>
	</body>
	';
	echo "<meta http-equiv = 'refresh' content = 3;URL=".$ref.">";
	exit;
}

//check if locked period exceed 10 minitues
//1--for exceed 0--not exceed
/****************************************************
* function: get interval
*					 
* in parameters $t timestamp of last authentication
*			 $rang rang value,10 minitues for default
* out parameters N/A
* return 1 the interval exceed the range specified by $rang
* 			 0 
*****************************************************/
function difftime($t,$rang=600)//
{
	$tm=strtotime($t);
	if(false === $tm)
	return 1;
	if(strtotime(gmdate('Y-m-d H:i:s'))-$tm <= $rang)
	return 0;
	else
	return 1;
}

/***********************************************
* Authentication
* in parameter $db --database object
* 		 $username --user to be authenticated
*			 $otp --one-time-password
*			 $wndsize --authentication window size (default 30)
* out parameter  N/A
*return 0 --authentication successfully
*				!0 --authentication failed
*		
************************************************/
function user_check($db, $username, $otp)
{
	global $dbtype;
		//get key and counter one-time-password (change: get tktype and predate in order to make OTP System fits more type of token)
		 $sql = "select keyinfo.userkey,keyinfo.hcounter,keyinfo.lcounter, keyinfo.serialnum, keyinfo.tktype, "._to_char_ex('keyinfo.predate', $dbtype, 'predate').", keyinfo.diglen, keyinfo.authwnd, keyinfo.tmstep, userinfo.authtype, userinfo.pin from keyinfo,userinfo where userinfo.username='".$username."'and userinfo.serialnum = keyinfo.serialnum";
		 //Execute SQL statement
		 if(!($result = @$db->query($sql)))
		 {
		 		return OTP_ERROR_GETUSER_FAILED;//sql execute failed
		 }
		 //query result ,$re[0] is key, $re[1] is hCounter, $re[2] is lCounter
		 if(!($re=$db->fetch_row($result)))
		 {
		 		return OTP_ERROR_NORELATEITEM;//user not exist
		 }
		 $userkey = $re[0];
		 $hcounter = $re[1];
		 $lcounter = $re[2];
		 $serialnum = $re[3];
		 $tktype = $re[4];
		 $predate = $re[5];
		 $diglen = $re[6];
		 $authwnd = $re[7];
		 $tmstep = $re[8];
		 $authtype = $re[9];
		 $pin = $re[10];
		//deal with token type
		switch($tktype)
		{
			case 1: //event-based OTP
				//do nothing
				break;
			case 2: //time-based OTP
				//adjust $re[1] and $re[2](adjust counter)
				$crt = round((strtotime(gmdate('Y-m-d H:i:s'))-strtotime($re[5]))/$tmstep);//counter
				$chwnd = $authwnd/2;
				if($crt >= $chwnd)
				{
					$crt = $crt - $chwnd;
					if(0xffffffff-$lcounter < $crt)
					{
						if(0xffffffff == $hcounter)
						{
							$hcounter = 0;
						}
						else
						{
							$hcounter += 1;
						}
						$lcounter = $crt - (0xffffffff-$lcounter);
					}
					else
					{
						$lcounter = $crt + $lcounter;
					}
				}
/*				else
				{
					$chwnd = $chwnd - $crt;
					if($hcounter == 0)
					{
						if($lcounter <= $chwnd)
						{
							$lcounter = 0;
						}
						else
						{
							$lcounter = $lcounter - $chwnd;
						}
					}
					else
					{
						if($lcounter < $chwnd)
						{
							$hcounter -= 1;
							$lcounter = $lcounter + (0xffffffff-$chwnd);
						}
						else
						{
							$lcounter = $lcounter-$chwnd;
						}
					}
				}
*/
				break;
			case 3://Challenge-Response
				if(strtotime(gmdate('Y-m-d H:i:s')) - strtotime($re[5]) > 60*10 || $re[1] != 1)
				{
					return 11;
				}
				else
				{
					$hcounter = 0;
				}
				break;
		}
		
		 //call authentication function
		 $ret = secu_userauth($otp, $userkey, $hcounter, $lcounter, $authtype, $pin, $diglen, $authwnd);
		 if($ret <= 0)//authentication failed
		 {
			if($re[4] == 3)//reset challenge information for challenge-reponse token
			{
				$sql = "update keyinfo set hcounter=0,lcounter=0, predate="._to_date(gmdate('Y-m-d H:i:s'), $dbtype)." where serialnum='".$re[3]."'";
				$db->query($sql);
			}
	 		return OTP_ERROR_PWDERROR;
		 }
		 else//update counter
		 {
		 	 $sql = "update keyinfo set hcounter=".$hcounter.",lcounter=".$lcounter.", predate="._to_date(gmdate('Y-m-d H:i:s'), $dbtype)." where serialnum='".$re[3]."'";
		 	 if(!($result = $db->query($sql)))
		 	 {
		 	  	return OTP_ERROR_UPTUSERINFO_FAILED;//faile to update counter information
		 	 }
		 	 return OTP_ERROR_SUCCESS;
		}
}

/**************************************************************
* function write log information
*	in parameter: $opname  operator name
*				$loglev  log level  common user-100 operator-10 administrator-4 super administrator-1
*				$db handle of database object
*				$optime	-operate time
*				$successornot -if operation successfully
*				$url -error deal page
*	out parameter: N/A
* return : none
***************************************************************/
function makelog($db, $opname, $loglev, $optime, $successornot, $optype, $url)
{
	try{
			if(!isset($db))
			{
					throw new Exception($LANG[10020]);
			}
			//$sql = "insert into loginfo (optime, operator, loglev, remark) values(".$optime.",'".$opname."',".$loglev.",'".$successornot."')";
			$sql = "insert into sysloginfo (optime, operator, loglev, optype, remark) values(".$optime.",'".$opname."',".$loglev.",".$optype.",'".$successornot."')";
			if($loglev == 100)
			{
				$sql = "insert into commonloginfo (optime, operator, loglev, optype, remark, remoteip) values(".$optime.",'".$opname."',".$loglev.",".$optype.",'".$successornot."', '".$_SERVER['REMOTE_ADDR']."')";	
			}

			if(!($result = $db->query($sql)))
			{
				//throw new Exception($LANG[10021]);
				$main_dir = dirname(__FILE__)."/download/";//current directory
				$old_log = $main_dir."otp_op.log"; 
				if(file_exists($old_log) && filesize($old_log) > 1024*1024*10)
				{
					$new_log = $main_dir."otp_op".date("YmdHis").".log";
					rename($old_log, $new_log);
				}
				if(!file_exists($old_log))
				{
					$f_handle = @fopen($old_log,"w");
					fclose($f_handle);
				}
				if(is_writeable($old_log))
				{
					//new line symbol
					if (strtoupper(substr(PHP_OS,0,3)=="WIN")) 
					{ 
			  		$eol="\r\n"; 
					}
					else if(strtoupper(substr(PHP_OS,0,3)=="MAC"))
					{ 
			  		$eol="\r"; 
					}
					else
				 	{ 
			  		$eol="\n"; 
					}
					//eol
					
					$information = $optime." ".$opname." ".$successornot.$eol;
					
					$f_handle = fopen($old_log, "ab");
					if(@fwrite($f_handle, $information))
					{
						fclose($f_handle);
						return 2;
					}
					else
					{
						fclose($f_handle);
						return -1;
					}
				}
				else
				{
					return -1;
				}
			}
			return 1;
		}
		catch(Exception $e)
		{
			if(100 == $loglev)
			{
				dis_Authresult($e->getMessage());
			}
			else
			{
				dis_header("Error");
				dis_content($LANG[10021]);
				dis_footer($url);
			}
		}
}


function _makelog($db, $opname, $loglev, $optime, $successornot, $optype)
{
	try{
			if(!isset($db))
			{
					//throw new Exception($LANG[10020]);
					return -2;//invalid database object
			}
			$logtable = 'sysloginfo';
			$sql = "insert into ".$logtable." (optime, operator, loglev, optype, remark) values(".$optime.", '".$opname."',".$loglev.", ".$optype.",'".$successornot."')";
			if($loglev == 100)
			{
				$logtable = 'commonloginfo';
				$sql = "insert into ".$logtable." (optime, operator, loglev, optype, remark, remoteip) values(".$optime.", '".$opname."',".$loglev.", ".$optype.",'".$successornot."', '".$_SERVER['REMOTE_ADDR']."')";
			}
			if(!($result = @$db->query($sql)))
			{
				//throw new Exception($LANG[10021]);
				$main_dir = dirname(__FILE__)."/download/";//current directory
				$old_log = $main_dir."otp_op.log"; 
				if(file_exists($old_log) && filesize($old_log) > 1024*1024*10)
				{
					$new_log = $main_dir."otp_op".date("YmdHis").".log";
					rename($old_log, $new_log);
				}
				if(!file_exists($old_log))
				{
					$f_handle = @fopen($old_log,"w");
					fclose($f_handle);
				}
				if(is_writeable($old_log))
				{
					//new line
					if (strtoupper(substr(PHP_OS,0,3)=="WIN")) 
					{ 
			  		$eol="\r\n"; 
					}
					else if(strtoupper(substr(PHP_OS,0,3)=="MAC"))
					{ 
			  		$eol="\r"; 
					}
					else
				 	{ 
			  		$eol="\n"; 
					}
					//eol
					
					$information = $optime." ".$opname." ".$successornot.$eol;
					
					$f_handle = fopen($old_log, "ab");
					if(@fwrite($f_handle, $information))
					{
						fclose($f_handle);
						return 2;
					}
					else
					{
						fclose($f_handle);
						return -1;
					}
				}
				else
				{
					return -1;
				}
			}
			return 1;
		}
		catch(Exception $e)
		{
			if(100 == $loglev)
			{
				dis_Authresult($e->getMessage());
			}
			else
			{
				dis_header("Error");
				dis_content($LANG[10021]);
			}
		}
}

/*************************************************
* function: display menu
* in parameter: N/A
* out parameter: N/A
* return NULL
*************************************************/
function dis_menu($str)
{	
 ?>
	<link rel=stylesheet href="cs.css" type="text/css">
	
	<!--<h2 style="background-image:url('images/t_1.gif');height:27px;background-repeat:no-repeat;margin:0px;padding-top:12px;"><div style="background:url('images/t_1_r.gif') no-repeat right;"><?php echo $str; ?></div></h2>-->
	
			<div id="xsnazzy" >
				<b class="xtop"><b class="xb1"></b><b class="xb2"></b><b class="xb3"></b><b class="xb4"></b></b>
					<div class="xboxcontent">
						<h2 style="padding-top:0px;"><?php echo $str; ?></h2>
					</div>
				<b class="xbottom"><b class="xb4"></b><b class="xb3"></b><b class="xb2"></b><b class="xb1"></b></b>
			</div>
						
	<div style="border-top:1px solid #000000;>
	<?php
}
/*************************************************
* function: smarty function for display menu
* in parameter: N/A
* out parameter: N/A
* return NULL
*************************************************/
function smarty_dis_menu($params)
{
	extract($params);
	
	?>
	<link rel=stylesheet href="cs.css" type="text/css">
	
	<!--<h2 style="background-image:url('images/t_1.gif');height:27px;background-repeat:no-repeat;margin:0px;padding-top:12px;"><div style="background:url('images/t_1_r.gif') no-repeat right;"><?php echo $str; ?></div></h2>-->
	
			<div id="xsnazzy" >
				<b class="xtop"><b class="xb1"></b><b class="xb2"></b><b class="xb3"></b><b class="xb4"></b></b>
					<div class="xboxcontent">
						<h2 style="padding-top:0px;"><?php echo $str; ?></h2>
					</div>
				<b class="xbottom"><b class="xb4"></b><b class="xb3"></b><b class="xb2"></b><b class="xb1"></b></b>
			</div>
						
	<div style="border-top:1px solid #000000;>
	</div>
	<?php
}
/***********************************************
* function: login form
***********************************************/
function dis_loginform()
{
	echo '
	<table border="0">
		<form name="form1" action="login.php" method="post">
			<tr>
				<td>'.$LANG[11001].'<input type="text" name="opID"></td>
			</tr>
			<tr>
				<td>'.$LANG[11002].'<input type="password" name="password"></td>
			</tr>
			<tr>
				<td><input type="submit" value="'.$LANG[11003].'">
			</tr>
		</form>
	</table>
	';
}

/***********************************************
* function: smarty function for displaying operator login form
***********************************************/
function smarty_dis_loginform()
{
	echo '
	<table border="0">
		<form name="form1" action="login.php" method="post">
			<tr>
				<td>'.$LANG[11001].'<input type="text" name="opID"></td>
			</tr>
			<tr>
				<td>'.$LANG[11002].'<input type="password" name="password"></td>
			</tr>
			<tr>
				<td><input type="submit" value="'.$LANG[11003].'">
			</tr>
		</form>
	</table>
	';
}
/****************************************************
* function: if user has login
*						show login page if user not login
****************************************************/
function check_login()
{
	if(!isset($_SESSION['valid_optor']))
	{
		dis_header("UnLogin");
		echo "<body bgcolor=#f0faff>";
	//	show_error("Please Login","Error");
		
		
		echo "Please Login";
		echo "
<script language=\"javascript\">
function cg_pg()
{
	window.parent.parent.location.href=\"login.php\"
}

setTimeout(\"cg_pg()\",5000)
</script>
";
		exit;
	}
}
/************************************************
* get date in formate $form which works well in mysql、
* pgsql、mssql、oracle
************************************************/

function _date($form, $dbtype)
{
	if($dbtype == 4)
	{
		return "to_date('".gmdate($form)."', 'yyyy-mm-dd hh24:mi:ss')";
	}
	else
	{
		return "'".gmdate("Y-m-d H:i:s")."'";
	}
}
function _to_date($time,$dbtype)
{
	if($dbtype == 4)
	{
		return "to_date('".$time."', 'YYYY-MM-DD HH24:MI:SS')";
	}
	else
	{
		return "'".$time."'";
	}
}


function _to_char($time,$dbtype)
{
	if($dbtype == 4)//oracle
	{
		return "to_char(".$time.", 'YYYY-MM-DD HH24:MI:SS')";
	}
	else if($dbtype == 3)//sql server
	{
		return "CONVERT(VARCHAR, ".$time.", 120) $time";	
	}
	return $time;
}

function _to_char_ex($time,$dbtype, $time2)
{
	if($dbtype == 4)//oracle
	{
		return "to_char(".$time.", 'YYYY-MM-DD HH24:MI:SS')";
	}
	else if($dbtype == 3)//sql server
	{
		return "CONVERT(VARCHAR, ".$time.", 120) $time2";	
	}
	return $time;
}
/**********************************************************
* display error information
**********************************************************/
function show_error($errinfo,$title)
{
	?>
	<script language="javascript">
		var tm = 5
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:2px solid #65a4d7;width:500px">
		<table style="width:500px;word-break:break-all;word-wrap:break-word;">
			<tr>
				<td align="right" width=45%> <img src="images/error.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $errinfo ?> </td>
			</tr>
			<tr>
				<td align="right">[</td><td id="Tout" width=10% align="center" style="color:#ff0000"></td><td>]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}

/**********************************************************
* smarty function for displaying error information
**********************************************************/
function smarty_show_error($params)
{
	//$errinfo,$title
	extract($params);
	?>
	<script language="javascript">
		var tm = 5
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:2px solid #65a4d7;width:500px">
		<table style="width:500px;word-break:break-all;word-wrap:break-word;">
			<tr>
				<td align="right" width=45%> <img src="images/error.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $errinfo ?> </td>
			</tr>
			<tr>
				<td align="right">[</td><td id="Tout" width=10% align="center" style="color:#ff0000"></td><td>]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}
/**********************************************************
* display error with a super-linkage
***********************************************************/
function show_lerror($errinfo,$url,$bttext,$title)
{
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid #65a4d7;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/error.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $errinfo ?>  </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
}
/**********************************************************
* smarty function for display error information
***********************************************************/
function smarty_show_lerror($params)
{
	extract($params);
	//$errinfo,$url,$bttext,$title
	/*
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid #65a4d7;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/error.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $errinfo; ?>  </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
	*/
	
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid #65a4d7;width:525px;overflow-y:auto;height:360px;">
		<table style="width:525px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/error.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3">
					<div style="height:200px; overflow-y:auto;">
						<?php echo $errinfo; ?>  
					</div>
				</td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</div>
	</table>
	<?php
}

/********************************************************
* display warning information
********************************************************/
function show_warn($warninfo,$url,$bttext,$title)
{
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid black;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/warning.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $warninfo ?> </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
}

/********************************************************
* smarty function for display warning information
********************************************************/
function smarty_show_warn($params)
{
	extract($params);
	//$warninfo,$url,$bttext,$title
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid black;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/warning.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $warninfo ?> </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
}

/*******************************************************
* smarty function for display warning information
*******************************************************/
function smarty_show_uwarn($params)
{
	extract($params);
	//$warninfo,$title
	?>
	<script language="javascript">
		var tm = 8
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:2px solid #65a4d7;width:500px">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;">
			<tr>
				<td align="right" colspan="3"> <img src="images/warning.gif"> </td> <td colspan="4" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="7"> <?php echo $warninfo ?> </td>
			</tr>
			<tr>
				<td align="right" colspan="3">[</td><td id="Tout" align="center" style="color:#ff0000"></td><td colspan="3">]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}
/*******************************************************
* show warning information
*******************************************************/
function show_uwarn($warninfo,$title)
{
	?>
	<script language="javascript">
		var tm = 8
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:2px solid #65a4d7;width:500px">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;">
			<tr>
				<td align="right" colspan="3"> <img src="images/warning.gif"> </td> <td colspan="4" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="7"> <?php echo $warninfo ?> </td>
			</tr>
			<tr>
				<td align="right" colspan="3">[</td><td id="Tout" align="center" style="color:#ff0000"></td><td colspan="3">]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}

/********************************************************
* show successful information
*********************************************************/
function show_done($doneinfo,$title)
{
	?>
	<script language="javascript">
		var tm = 5
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:0px solid #65a4d7;width:500px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/done.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $doneinfo ?> </td>
			</tr>
			<tr>
				<td align="right">[</td><td id="Tout" width=10% align="center" style="color:#ff0000"></td><td>]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}
/********************************************************
* operation successfully
*********************************************************/
function smarty_show_done($params)
{
	//$doneinfo,$title
	extract($params);
	?>
	<script language="javascript">
		var tm = 5
		
		function tmout()
		{
			if(tm > 0)
			{
				tm--;
				Tout.innerHTML = tm;
				window.setTimeout("tmout()",1000)
			}
		}
	</script>
	
	<div style="margin-top:100px;margin-left:100px;border:0px solid #65a4d7;width:500px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/done.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $doneinfo ?> </td>
			</tr>
			<tr>
				<td align="right">[</td><td id="Tout" width=10% align="center" style="color:#ff0000"></td><td>]</td>
			</tr>
		</table>
		<script language="javascript">	tmout()</script>
	</div>
	<?php
}


/*************************************************************
* show successful information
**************************************************************/
function show_ldone($doneinfo,$url,$bttext,$title)
{
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid #65a4d7;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/done.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $doneinfo ?> </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
}

/*************************************************************
* smarty function for displaying successful information
**************************************************************/
function smarty_show_ldone($params)
{
	//$doneinfo,$url,$bttext,$title
	extract($params);
	?>
	<div style="margin-top:30px;margin-left:100px;border:0px solid #65a4d7;width:525px;overflow-y:auto;height:360px;">
		<table style="width:500px;table-layout:fixed;word-break:break-all;word-wrap:break-word;border:2px solid #65a4d7;">
			<tr>
				<td align="right" width=45%> <img src="images/done.gif"> </td> <td colspan="2" style="font-size:20px;font-weight:bold"><?php echo $title; ?></td>
			</tr>
			<tr bgcolor=#dddddd>
				<td colspan="3"><?php echo $doneinfo ?> </td>
			</tr>
			<tr>
				<td colspan="3" align="center"><a href=<?php echo $url; ?> style="text-decoration:none"><?php echo $bttext;?></a></td>
			</tr>
		</table>
	</div>
	<?php
}
/////////////////////////////////////////////////////////

function smarty_isset($param)
{
	if(isset($param))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


function smarty_header($url)
{
	header("Location:".$url);
}
?>
