/* cryptoki.h include file for PKCS #11. */
/* $Revision: 1.4 $ */

#ifndef ___CRYPTOKI_H_INC___
#define ___CRYPTOKI_H_INC___

#ifdef _WIN32
	#pragma pack(push, cryptoki, 1)

	#define CK_PTR *

	/* Specifies that the function is a DLL entry point. */
	#define CK_IMPORT_SPEC __declspec(dllimport)

	/* Define CRYPTOKI_EXPORTS during the build of cryptoki libraries. Do
	 * not define it in applications.
	 */
	#ifdef CRYPTOKI_EXPORTS
	/* Specified that the function is an exported DLL entry point. */
	#define CK_EXPORT_SPEC __declspec(dllexport) 
	#else
	#define CK_EXPORT_SPEC CK_IMPORT_SPEC 
	#endif

	#define CK_DEFINE_FUNCTION(returnType, name) \
	  returnType CK_EXPORT_SPEC name

	#define CK_DECLARE_FUNCTION(returnType, name) \
	  returnType CK_EXPORT_SPEC name

	#define CK_DECLARE_FUNCTION_POINTER(returnType, name) \
	  returnType CK_IMPORT_SPEC (CK_PTR name)

	#define CK_CALLBACK_FUNCTION(returnType, name) \
	  returnType (CK_PTR name)

#else /* linux */

	#define CK_PTR *

	#define CK_DEFINE_FUNCTION(returnType, name) \
	  returnType name

	#define CK_DECLARE_FUNCTION(returnType, name) \
	  returnType name

	#define CK_DECLARE_FUNCTION_POINTER(returnType, name) \
	  returnType (CK_PTR name)

	#define CK_CALLBACK_FUNCTION(returnType, name) \
	  returnType (CK_PTR name)

#endif /* _WIN32 */

#ifndef NULL_PTR
#define NULL_PTR 0
#endif

#ifndef __STR__
#define __STR__
typedef char CHAR, *LPSTR;
#endif

#include "pkcs11.h"

#ifdef _WIN32
	#pragma pack(pop, cryptoki)
#endif 

#endif /* ___CRYPTOKI_H_INC___ */
