/*--
	EncryptDecryptAndSignVerifyByRSA.cpp

	2015-11-12

	Test pkcs Generate RSA Key and Encrypt/Decrypt sign/verify
--*/

#include "../global.h"

CK_FUNCTION_LIST_PTR fl = 0; 
CK_BYTE message[1024];
CK_BYTE signature[500];    
CK_ULONG signature_length = 500;

CK_OBJECT_HANDLE find_object(CK_SESSION_HANDLE hSess, 
							 CK_ATTRIBUTE * t, 
							 CK_ULONG size);

int main(int argc, char* argv[])
{
	CK_RV rv;
	CK_ULONG slot_count = 100;
	CK_SLOT_ID slots[100];
	CK_SESSION_HANDLE session;
	CK_BBOOL         bFalse = FALSE;
	CK_BBOOL         bTrue = TRUE;
	CK_KEY_TYPE      key_type  = CKK_RSA;
	int loop = 0;
	CK_ULONG msgLen = 0;
	/* setup public key attributes, specific name so we can find it 
	 * later, rsa key type, saved on the UniMate/UniToken and public to all
	 * users of the UniMate/UniToken
	 */
	CK_OBJECT_CLASS class_public_key = CKO_PUBLIC_KEY;
	CK_ULONG vecModulusBits  = 1024;
	CK_BBOOL b = TRUE;
	CK_BYTE KID = 0;
	CK_BYTE ID = '0';
	CK_CHAR	label_public[] = labelPu;
	CK_CHAR label_private[] = labelPr;
	CK_ATTRIBUTE public_key_template[] = 
	{
		{ CKA_CLASS,			&class_public_key,  sizeof (class_public_key) },
		{ CKA_ID,				&ID,				sizeof(CK_BYTE)},
		{ CKA_KEY_TYPE,			&key_type,          sizeof (key_type) },
		{ CKA_ENCRYPT,			&b,					sizeof (b) },
		{ CKA_LABEL,			label_public,       sizeof (label_public) },
		{ CKA_TOKEN,			&bTrue,             sizeof (bTrue) },
		{ CKA_PRIVATE,			&bFalse,            sizeof (bFalse) },
		{ CKA_MODULUS_BITS,		&vecModulusBits,	sizeof (vecModulusBits) }
	};
	
	/* setup private key attributes, specific name so we can find it 
	 * later, rsa key type, saved on the UniMate/UniToken and private to only
	 * the user of the UniMate/UniToken
	 */
	CK_OBJECT_CLASS class_private_key = CKO_PRIVATE_KEY;
	CK_ATTRIBUTE private_key_template[] = 
	{
		{ CKA_CLASS,    &class_private_key, sizeof (class_private_key) },
		{ CKA_ID,		&ID,				sizeof(CK_BYTE)},
		{ CKA_KEY_TYPE, &key_type,          sizeof (key_type) },
		{ CKA_DECRYPT,  &b,					sizeof (b) },
		{ CKA_SIGN,		&b,					sizeof (b) },
		{ CKA_LABEL,    label_private,      sizeof (label_private) },
		{ CKA_TOKEN,    &bTrue,             sizeof (bTrue) },
		{ CKA_PRIVATE,  &bTrue,             sizeof (bTrue) },
		{ CKA_KEY_ID,   &KID,				sizeof (KID) }
	};
	/* setup mechanism to generate rsa key pair
	 */
	CK_MECHANISM mechanism = {0};
	CK_OBJECT_HANDLE public_key;
	CK_OBJECT_HANDLE private_key;
	int i = 0;

	CK_ULONG ulCipherLen = 0;
	CK_BYTE_PTR pCipherText = NULL;

	CK_ULONG ulPlainLen = 0;
	CK_BYTE_PTR pPlainText = NULL;

	char szMsg[] = {"the RSA sign and verify test!"};
	memcpy(message, szMsg, strlen(szMsg));
	msgLen = strlen(szMsg);
	
	printf("Sign with RSA Sample:\n");
	
	fl = InitFunctionList();
	if (fl == 0)
		return leave("Can't get function list. \n");
	
	/* Initialize the PKCS #11 library
	 */
	if (PKCS_OK != fl->C_Initialize (0))
		return leave("C_Initialize failed...");                       
	
	/* Get list of slots containing UniMate
	 */
	
	if (PKCS_OK != fl->C_GetSlotList (TRUE, slots, &slot_count))
		return leave("C_GetSlotList failed...");

	/* One or more UniMate/UniToken must be inserted
	 */
	if (slot_count < 1)
		return leave("No UniMate/UniToken is available.\n");
	
	printf ("Found UniMate/UniToken.\n");
	/* open a read/write session on the first UniMate/UniToken found
	 */
	if (PKCS_OK != fl->C_OpenSession(slots[0], 
		(CKF_SERIAL_SESSION | CKF_RW_SESSION), 0, 0, &session)
		)
		return leave("C_OpenSession failed.\n");
	
	/* login as user so we can use the public and private
	 * keys on the UniMate/UniToken
	 */
	if (PKCS_OK != fl->C_Login(session, CKU_USER, USER_PIN, 8))
		return leave("C_Login failed.\n");
	
	/* Try to find the two keys using the find_object utility function if exist,
	 * or generate new key pair.
	*/
	printf("Please selected the RSA keypair bit:\n");
	printf("0: RSA1024\n");
	printf("1: RSA2048\n");
	switch (getchar())
	{
	case '0':
		vecModulusBits = 1024;
		break;
	case '1':
		ID = '1';
		vecModulusBits = 2048;
		break;
	default:
		printf("Invalid bit!\n");
		goto log_out;
		break;
	}

	mechanism.mechanism = CKM_RSA_PKCS_KEY_PAIR_GEN;
	private_key = find_object(session, private_key_template, 3);
	public_key = find_object(session,  public_key_template,  3);
	
	if (!(public_key && private_key))
	{
		printf ("Wait For Generate RSA KEY PAIR Now ... \n");
		
		if((rv = fl->C_GenerateKeyPair(session,&mechanism, public_key_template, 8,
			private_key_template, 9, &public_key,&private_key))!=PKCS_OK)
		{
			fl->C_Logout(session);
			fl->C_CloseSession(session);
			return leave("C_GenerateKeyPair failed.  Please run InitToken first.");
		}
	}
	
	/* setup the rsa mechanism
	 */
	memset (&mechanism, 0, sizeof (mechanism));
	mechanism.mechanism = CKM_SHA1_RSA_PKCS;
	printf("The Mechanism:CKM_SHA1_RSA_PKCS\n");
	
	/* setup signature operation with private key
	 */
	rv = fl->C_SignInit(session, &mechanism, private_key);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		
		return leave("C_SignInit failed...\n");
	}                       
	
	/* sign the message and get back the signature
	 */
	printf("Sign Message:\n");
	printf("%s\n", szMsg);
	printf("\n");

	rv = fl->C_Sign(session, message, msgLen, signature, &signature_length);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		
		if (CKR_CANCEL == rv)
		{
			return leave("The signature was canceled!");
		}
		else
		{
			return leave("C_Sign failed...\n");
		}
	}

	printf("Signature:\n");
	for(loop=0; loop<signature_length; loop++)
	{
		printf ("%x",signature[loop]);
	}
	printf("\n");
	printf("Sign successful!\n");
	/******************************************/


	// Verify
	rv = fl->C_VerifyInit(session, &mechanism, public_key);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);	
		return leave("C_VerifyInit failed...\n");
	} 

	rv = fl->C_Verify(session, message, msgLen, signature, signature_length);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		return leave("C_Verify failed...\n");
	}
	printf("\n");
	printf("Verify successful!\n");
	printf("\n");
	


	/* setup the rsa mechanism
	 */
	memset (&mechanism, 0, sizeof (mechanism));
	mechanism.mechanism = CKM_RSA_PKCS;
	printf("The Mechanism:CKM_RSA_PKCS\n");
	/* setup Encrypt operation with public key
	 */
	rv = fl->C_EncryptInit(session, &mechanism, public_key);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		
		return leave("C_EncryptInit failed...\n");
	}                       
	
	/* Encrypt the data and get back the cipher
	 */
	printf("Encrypt Data:\n");
	printf("%s\n", szMsg);
	printf("\n");
	rv = fl->C_Encrypt(session, message, msgLen, NULL, &ulCipherLen);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		
		if (CKR_CANCEL == rv)
		{
			return leave("The encrypt was canceled!");
		}
		else
		{
			return leave("C_Encrypt failed...\n");
		}
	}
	pCipherText = (CK_BYTE_PTR)malloc(ulCipherLen*sizeof(CK_BYTE));
	if (pCipherText == NULL)
	{
		return leave("malloc failed...\n");
	}
	rv = fl->C_Encrypt(session, message, msgLen, pCipherText, &ulCipherLen);
	if (CKR_OK != rv)
	{
		fl->C_Logout(session);
		
		if (CKR_CANCEL == rv)
		{
			free(pCipherText);
			return leave("The encrypt was canceled!");
		}
		else
		{
			free(pCipherText);
			return leave("C_Encrypt failed...\n");
		}
	}

	printf("CipherText:\n");
	for(loop=0; loop<ulCipherLen; loop++)
	{
		printf ("%x",pCipherText[loop]);
	}
	printf("\n");
	printf("Encrypt successful!\n");
	/******************************************/


	// Decrypt
	rv = fl->C_DecryptInit(session, &mechanism, private_key);
	if (CKR_OK != rv)
	{
		free(pCipherText);
		fl->C_Logout(session);	
		return leave("C_DecryptInit failed...\n");
	} 

	rv = fl->C_Decrypt(session, pCipherText, ulCipherLen, NULL, &ulPlainLen);
	if (CKR_OK != rv)
	{
		free(pCipherText);
		fl->C_Logout(session);
		return leave("C_Decrypt failed...\n");
	}
	pPlainText = (CK_BYTE_PTR)malloc(ulPlainLen*sizeof(CK_BYTE));
	if (pPlainText == NULL)
	{
		free(pCipherText);
		return leave("malloc failed...\n");
	}
	rv = fl->C_Decrypt(session, pCipherText, ulCipherLen, pPlainText, &ulPlainLen);
	if (CKR_OK != rv)
	{
		free(pCipherText);
		free(pPlainText);
		fl->C_Logout(session);
		return leave("C_Decrypt failed...\n");
	}

	printf("\n");
	printf("Decrypt successful!\n");
	printf("\n");

	printf("PlainText:\n");
	for(loop=0; loop<ulPlainLen; loop++)
	{
		printf ("%c", pPlainText[loop]);
	}
	printf("\n\n");

	if (pCipherText != NULL)
	{
		free(pCipherText);
		pCipherText = NULL;
	}

	if (pPlainText != NULL)
	{
		free(pPlainText);
		pPlainText = NULL;
	}

log_out:
	if (PKCS_OK != fl->C_Logout (session))
		return leave("C_Logout failed.\n");
    
	/* close open session
	 */
	if (PKCS_OK != fl->C_CloseSession (session))
		return leave("C_CloseSession failed.\n");
	
	
	/* close PKCS #11 library
	 */
	if (PKCS_OK != fl->C_Finalize(0))
		return leave("C_Finalize failed.\n");
    Finalize();

	printf ("Press Enter to exit...");
	getchar ();
	
	return PKCS_OK;
}


/*
	Forward declaration of utility function
		(To find an object handle, with a certain set of attributes)
*/
CK_OBJECT_HANDLE 
find_object(CK_SESSION_HANDLE hSess, CK_ATTRIBUTE * t, CK_ULONG size)
{
	CK_OBJECT_HANDLE list[1];
	CK_ULONG found = 0;
	
	// initialize the search for any object with attribute 't'
	if (CKR_OK != fl->C_FindObjectsInit (hSess, t, size))
	{
		leave("C_FindObjectsInit failed.\n");
		return 0;
	}
	
	// find the objects which match, we ask for only a single match
	// since we know there is only one on the UniMate
	if (CKR_OK != fl->C_FindObjects(hSess, list, 1, &found))
	{
		leave("C_FindObjects failed.\n");
		return 0;
	}
	
	// cleanup the search
	//
	if (CKR_OK != fl->C_FindObjectsFinal(hSess))
	{
		leave ("C_FindObjectsFinal failed.\n");
		return 0;
	}
	
	// either return NULL if nothing matches or return the object handle
	// of the matching object
	//
	if (found < 1)
		return 0;
	
	return (list[0]);
}