/*
	helper.cpp

	2009-1-16
*/


#include "global.h"

#define pkcs11_path "UniMateP11.dll"

HINSTANCE hLib = NULL;

int leave (char * c)
{
	printf ("%s\n", (c == NULL? "" : c));
	printf ("Press Enter to exit ...");
	getchar ();
	return PKCS_FAILED;
}

CK_FUNCTION_LIST_PTR InitFunctionList()
{
	CK_C_GetFunctionList pGFL = NULL;
	CK_FUNCTION_LIST_PTR fl = NULL;
	unsigned long rv;

	// Load the library
	//
	printf ("Load UniMateP11.dll.\n");
	if ((hLib = LoadLibrary(pkcs11_path)) == NULL)
	{
		leave ("Cannot Load UniMateP11.dll.\n");
		return NULL;
	}

	// Find the entry point.
	//
	//printf ("Find the entry point\n");
	if ( (pGFL = (CK_C_GetFunctionList)GetProcAddress(hLib, "C_GetFunctionList")) == NULL )
	{
		leave ("Cannot find GetFunctionList().");
		return NULL;
	}

	if((rv = pGFL(&fl)) != PKCS_OK)
	{
		leave ("Can't get function list. \n");
		return NULL;
	}

	return fl;
}

void Finalize()
{
	if ( hLib != NULL )
	{
		FreeLibrary(hLib);
	}
}