/*
	helper.cpp

	2009-1-16
*/


#include "global.h"
#include <dlfcn.h>

void *libm_handle = NULL;
char *error = NULL;

int leave (char * c)
{
	printf ("%s\n", (c == NULL? "" : c));
	printf ("Press Enter to exit ...");
	getchar ();
	return PKCS_FAILED;
}

CK_FUNCTION_LIST_PTR InitFunctionList()
{
	CK_C_GetFunctionList pGFL = NULL;
	CK_FUNCTION_LIST_PTR fl = NULL;
	unsigned long rv;

	// Linux load the library
	//
	printf ("Load libUniMateP11.so\n");
	libm_handle = dlopen("./libUniMateP11.so", RTLD_LAZY );
	if (!libm_handle){
		printf("Cannot load libUniMateP11.so.");	
		printf("Open Error:%s.\n",dlerror());
		return 0;
	}

	// Find the entry point.
	//
	//printf ("Find the entry point\n");
	pGFL = (CK_C_GetFunctionList)dlsym(libm_handle,"C_GetFunctionList");
	if ( pGFL == NULL)
	{
		leave ("Cannot find GetFunctionList().");
		return NULL;
	}

	if((rv = pGFL(&fl)) != PKCS_OK)
	{
		leave ("Can't get function list. \n");
		return NULL;
	}

	return fl;
}

void Finalize()
{
	if ( libm_handle != NULL )
	{
		dlclose(libm_handle);
	}
}
