
#include "des_locl.h" 
#include "spr.h"


void DES_encrypt2(DES_LONG *data, DES_key_schedule *ks, int enc)
{
register DES_LONG l,r,t,u;
#ifdef DES_PTR
register const unsigned char *des_SP=(const unsigned char *)DES_SPtrans;
#endif
#ifndef DES_UNROLL
register int i;
#endif
register DES_LONG *s;

r=data[0];
l=data[1];

/* Things have been modified so that the initial rotate is
* done outside the loop. This required the
* DES_SPtrans values in sp.h to be rotated 1 bit to the right.
* One perl script later and things have a 5> speed up on a sparc2.
* Thanks to Richard Outerbridge <71755.204@CompuServe.COM>
* for pointing this out. */
/* clear the top bits on machines with 8byte longs */
r=ROTATE(r,29)&0xffffffffL;
l=ROTATE(l,29)&0xffffffffL;

s=ks->ks->deslong;
/* I don't know if it is worth the effort of loop unrolling the
* inner loop */
if (enc)
{
#ifdef DES_UNROLL
D_ENCRYPT(l,r, 0); /* 1 */
D_ENCRYPT(r,l, 2); /* 2 */
D_ENCRYPT(l,r, 4); /* 3 */
D_ENCRYPT(r,l, 6); /* 4 */
D_ENCRYPT(l,r, 8); /* 5 */
D_ENCRYPT(r,l,10); /* 6 */
D_ENCRYPT(l,r,12); /* 7 */
D_ENCRYPT(r,l,14); /* 8 */
D_ENCRYPT(l,r,16); /* 9 */
D_ENCRYPT(r,l,18); /* 10 */
D_ENCRYPT(l,r,20); /* 11 */
D_ENCRYPT(r,l,22); /* 12 */
D_ENCRYPT(l,r,24); /* 13 */
D_ENCRYPT(r,l,26); /* 14 */
D_ENCRYPT(l,r,28); /* 15 */
D_ENCRYPT(r,l,30); /* 16 */
#else
for (i=0; i<32; i+=8)
{
D_ENCRYPT(l,r,i+0); /* 1 */
D_ENCRYPT(r,l,i+2); /* 2 */
D_ENCRYPT(l,r,i+4); /* 3 */
D_ENCRYPT(r,l,i+6); /* 4 */
}
#endif
}
else
{
#ifdef DES_UNROLL
D_ENCRYPT(l,r,30); /* 16 */
D_ENCRYPT(r,l,28); /* 15 */
D_ENCRYPT(l,r,26); /* 14 */
D_ENCRYPT(r,l,24); /* 13 */
D_ENCRYPT(l,r,22); /* 12 */
D_ENCRYPT(r,l,20); /* 11 */
D_ENCRYPT(l,r,18); /* 10 */
D_ENCRYPT(r,l,16); /* 9 */
D_ENCRYPT(l,r,14); /* 8 */
D_ENCRYPT(r,l,12); /* 7 */
D_ENCRYPT(l,r,10); /* 6 */
D_ENCRYPT(r,l, 8); /* 5 */
D_ENCRYPT(l,r, 6); /* 4 */
D_ENCRYPT(r,l, 4); /* 3 */
D_ENCRYPT(l,r, 2); /* 2 */
D_ENCRYPT(r,l, 0); /* 1 */
#else
for (i=30; i>0; i-=8)
{
D_ENCRYPT(l,r,i-0); /* 16 */
D_ENCRYPT(r,l,i-2); /* 15 */
D_ENCRYPT(l,r,i-4); /* 14 */
D_ENCRYPT(r,l,i-6); /* 13 */
}
#endif
}
/* rotate and clear the top bits on machines with 8byte longs */
data[0]=ROTATE(l,3)&0xffffffffL;
data[1]=ROTATE(r,3)&0xffffffffL;
l=r=t=u=0;
}

void DES_encrypt3(DES_LONG *data, DES_key_schedule *ks1,
DES_key_schedule *ks2, DES_key_schedule *ks3)
{
register DES_LONG l,r;

l=data[0];
r=data[1];
IP(l,r);
data[0]=l;
data[1]=r;
DES_encrypt2((DES_LONG *)data,ks1,DES_ENCRYPT);
DES_encrypt2((DES_LONG *)data,ks2,DES_DECRYPT);
DES_encrypt2((DES_LONG *)data,ks3,DES_ENCRYPT);
l=data[0];
r=data[1];
FP(r,l);
data[0]=l;
data[1]=r;
}

void DES_decrypt3(DES_LONG *data, DES_key_schedule *ks1,
DES_key_schedule *ks2, DES_key_schedule *ks3)
{
register DES_LONG l,r;

l=data[0];
r=data[1];
IP(l,r);
data[0]=l;
data[1]=r;
DES_encrypt2((DES_LONG *)data,ks3,DES_DECRYPT);
DES_encrypt2((DES_LONG *)data,ks2,DES_ENCRYPT);
DES_encrypt2((DES_LONG *)data,ks1,DES_DECRYPT);
l=data[0];
r=data[1];
FP(r,l);
data[0]=l;
data[1]=r;
}

#ifndef DES_DEFAULT_OPTIONS

#undef CBC_ENC_C__DONT_UPDATE_IV


#endif /* DES_DEFAULT_OPTIONS */







