

#ifndef HEADER_NEW_DES_H
#define HEADER_NEW_DES_H

#ifndef DES_LONG
#define DES_LONG unsigned long
#endif

#include "des_locl.h"


typedef unsigned char DES_cblock[8]; 
typedef unsigned char des_cblock[8];
typedef /* const */ unsigned char const_DES_cblock[8];
/* With "const", gcc 2.8.1 on Solaris thinks that DES_cblock *
* and const_DES_cblock * are incompatible pointer types. */

typedef struct DES_ks
{
union
{
DES_cblock cblock;
/* make sure things are correct size on machines with
* 8 byte longs */
DES_LONG deslong[2];
} ks[16];
} DES_key_schedule;

#define des_key_schedule DES_key_schedule 


#define DES_KEY_SZ (sizeof(DES_cblock))
#define DES_SCHEDULE_SZ (sizeof(DES_key_schedule))

#define DES_ENCRYPT 1
#define DES_DECRYPT 0

#define DES_CBC_MODE 0
#define DES_PCBC_MODE 1

#define DES_ecb2_encrypt(i,o,k1,k2,e) \
DES_ecb3_encrypt((i),(o),(k1),(k2),(k1),(e))

#define DES_ede2_cbc_encrypt(i,o,l,k1,k2,iv,e) \
DES_ede3_cbc_encrypt((i),(o),(l),(k1),(k2),(k1),(iv),(e))

#define DES_ede2_cfb64_encrypt(i,o,l,k1,k2,iv,n,e) \
DES_ede3_cfb64_encrypt((i),(o),(l),(k1),(k2),(k1),(iv),(n),(e))

#define DES_ede2_ofb64_encrypt(i,o,l,k1,k2,iv,n) \
DES_ede3_ofb64_encrypt((i),(o),(l),(k1),(k2),(k1),(iv),(n))



#ifdef __cplusplus
extern "C"
{
	
#endif

void DES_ecb3_encrypt(const_DES_cblock *input, DES_cblock *output,
DES_key_schedule *ks1,DES_key_schedule *ks2,
DES_key_schedule *ks3, int enc);

void DES_encrypt2(DES_LONG *data,DES_key_schedule *ks, int enc);

void DES_encrypt3(DES_LONG *data, DES_key_schedule *ks1,
DES_key_schedule *ks2, DES_key_schedule *ks3);
void DES_decrypt3(DES_LONG *data, DES_key_schedule *ks1,
DES_key_schedule *ks2, DES_key_schedule *ks3);
void DES_set_key_unchecked(const_DES_cblock *key,DES_key_schedule *schedule);


#ifdef __cplusplus
	
};
#endif

#endif