/*--
	engine.cpp

	UniToken CSP sample
		
--*/


#include "global.h"
#include "algorithmTest.h"
#include "kcsTest.h"
#include "listcerts.h"


/*	Entry point	*/
int main(int argc, char* argv[])
{
	bool bRun = true;
	while (bRun)
	{
		ShowTitle();
		
		printf("Input test item: ");
		int iChoise;
		scanf("%d", &iChoise);

		printf("\n\n------------------------------------------------\n");

		switch (iChoise)
		{
	
		// generate DES
		case DES_TEST_CHOISE:
			printf("Generate DES test:\n");
			if(CSP_OK != GenerateAlgTest(TEST_DES_ALG))
			{
				printf("ERROR: Test generate DES key and key operation failed!\n\n");
				getch();
			}
			printf("Generate DES test finish!\n");
			bRun = true;
			getch();
			break;

		// device DES
		case DERIVEDESKEY_TEST_CHOISE:
			printf("Device DES test:\n");
			if(CSP_OK != DeviceAlgTest(TEST_DES_ALG))
			{
				printf("ERROR: Test device DES key and key operation failed!\n\n");
				getch();
			}
			printf("Device DES test finish!\n");
			bRun = true;
			getch();
			break;

		// RSA
		case RSA_CHOISE:
			printf("RSA test:\n");
			if(CSP_OK != RstTest(TOKEN_VERSION))
			{
				printf("ERROR: Test RSA key and key operation failed!\n\n");
				getch();
			}
			printf("RSA test finish!\n");
			bRun = true;
			getch();
			break;

		// kcs list
		case KCS_LIST_CHOISE:
			printf("KCS list test:\n");
			if(CSP_OK != kcsTest(ACTIVE_LIST))
			{
				printf("ERROR: Test KCS list key and key operation failed!\n\n");
				getch();
			}
			printf("KCS list test finish!\n");
			bRun = true;
			getch();
			break;

		// kcs add
		case KCS_ADD_CHOISE:
			printf("KCS add test:\n");
			if(CSP_OK != kcsTest(ACTIVE_ADD))
			{
				printf("ERROR: Test KCS add key and key operation failed!\n\n");
				getch();
			}
			printf("KCS add test finish!\n");
			bRun = true;
			getch();
			break;

		// kcs remove
		case KCS_REMOVE_CHOISE:
			printf("KCS remove test:\n");
			if(CSP_OK != kcsTest(ACTIVE_REMOVE))
			{
				printf("ERROR: Test KCS remove key and key operation failed!\n\n");
				getch();
			}
			printf("KCS remove test finish!\n");
			bRun = true;
			getch();
			break;
			
		// list certificate
		case LISTCERTIFICATE_TESTCHOISE:
			printf("LISTCERTS test:\n");
			if(CSP_OK != listcerts())
			{
				printf("ERROR: Test LISTCERTS key and key operation failed!\n\n");
				getch();
			}
			printf("LISTCERTS test finish!\n");
			bRun = true;
			getch();
			break;
			
		case EXIT:
			bRun = false;
			break;
		}
	}

	return 0;
}