
#ifndef __PKI_LIB_DEVICE
#define __PKI_LIB_DEVICE

#ifndef CK_ULONG
typedef unsigned long CK_ULONG, *CK_ULONG_PTR;
#endif
#ifndef CK_RV
typedef CK_ULONG          CK_RV;
#endif
#ifndef CK_BYTE
typedef unsigned char CK_BYTE, *CK_BYTE_PTR;
#endif
#ifndef CK_SHORT
typedef short CK_SHORT, *CK_SHORT_PTR;
#endif
#ifndef DHANDLE
typedef unsigned long DHANDLE, *DHANDLE_PTR;		/* 设备句柄			*/
#endif
#ifndef CK_ALG
typedef CK_ULONG		CK_ALG;						/* 算法类型			*/
#endif
#ifndef CK_FID
typedef unsigned short	CK_FID;						/* 文件ID类型			*/
#endif
#ifndef MAX_DEVICE_COUNT
#define MAX_DEVICE_COUNT	128		/* 设备最大数量						*/
#endif
#ifndef TLV
#define TLV_L_MAX			256			/* TLV结构中的L的最大长度		*/
typedef struct _TLV{
	CK_BYTE t;				/* 数据类型	*/
	CK_BYTE l;				/* 数据长度	*/
	CK_BYTE v[TLV_L_MAX];	/* 数据		*/
}TLV, *TLV_PTR;
#endif
#ifndef PUB_KEY
typedef struct _pub_key{
	TLV n;
	TLV e;
}PUB_KEY, *PUB_KEY_PTR;
#endif
#ifndef HASH_MD5
#define HASH_MD5				0x0
#define HASH_SHA1				0x1
#define HASH_SHA224				0x2
#define HASH_SHA256				0x3
#define HASH_SHA384				0x4
#define HASH_SHA512				0x5
#endif

/************************************************************************
	device function
 ************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
	
CK_RV s2u( CK_SHORT sc_error );

/************************************************************************
	初始化
 ************************************************************************/
/*	初始化
 */
CK_RV UT_Initialize();

/*	结束.释放资源
 */
CK_RV UT_Finalize();

/************************************************************************
	设备管理
 ************************************************************************/
/*	找设备
 */
CK_RV UT_Find(DHANDLE handle[MAX_DEVICE_COUNT], CK_ULONG_PTR count);

/************************************************************************
	设备属性
 ************************************************************************/
/*	获得设备名称
 */
CK_RV UT_GetID(DHANDLE handle,  CK_BYTE_PTR id);

/*	获得设备序列号
 */
CK_RV UT_GetSN(DHANDLE handle,  CK_ULONG sn[2]);

/*	获得cos版本
 */
CK_RV UT_GetCOSVersion(DHANDLE handle, CK_ULONG_PTR version);

/*	获得可用空间
 */
CK_RV UT_GetSpace(DHANDLE handle, CK_ULONG_PTR space);
/************************************************************************
	文件操作
 ************************************************************************/
/*	打开指定文件
 */
CK_RV UT_OpenFID(DHANDLE handle, CK_FID fid);

/*	读文件
 */
CK_RV UT_ReadFile(DHANDLE handle, CK_ULONG addr, CK_ULONG len, CK_BYTE_PTR buf);

/*	write file
 */
CK_RV UT_WriteFile(DHANDLE handle, CK_ULONG addr, CK_ULONG len, CK_BYTE_PTR buf);

/*	update record
 */
CK_RV UT_GetRecord(DHANDLE handle, CK_ULONG index, CK_BYTE_PTR buf, CK_ULONG len);

/*	append record
 */
CK_RV UT_AppendRecord(DHANDLE handle, CK_BYTE_PTR buf, CK_ULONG buf_len);
/************************************************************************
	设备操作
 ************************************************************************/
/*	软复位
 */
CK_RV UT_SoftReset(DHANDLE handle);

/************************************************************************
	PIN
 ************************************************************************/
/*	修改密码
 */
CK_RV UT_ChangePIN(DHANDLE handle, CK_BYTE_PTR ARCCoded, CK_RV ARCCodedLen, 
	CK_BYTE_PTR UTCCoded, CK_RV UTCCodedLen);

/*	PIN验证
 */
CK_RV UT_VerifyPIN(DHANDLE handle, CK_BYTE_PTR PIN, CK_ULONG PINLen);

CK_RV UT_VerifyPIN_ADMIN(DHANDLE handle, CK_BYTE_PTR PIN, CK_ULONG PINLen);

/*	获得PIN状态
 */
CK_RV UT_GetAttempt(DHANDLE handle, CK_ULONG_PTR max_attempt, CK_ULONG_PTR attempt);

/*	重装PIN
 */
CK_RV UT_ReloadPIN(DHANDLE handle, CK_BYTE_PTR pin, CK_ULONG pinLen);

/************************************************************************
	RSA
 ************************************************************************/
/*	generate key pair
 */
CK_RV UT_GenRSA(DHANDLE handle, CK_FID pub_fid, CK_FID pri_fid, CK_ULONG bit);

/*	获得公钥
 */
CK_RV UT_GetRSAPubKey(DHANDLE handle, CK_FID fid, PUB_KEY_PTR pubkey);

/*	select RSA key pair
 */
CK_RV UT_SelectRSA(DHANDLE handle, CK_FID pub_fid, CK_FID pri_fid);

/*	rsa sign
 */
CK_RV UT_RSASign(DHANDLE handle, CK_BYTE_PTR digest, CK_ULONG digest_len, 
	 CK_BYTE_PTR sign,  CK_ULONG_PTR sign_len);

/*	rsa verify
 */
CK_RV UT_RSAVerify(DHANDLE handle, CK_BYTE_PTR sign, CK_ULONG sign_len, 
	 CK_BYTE_PTR digest,  CK_ULONG_PTR digest_len);

/*	rsa decrypt
 */
CK_RV UT_RSADecrypt(DHANDLE handle, CK_BYTE_PTR cipher, CK_ULONG cipher_len, 
	 CK_BYTE_PTR plain, CK_ULONG_PTR plain_len);

/*	rsa encrypt
 */
CK_RV UT_RSAEncrypt(DHANDLE handle, CK_BYTE_PTR plain, CK_ULONG plain_len, 
	CK_BYTE_PTR cipher, CK_ULONG_PTR cipher_len);

/************************************************************************
	
 ************************************************************************/
/*	获得随机数
 */
CK_RV UT_GetRandom(DHANDLE handle, CK_BYTE_PTR random, CK_ULONG random_len);

/************************************************************************
	hash
 ************************************************************************/

CK_RV UT_Hash(DHANDLE handle, CK_ALG alg, CK_BYTE_PTR data, CK_ULONG data_len);
CK_RV UT_HashFinalize(DHANDLE handle, CK_BYTE_PTR digest, CK_ULONG_PTR digest_len);

/************************************************************************
	en/decrypt
 ************************************************************************/

CK_RV UT_Encrypt(DHANDLE handle, CK_ALG alg, CK_ULONG mode, CK_BYTE_PTR iv, CK_ULONG iv_len, 
	CK_BYTE_PTR plain, CK_ULONG plain_len, CK_BYTE_PTR cipher, CK_ULONG_PTR cipher_len);
CK_RV UT_Decrypt(DHANDLE handle, CK_ALG alg, CK_ULONG mode, CK_BYTE_PTR iv, CK_ULONG iv_len, 
	CK_BYTE_PTR cipher, CK_ULONG cipher_len, CK_BYTE_PTR plain, CK_ULONG_PTR plain_len);

#ifdef __cplusplus
}
#endif

#endif /* __PKI_LIB_DEVICE */