package com.example.demoactivity;



import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.method.ScrollingMovementMethod;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity {

	private Button ExitButton;
	private Button FindButton;
	private ProgressDialog dialog;
	int dialog_count;
	private long flag;
	Handler handler;
	private TextView textView1;
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	requestWindowFeature(Window.FEATURE_NO_TITLE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        textView1=(TextView)findViewById(R.id.textView1);
        
        ExitButton=(Button)findViewById(R.id.exitbutton);
        FindButton=(Button)findViewById(R.id.findbutton);
        
        
        ExitButton.setOnClickListener(listener);
        FindButton.setOnClickListener(listener);
        
        handler = new Handler() {  
	        public void handleMessage(Message msg) {
	        	if(msg.what!=0)
	        	{
	        		AlertDialog.Builder builder1=new AlertDialog.Builder(MainActivity.this);
					builder1.setMessage(R.string.Can_not_find_lock);
					builder1.setPositiveButton(R.string.determine, new DialogInterface.OnClickListener() {
						
						public void onClick(DialogInterface dialog, int which) {
							// TODO Auto-generated method stub
							//dialog.dismiss();  
							dialog.dismiss();
							
						}
					});
	        		
					AlertDialog dialog=builder1.create();
					dialog.show();
	        	}
	        	
	        	super.handleMessage(msg);
	        }};

    }
    private OnClickListener listener=new OnClickListener(){
    	
		public void onClick(View v) {
			// TODO Auto-generated method stub
			
			if(v.getId()==R.id.exitbutton)
			{
				AlertDialog.Builder builder=new AlertDialog.Builder(MainActivity.this);
				
				builder.setMessage(R.string.Whether_to_quit);
				builder.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
					
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						dialog.dismiss();  
						finish(); 
					}
				});
				builder.setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
					
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						
						dialog.dismiss();  
					}
				});
				AlertDialog dialog=builder.create();
				dialog.show();
				
				 
			}
			if(v.getId()==R.id.findbutton)
			{
				dialog = new ProgressDialog(MainActivity.this);
				dialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
				dialog.setTitle(R.string.tip);
	            dialog.setMessage(v.getContext().getString(R.string.Is_looking_for_lock));
                dialog.setIndeterminate(false);
                dialog.setCancelable(true);
                dialog.show();
                new Thread()
                {
                	public void run()
                	{
                		try {
							//Thread.sleep(2000);
                			flag=isConnected();
                	    	if(flag==0)
                	    	{
                	    		Intent intent=new Intent(MainActivity.this,findLockActivity.class);
                					 startActivity(intent);
                					 dialog.dismiss();
                	    	}
                	    	else {
                	    		dialog.dismiss();
                	    		sendMsg(1);
                					}
              		    
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
                		 
                	}
                }.start();
                

			}
			
		}
    	
    };
    
    private void sendMsg(int m) {  
        Message msg = new Message();  
        msg.what = m;  
        handler.sendMessage(msg);  
    } 
  
    public static native long isConnected();
    
    
    static {
        int version = 0;   
        try {   
           version = Integer.valueOf(android.os.Build.VERSION.SDK);   
        } catch (NumberFormatException e) {   
        }
        if(version < 9)
           System.loadLibrary("Demo8");
        else
           System.loadLibrary("Demo"); 
       }



}
