//
//  baseViewController.m
//  SDK_show
//
//  Created by test on 7/08/12.
//  Copyright (c) 2012 test. All rights reserved.
//

#import "baseViewController.h"
#import "UniMate_iOS.h"

@interface baseViewController ()

@end

@implementation baseViewController
@synthesize txtSN;
@synthesize txtran_len;
@synthesize txt;

NSObject<KeyDriverProtocol> *obj;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
        
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    [btnSN setTitle:NSLocalizedString(@"btnSN", nil) forState:UIControlStateNormal];
    [btnRan setTitle:NSLocalizedString(@"btnRan", nil) forState:UIControlStateNormal];
    [txtSN setPlaceholder:NSLocalizedString(@"txtSN", nil)];
    [txtran_len setPlaceholder:NSLocalizedString(@"txtran_len", nil)];
    [txt setEditable:NO];
    
    obj = [[NSClassFromString(@"SecuTech30Device")alloc]init];
    
    UITapGestureRecognizer *tapRecognizer=[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(backgroundTouched:)];
    tapRecognizer.cancelsTouchesInView=NO;
    [self.view addGestureRecognizer:tapRecognizer];

   
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

-(IBAction)backgroundTouched:(UITapGestureRecognizer *)sender
{
    [txtran_len resignFirstResponder];
}

-(IBAction)getSN:(id)sender
{
    NSString * DeviceSN = NULL;
    long connflag = [obj getDeviceSerialNumber:&DeviceSN];
    if(connflag<0)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"failedToSN", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"SNSuccessfully", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
        txtSN.text=DeviceSN;
    }
}

-(IBAction)getRandom:(id)sender
{
    NSString *ran_len=txtran_len.text;
    unsigned long rannum_len=[ran_len longLongValue];
    NSString * randomnum=NULL;
    if (rannum_len==0) {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"baseMessNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else if(rannum_len>=1 &&rannum_len<= 32)
    {
        long connflag=[obj getRandomNumber:&randomnum ran_len:rannum_len];
        
        if (connflag<0) {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"failedToRAN", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
        else {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"RANSuccessfully", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
            NSString *ran=randomnum;
           txt.text=ran;
        }
        
    }
    else {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"baseLenWarn", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
        
    }
}

@end
