//
//  SignViewController.m
//  SDK_show
//
//  Created by test on 7/08/12.
//  Copyright (c) 2012 test. All rights reserved.
//

#import "SignViewController.h"
#import "UniMate_iOS.h"
#import "VerifySign.h"

@interface SignViewController ()

@end

@implementation SignViewController
@synthesize pickerViewArray;
@synthesize picker;

@synthesize lblPin;
@synthesize tfpin;
@synthesize lblType;
@synthesize btnChoose;
@synthesize lblText;
@synthesize tvText;
@synthesize btnSign;
@synthesize tvsign;
@synthesize btnVerity;
@synthesize txttype;

NSObject<KeyDriverProtocol> *obj;
NSString *str;
NSObject *ppCertificate = NULL;
Byte *signData[256];
NSUInteger signdatalen;

-(IBAction)pickerSelected:(id)sender
{
    if (picker==nil) {
        
        picker=[[UIPickerView alloc]initWithFrame:CGRectMake(0,245,320,216)];
        picker.delegate=self;
        picker.dataSource=self;
        [picker setShowsSelectionIndicator:YES];
        
        NSArray *array=[[NSArray alloc]initWithObjects:@"MD5",@"SHA1",@"SH224",@"SHA256",@"SHA384",@"SHA512", nil];
        self.pickerViewArray=array;
        [self.view addSubview:picker]; 
    }
    else {
        picker.hidden=YES;
        picker=nil;
    }
    
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
      
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    signData[256]=nil;
    [lblPin setText:NSLocalizedString(@"lblpin", nil)];
    [tfpin setPlaceholder:NSLocalizedString(@"tfpin", nil)];
    [lblType setText:NSLocalizedString(@"lbltype", nil)];
    [lblText setText:NSLocalizedString(@"lbltext", nil)];
    [btnSign setTitle:NSLocalizedString(@"btnsign", nil) forState:UIControlStateNormal];
    [btnVerity setTitle:NSLocalizedString(@"btnverity", nil) forState:UIControlStateNormal];
    [tvText setText:NSLocalizedString(@"txtpub", nil)];
    [tvsign setEditable:NO];

    obj = [[NSClassFromString(@"SecuTech30Device")alloc]init];
    
 [ [NSNotificationCenter defaultCenter]addObserver:self
                                             selector:@selector(passValue:)
                                                 name:@"test"
                                               object:nil];
    
    UITapGestureRecognizer *tapRecognizer=[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(backgroundTouched:)];
    tapRecognizer.cancelsTouchesInView=NO;
    [self.view addGestureRecognizer:tapRecognizer];
    
    // Do any additional setup after loading the view from its nib.
}

-(void)passValue:(NSNotification *)notification
{
    ppCertificate=[notification object];	
    if (ppCertificate==NULL) {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"signCerNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil)  otherButtonTitles:nil, nil];
        [alert show];
    }
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    signData[256]=nil;
    [[NSNotificationCenter defaultCenter]removeObserver:self name:@"test" object:nil];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}
-(IBAction)backgroundTouched:(UITapGestureRecognizer*)sender
{
	[tfpin resignFirstResponder];
    [tvText resignFirstResponder];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

-(IBAction)signData:(id)sender
{
    NSString *password = tfpin.text;
    NSString *hashID;
    if (password.length==0||ppCertificate==NULL) 
    {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinMessNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
        
    }
    else 
    {
        
        if (txttype.text.length!=0) {
            if ([txttype.text isEqualToString:@"MD5" ]) {
                hashID=@"1.2.840.113549.2.5";
            }
            else if(txttype.text==@"SHA1"){
                hashID=@"1.3.14.3.2.26";
            }
            else if(txttype.text==@"SHA224"){
                hashID=@"2.16.840.1.101.3.4.2.4";
            }
            else if(txttype.text==@"SHA256"){
                hashID=@"2.16.840.1.101.3.4.2.1";
            }
            else if(txttype.text==@"SHA384"){
                hashID=@"2.16.840.1.101.3.4.2.2";
            }
            else {
                hashID=@"2.16.840.1.101.3.4.2.3";
            }            
            
            NSArray *cer=[NSArray arrayWithObject:ppCertificate];
            NSMutableData *Certificate = [[NSMutableData alloc]init];
            Certificate = [cer objectAtIndex:0];
            
            NSData * ppPublicKey = nil;
            unsigned char tempPubKey[20] = {0xd3,0x22,0xdf,0x1e,0xd4,0x0a,0xf4,0x0f,0x99,0x91,0x50,0xfe,0xae,0xea,0xe7,0x03,0xb7,0x25,0x61,0x50};
            ppPublicKey=[NSData dataWithBytes:tempPubKey length:20];
            
            
            NSString *tptxt=tvText.text;
            // unsigned int lentxt=[tptxt length];
            unsigned char tp[300];
            strcpy(tp, [tptxt UTF8String]);
            
            unsigned long tplen = strlen((const char *)tp);    
            NSData *tpdata = nil;
            tpdata = [NSData dataWithBytes:tp length:tplen];
            
            NSData *OutData;
            
            long sign_flag = [obj signData:Certificate pPassword:password srcData:tpdata pHashOID:hashID ppOutData:&OutData]; 
            
            if(sign_flag <0)
            {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"failedToSign",nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton",nil) otherButtonTitles:nil, nil];
                [alert show];
                
                tvsign.text=[[NSString alloc]initWithData:OutData encoding:NSUTF8StringEncoding];
                OutData = nil;
                
            }
            else
            {
                NSString *Content = [[NSString alloc]initWithData:OutData encoding:NSUTF8StringEncoding];
                
                NSUInteger len = [OutData length];
                Byte *byteData = (Byte*)malloc(len);
                memset(byteData, 0, len);
                memcpy(byteData, [OutData bytes], len);
                
                
                NSString *signstr;
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"signedSuccessfully",nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton",nil) otherButtonTitles:nil, nil];
                [alert show];
                
                [tvsign setText:@""];
                
                for(int i = 0 ; i < len ; i++)
                {
                    signstr=[NSString stringWithFormat:@"%02x",byteData[i]];
                    tvsign.text=[tvsign.text stringByAppendingString:signstr];
                    
                }
                
                memcpy(signData, byteData, len);
                
                signdatalen=len;
                
                
                NSFileManager *fileManager = [NSFileManager defaultManager];
                
                NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                NSString *documentsDirectory = [paths objectAtIndex:0];    
                
                [fileManager changeCurrentDirectoryPath:[documentsDirectory stringByExpandingTildeInPath]];
                
                [fileManager createFileAtPath:@"signdata.txt" contents:OutData attributes:nil];
                NSString *path = [documentsDirectory stringByAppendingPathComponent:@"signdata1.txt"];
                
                NSMutableData *writer = [[NSMutableData alloc] init];
                
                [writer appendData:[Content dataUsingEncoding:NSUTF8StringEncoding]];
                
                [writer appendBytes:byteData length:len];
                //[writer appendBytes:&data1 length:sizeof(data1)];
                
                
                [writer writeToFile:path atomically:YES];
                
                OutData = nil;
                
                Content = nil;
                
            }
        }
        else {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"typenull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
    }
}

-(IBAction)verity_Sign:(id)sender
{
    int type;
    NSString *tptxt=tvText.text;
    //unsigned int lentxt=[tptxt length];
    unsigned char tp[300];
    strcpy(tp, [tptxt UTF8String]);
    
    unsigned long tplen = strlen((const char *)tp);
    NSArray *cer=[NSArray arrayWithObject:ppCertificate];
    NSData *Certificate = [[NSData alloc]init];
    Certificate = [cer objectAtIndex:0];
    
    unsigned char *cert =(unsigned char *)[Certificate bytes];
    unsigned long certlen=[Certificate length];
    
    if ([txttype.text isEqualToString:@"MD5"]) {
        type=0;
    }
    else if(txttype.text==@"SHA1"){
        type=1;
    }
    else if(txttype.text==@"SHA224"){
        type=2;
    }
    else if(txttype.text==@"SHA256"){
        type=3;
    }
    else if(txttype.text==@"SHA384"){
        type=4;
    }
    else if(txttype.text==@"SHA512"){
        type=5;
    }
    else {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"typewarn", nil) message:NSLocalizedString(@"typemes", nil) delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    if (signData != NULL &&signdatalen!=NULL) {
        long verityFlag=VerifySign(type, cert,certlen, tp, tplen, signData, signdatalen);
        if (verityFlag!=0) {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"failverity", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
        else {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"sucessverity", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
            
        }
        
    }
    else {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"signnull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
        
    
}

#pragma mark
#pragma mark Picker view
-(NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

-(NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return [pickerViewArray count];
}
-(NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component;
{
    return [pickerViewArray objectAtIndex:row ];
}

-(void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    NSInteger selectedrow = [picker selectedRowInComponent:0];
    NSLog(@"%d",selectedrow);
    
    switch (selectedrow) {
        case 0:
            str=@"MD5";
            break;
        case 1:  
            str=@"SHA1";
            break;
        case 2:
            str=@"SHA224";
            break;
        case 3:
            str=@"SHA256";
            break;
        case 4:
            str=@"SHA384";
            break;
        case 5:
            str=@"SHA512";
            break;
        default:
            break;
    }
    txttype.text=str;
}

@end
