//
//  PinViewController.m
//  SDK_show
//
//  Created by test on 7/08/12.
//  Copyright (c) 2012 test. All rights reserved.
//

#import "PinViewController.h"
#import "UniMate_iOS.h"

@interface PinViewController ()

@end

@implementation PinViewController
@synthesize txtverify;
@synthesize  oldpin;
@synthesize newpin;
@synthesize txtreset;

NSObject<KeyDriverProtocol> *obj;
int i=0;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
       
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    [btnverify setTitle:NSLocalizedString(@"btnverify", nil) forState:UIControlStateNormal];
    [btnmodify setTitle:NSLocalizedString(@"btnmodify", nil) forState:UIControlStateNormal];
    [btnreset setTitle:NSLocalizedString(@"btnreset", nil) forState:UIControlStateNormal];
    [txtverify setPlaceholder:NSLocalizedString(@"txtverify", nil)];
    [oldpin setPlaceholder:NSLocalizedString(@"oldpin", nil)];
    [newpin setPlaceholder:NSLocalizedString(@"newpin", nil)];
    [txtreset setPlaceholder:NSLocalizedString(@"txtreset", nil)];
    
    obj = [[NSClassFromString(@"SecuTech30Device")alloc]init];
    
    UITapGestureRecognizer *tapRecognizer=[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(backgroundTouched:)];
    tapRecognizer.cancelsTouchesInView=NO;
    [self.view addGestureRecognizer:tapRecognizer];
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
-(IBAction)backgroundTouched:(UITapGestureRecognizer *)sender
{
    [txtverify resignFirstResponder];
    [oldpin resignFirstResponder];
    [newpin resignFirstResponder];
    [txtreset resignFirstResponder];
}

-(IBAction)verify_PIN:(id)sender
{
    NSString *verifypin=txtverify.text;
    if (verifypin.length==0) {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinMessNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else {
        
        long flag=[obj verifyPassword:verifypin];
        
        if (flag<0) {
            i++;
            NSString *warn=[NSString stringWithFormat:NSLocalizedString(@"errorCount", nil),6-i];            
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinWarn", nil) message:warn delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
            if (i==6) {
                UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"keylock", nil)  message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
                [alert show];
            }
        }
        else {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinSucess", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
            
        }
    }
}

-(IBAction)change_PIN:(id)sender
{
   	NSString *oldpass=oldpin.text;
	NSString *newpass=newpin.text;
    if (oldpass.length==0||newpass.length==0) {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinMessNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else {
        long ChangeFlag = [obj changePassword:nil oldPwd:oldpass newPwd:newpass];
        if(ChangeFlag < 0)
        {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"modifyFaild", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
        else
        {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"modifySucess", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
            
        }
    }
}

-(IBAction)reset_PIN:(id)sender
{
    NSString *new_pin=txtreset.text;
    if (new_pin.length==0) {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"pinMessNull", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else {
        long flag=[obj resetPassword:new_pin];
        if (flag<0) {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"resetFaild", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
        else {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"resetSucess", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
    }
}

@end
