//
//  CerViewController.m
//  SDK_show
//
//  Created by test on 7/08/12.
//  Copyright (c) 2012 test. All rights reserved.
//

#import "CerViewController.h"
#import "CerInfoViewController.h"
#import "SignViewController.h"
#import "UniMate_iOS.h"
#import "AddUserCert.h"

@interface CerViewController ()

@end


@implementation CerViewController
@synthesize ppCertification;
@synthesize listData;
@synthesize btnimport;


NSObject<KeyDriverProtocol> *obj;
UITableView *table;
UIProgressView *progressView;
float progress;
NSString *progressMsg;
UIAlertView *alert;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    activityIndicatorView = [[UIActivityIndicatorView  alloc ]    
                             initWithFrame:CGRectMake(150,180,30.0,30.0)];  
    activityIndicatorView.activityIndicatorViewStyle= UIActivityIndicatorViewStyleWhiteLarge;  
    activityIndicatorView.hidesWhenStopped = YES;    
    [self.view addSubview:activityIndicatorView ]; 
    [activityIndicatorView startAnimating];
    
    obj = [[NSClassFromString(@"SecuTech30Device")alloc]init];
    
    [NSTimer scheduledTimerWithTimeInterval:0 target:self selector:@selector(readCer:) userInfo:nil repeats:NO];
    
    [btnimport setTitle:NSLocalizedString(@"btnImport", nil) forState:UIControlStateNormal];
    btnimport.hidden=YES;
    
    // Do any additional setup after loading the view from its nib.
}

-(void)readCer:(id)sender
{
    NSArray *pCer;
    
    long GetCerficateFlag = [obj getX509Certificates:&pCer];
    
    [activityIndicatorView stopAnimating];
    
    if (GetCerficateFlag != 0) {
        [btnimport setEnabled:NO];
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"failedToRead", nil) message:nil delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
        [alert show];
    }
    else
    {
		if (pCer.count==0) {
            UIAlertView *alert=[[UIAlertView alloc]initWithTitle:NSLocalizedString(@"warnCer", nil) message:NSLocalizedString(@"cerzero", nil) delegate:self cancelButtonTitle:NSLocalizedString(@"okButton", nil) otherButtonTitles:nil, nil];
            [alert show];
        }
        else {
               NSFileManager *fileManager = [NSFileManager defaultManager];
          
            NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
            NSString *documentsDirectory = [paths objectAtIndex:0];   

            [fileManager changeCurrentDirectoryPath:[documentsDirectory stringByExpandingTildeInPath]];
            
            [fileManager createFileAtPath:@"ppCertificates.db" contents:[pCer objectAtIndex:0] attributes:nil];
            
            ppCertification=pCer;
            
            if (ppCertification.count==0) {
               // btnimport.hidden=YES;
            }
            if (ppCertification.count==1) {
                //btnimport.hidden=YES;
                table=[[UITableView alloc]initWithFrame:CGRectMake(30, 30, 260, 150) style:UITableViewStyleGrouped];
                
            }
            if(ppCertification.count==2)
            {
               // btnimport.hidden=YES;
                table=[[UITableView alloc]initWithFrame:CGRectMake(30, 30, 260, 300) style:UITableViewStyleGrouped];
            }
            [self.view addSubview:table];
            NSArray *array=[NSArray arrayWithObjects:NSLocalizedString(@"cerBase", nil),
                            NSLocalizedString(@"cerSign", nil),nil];
            
            table.dataSource=self;
            table.delegate=self;
            self.listData=array;
            
        }
        
    }
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}


#pragma mark-
#pragma make Tabel view data source methods

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    NSString *title=nil;
    switch (section) {
        case 0:
            title=@"Certification 1:";
            break;
        case  1:
            title=@"Certification 2:";
        default:
            break;
    }
    return title;
}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return  [ppCertification count];
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.listData count];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *Cell=@"Cell";
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:Cell];
    if (cell==nil) {
        cell=[[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:Cell];
    }
    NSUInteger row=[indexPath row];
    cell.textLabel.text=[listData objectAtIndex:row];
    return cell;
    
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    int sec=[indexPath section];
    if (sec==0) {
        if (indexPath.row==0) {
            CerInfoViewController *cerInfo=[[CerInfoViewController alloc]init];
            [self.navigationController pushViewController:cerInfo animated:YES];
            [cerInfo setTitle:NSLocalizedString(@"cerBase", nil)];
            
            
            NSNotification *notification=[NSNotification notificationWithName:@"test" object:[ppCertification objectAtIndex:0] ];
            [[NSNotificationCenter defaultCenter] postNotification:notification];
            
        }
        else  if(indexPath.row==1){
            SignViewController *sign=[[SignViewController alloc]init];
            [self.navigationController pushViewController:sign animated:YES];
            [sign setTitle:NSLocalizedString(@"cerSign", nil)];
            
            NSNotification *notification=[NSNotification notificationWithName:@"test" object:[ppCertification objectAtIndex:0]];
            [[NSNotificationCenter defaultCenter] postNotification:notification];
        }
        
    }
    if(sec==1) {
        if (indexPath.row==0) {
            CerInfoViewController *cerInfo=[[CerInfoViewController alloc]init];
            [self.navigationController pushViewController:cerInfo animated:YES];
            [cerInfo setTitle:NSLocalizedString(@"cerBase", nil)];
            
            
            NSNotification *notification=[NSNotification notificationWithName:@"test" object:[ppCertification objectAtIndex:1] ];
            [[NSNotificationCenter defaultCenter] postNotification:notification];
            
        }
        else  if(indexPath.row==1){
            SignViewController *sign=[[SignViewController alloc]init];
            [self.navigationController pushViewController:sign animated:YES];
            [sign setTitle:NSLocalizedString(@"cerSign", nil)];
            
            NSNotification *notification=[NSNotification notificationWithName:@"test" object:[ppCertification objectAtIndex:1] ];
            [[NSNotificationCenter defaultCenter] postNotification:notification];
        }
        
    }
}        
@end
