//
//  CerInfoViewController.m
//  SDK_show
//
//  Created by test on 7/08/12.
//  Copyright (c) 2012 test. All rights reserved.
//

#import "CerInfoViewController.h"
#import "x509.h"
#import	"x509v3.h"
#import "asn1.h"

@interface CerInfoViewController ()

@end

@implementation CerInfoViewController
@synthesize txtfrom;
@synthesize txtto;
@synthesize txtdate;

NSObject *mes=NULL;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void)passValue:(NSNotification *)notification
{
    mes=[notification object];
	
    [NSTimer scheduledTimerWithTimeInterval:0 target:self selector:@selector(executeFunction) userInfo:nil repeats:NO];
    
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    [lblbase setText:NSLocalizedString(@"cerBase", nil)];
    [lblfrom setText:NSLocalizedString(@"lblfrom", nil)];
    [lblto setText:NSLocalizedString(@"lblto", nil)];
    [lbltime setText:NSLocalizedString(@"lbltime", nil)]; 
    
    [ [NSNotificationCenter defaultCenter]addObserver:self
                                             selector:@selector(passValue:)
                                                 name:@"test"
                                               object:nil];
}


- (void)executeFunction
{
    if (mes!=nil) {
        NSArray *cer=[NSArray arrayWithObject:mes];
        NSMutableData *Certificate = [[NSMutableData alloc]init];
        Certificate=[cer objectAtIndex:0];
        
        unsigned char *lpcbuf =(unsigned char *)[Certificate bytes];
        const unsigned char *lpper=lpcbuf;
        
        unsigned char issuer_name_char[100];
        unsigned char *lpissuer_name_char = issuer_name_char;
        
        unsigned char subject_name_char[100];
        unsigned char *lpsubject_name_char = subject_name_char;
        
        unsigned char issuerbuf[100]={0};
        
        unsigned char subjectbuf[100]={0};
        
        unsigned char timebuf[100]={0};
        
        int entriesNum;
        int len;
        
        unsigned char name_num = 0;
        
        unsigned long clen = [Certificate length];
        
        X509 *x = d2i_X509(NULL, &lpper, clen);
        X509_NAME *	issuer_name = X509_get_issuer_name(x);
        entriesNum = sk_X509_NAME_ENTRY_num(issuer_name->entries);
        for (int i=0;i<entriesNum;i++)
        {
            X509_NAME_ENTRY* name_entry = sk_X509_NAME_ENTRY_value(issuer_name->entries,i);
            int Nid = OBJ_obj2nid(name_entry->object);
            if (Nid==NID_commonName)
            {
                lpissuer_name_char = NULL;
                if((len = ASN1_STRING_to_UTF8(&lpissuer_name_char,name_entry->value))<0)
                    continue;
                if (name_num==0) 
                {
                    name_num++;
                }
                else 
                {
                    strcat(issuerbuf, "                ");
                }
                strcat(issuerbuf, lpissuer_name_char);
                strcat(issuerbuf, "\n");
            }
        }
        
        name_num = 0;
        X509_NAME *	subject_name = X509_get_subject_name(x);
        entriesNum = sk_X509_NAME_ENTRY_num(subject_name->entries);
        for (int i=0;i<entriesNum;i++)
        {
            X509_NAME_ENTRY* name_entry = sk_X509_NAME_ENTRY_value(subject_name->entries,i);
            int Nid = OBJ_obj2nid(name_entry->object);
            if (Nid==NID_commonName)
            {
                lpsubject_name_char = NULL;
                if((len = ASN1_STRING_to_UTF8(&lpsubject_name_char,name_entry->value))<0)
                    continue;
                if (name_num==0) 
                {
                    name_num++;
                }
                else 
                {
                    
                    strcat(subjectbuf, "                ");
                }
                strcat(subjectbuf,lpsubject_name_char);
                strcat(subjectbuf, "\n");
            }
        }
        
        ASN1_TIME * notAfter = X509_get_notAfter(x);
        
        unsigned char time[64] = {0};
        unsigned char* lptime = time;
        ASN1_GENERALIZEDTIME * gen_time = 0;
        
        ASN1_STRING_to_UTF8(&lptime, notAfter); 
        
        sprintf(timebuf, "20%c%c-%c%c-%c%c",lptime[0], lptime[1], lptime[2], lptime[3], lptime[4],lptime[5]);
        
        printf("CER:\nfrom:%sto:%sDate:%s", issuerbuf, subjectbuf, timebuf);
        
        NSString *strfrom=[[NSString alloc]initWithCString:issuerbuf encoding:nil];
        txtfrom.text=strfrom;
        NSString *strto=[[NSString alloc]initWithCString:subjectbuf encoding:nil];
        txtto.text=strto;
        NSString *strdate=[[NSString alloc]initWithCString:timebuf encoding:nil];
        txtdate.text=strdate;
        
    }
    else {
        UIAlertView *alert=[[UIAlertView alloc]initWithTitle:nil message:@"无证书数据" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:@"取消", nil];
        [alert show];
    }
}



- (void)viewDidUnload
{
    [super viewDidUnload];
    [[NSNotificationCenter defaultCenter]removeObserver:self name:@"test" object:nil];
    
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}



- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
