#include "AddUserCert.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include <openssl/sha.h>

#ifndef TYPE_DEF
#define TYPE_DEF
typedef unsigned char   CK_BYTE, *CK_BYTE_PTR;
typedef unsigned long	CK_ULONG, *CK_ULONG_PTR;
typedef CK_ULONG		CK_ALG;
typedef unsigned short	CK_FID; 
typedef unsigned short	CK_SHORT, *CK_SHORT_PTR;
typedef unsigned long	UT_HANDLE, *UT_HANDLE_PTR;
typedef CK_ULONG		DHANDLE, *DHANDLE_PTR;	
typedef CK_ULONG		CK_RV;	
#endif
#define CKR_USER_ANOTHER_ALREADY_LOGGED_IN 0x0104
#define MAX_DEVICE_COUNT 256
#define SIG_TYPE 0x02
#define HASH_SHA1   1

CK_RV find_device(DHANDLE handle[MAX_DEVICE_COUNT], CK_ULONG_PTR count);
CK_RV verify_pin(DHANDLE handle, CK_BYTE_PTR pin, CK_ULONG pin_len);
CK_RV import_cert(DHANDLE handle, CK_BYTE_PTR pub_hash, CK_ULONG pub_hash_len,
                  CK_BYTE_PTR cert, CK_ULONG cert_len);
CK_RV signature(DHANDLE handle, CK_BYTE_PTR pub_hash, CK_ULONG pub_hash_len, CK_ALG hash_alg, 
                CK_BYTE_PTR data, CK_ULONG data_len, CK_BYTE_PTR sign_data, CK_ULONG_PTR sign_data_len);
CK_RV generate_rsa(DHANDLE handle, CK_ULONG bit, CK_ULONG key_spec, 
                   CK_BYTE_PTR der_pub, CK_ULONG_PTR der_pub_len);


static struct HARD_CERT_STRUCT hardwareCert;
static DHANDLE handles[MAX_DEVICE_COUNT];
static unsigned long handleCount = 0;
static unsigned char tempSignedResult[256];
static unsigned long tempSignedResultLen = 256;
static unsigned char tempPubKey[256];
static unsigned long tempPubKeyLen = 0;


void initHardCert(struct HARD_CERT_STRUCT *cert)
{
	memset(cert, 0x00, sizeof(struct HARD_CERT_STRUCT));
	unsigned short tempShortLen;
	unsigned char tempCharLenH;
	unsigned char tempCharLenL;
    
	memset(cert->title, TYPE_SEQUENCE, 1);
	memset(cert->title+1, 0x82, 1);
	tempShortLen = sizeof(cert->body) +
    sizeof(cert->signAlg) +
    sizeof(cert->signedData);
	tempCharLenH = tempShortLen / 256;
	tempCharLenL = tempShortLen % 256;
	memcpy(cert->title+2, &tempCharLenH, 1);
	memcpy(cert->title+3, &tempCharLenL, 1);
    
	memset(cert->body.title, TYPE_SEQUENCE, 1);
	memset(cert->body.title+1, 0x82, 1);
	tempShortLen = sizeof(cert->body.version) +
    sizeof(cert->body.signAlg) +
    sizeof(cert->body.dn1) +
    sizeof(cert->body.time) +
    sizeof(cert->body.dn2) +
    sizeof(cert->body.pubKey);
	tempCharLenH = tempShortLen / 256;
	tempCharLenL = tempShortLen % 256;
	memcpy(cert->body.title+2, &tempCharLenH, 1);
	memcpy(cert->body.title+3, &tempCharLenL, 1);
    
	unsigned char version[] = CERT_VERSION;
	for (int i=2; i<11; ++i)
	{
		version[i] = rand() % 256;
	}
	memcpy(cert->body.version, version, sizeof(cert->body.version));
    
	unsigned char signedAlg[] = SHA1_RSA_ENCRYPTION;
	unsigned char nullStr[] = NULL_STRING;
	memset(cert->body.signAlg.title, TYPE_SEQUENCE, 1);
	memset(cert->body.signAlg.title+1, 0x0d, 1);
	memcpy(cert->body.signAlg.OID, signedAlg, sizeof(cert->body.signAlg.OID));
	memcpy(cert->body.signAlg.nullItem, nullStr,sizeof(cert->body.signAlg.nullItem));
    
	memset(cert->body.dn1.title, TYPE_SEQUENCE, 1);
	tempCharLenL = sizeof(cert->body.dn1) - sizeof(cert->body.dn1.title);
	memcpy(cert->body.dn1.title+1, &tempCharLenL, 1);
    
	unsigned char dnCStr[] = DN_C_OID;
	unsigned char dnSTStr[] = DN_ST_OID;
	unsigned char dnOStr[] = DN_O_OID;
	unsigned char dnLStr[] = DN_L_OID;
	unsigned char dnOUStr[] = DN_OU_OID;
	unsigned char dnCNStr[] = DN_CN_OID;
	unsigned char dnSetTitleStr[] = {TYPE_SET, 0x0b};
	unsigned char dnSqTitleStr[] = {TYPE_SEQUENCE, 0x09};
	memcpy(cert->body.dn1.SET_C.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_C.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_C.OID, dnCStr, sizeof(cert->body.dn1.SET_C.OID));
	memset(cert->body.dn1.SET_C_VALUE, TYPE_PRINTABLESTRING, 1);
    
	memcpy(cert->body.dn1.SET_ST.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_ST.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_ST.OID, dnSTStr, sizeof(cert->body.dn1.SET_ST.OID));
	memset(cert->body.dn1.SET_ST_VALUE, TYPE_UTF8STRING, 1);
	memcpy(cert->body.dn1.SET_L.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_L.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_L.OID, dnLStr, sizeof(cert->body.dn1.SET_L.OID));
	memset(cert->body.dn1.SET_L_VALUE, TYPE_UTF8STRING, 1);
    
	memset(dnSetTitleStr+1, 0x0d, 1);
	memset(dnSqTitleStr+1, 0x0b, 1);
	memcpy(cert->body.dn1.SET_O.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_O.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_O.OID, dnOStr, sizeof(cert->body.dn1.SET_O.OID));
	memset(cert->body.dn1.SET_O_VALUE, TYPE_UTF8STRING, 1);
    
	memcpy(cert->body.dn1.SET_OU.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_OU.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_OU.OID, dnOUStr, sizeof(cert->body.dn1.SET_OU.OID));
	memset(cert->body.dn1.SET_OU_VALUE, TYPE_UTF8STRING, 1);
    
	tempCharLenL = sizeof(cert->body.dn1.SET_CN) - sizeof(cert->body.dn1.SET_CN.set_title) + sizeof(cert->body.dn1.SET_CN_VALUE);
	memcpy(dnSetTitleStr+1,&tempCharLenL, 1);
	tempCharLenL = sizeof(cert->body.dn1.SET_CN) - sizeof(cert->body.dn1.SET_CN.set_title) - sizeof(cert->body.dn1.SET_CN.sq_title) + sizeof(cert->body.dn1.SET_CN_VALUE);
	memcpy(dnSqTitleStr+1, &tempCharLenL, 1);
	memcpy(cert->body.dn1.SET_CN.set_title, dnSetTitleStr, 2);
	memcpy(cert->body.dn1.SET_CN.sq_title, dnSqTitleStr, 2);
	memcpy(cert->body.dn1.SET_CN.OID, dnCNStr, sizeof(cert->body.dn1.SET_CN.OID));
	memset(cert->body.dn1.SET_CN_VALUE, TYPE_UTF8STRING, 1);
	tempCharLenL = CN_LEN - 2;
	memcpy(cert->body.dn1.SET_CN_VALUE+1, &tempCharLenL, 1);
    
    
	memset(cert->body.pubKey.title, TYPE_SEQUENCE, 1);
	memset(cert->body.pubKey.title+1, 0x81, 1);
	tempCharLenL = sizeof(cert->body.pubKey) - sizeof(cert->body.pubKey.title);
	memcpy(cert->body.pubKey.title+2, &tempCharLenL, 1);
    
	unsigned char PubKeyOIDStr[] = RSA_ENCRYPTION;
	memset(cert->body.pubKey.Alg.title, TYPE_SEQUENCE, 1);
	tempCharLenL = sizeof(cert->body.pubKey.Alg) - sizeof(cert->body.pubKey.Alg.title);
	memcpy(cert->body.pubKey.Alg.title+1, &tempCharLenL, 1);
	memcpy(cert->body.pubKey.Alg.OID, PubKeyOIDStr, sizeof(cert->body.pubKey.Alg.OID));
	memcpy(cert->body.pubKey.Alg.nullItem, nullStr, 2);
    
	memset(cert->body.pubKey.dataTitle, TYPE_BITSTRING, 1);
	tempCharLenH = PUBKEY_LEN / 256;
	tempCharLenL = PUBKEY_LEN % 256;
	if (tempCharLenH == 0)
	{
		memset(cert->body.pubKey.dataTitle+1, 0x81, 1);
		memcpy(cert->body.pubKey.dataTitle+2, &tempCharLenL, 1);
	}
	else
	{
		memset(cert->body.pubKey.dataTitle+1, 0x82, 1);
		memcpy(cert->body.pubKey.dataTitle+2, &tempCharLenH, 1);
		memcpy(cert->body.pubKey.dataTitle+3, &tempCharLenL, 1);
	}
    
    
	unsigned char PubKeyTitleStr[] = {0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00}; 
	unsigned long PubKeyTitleStrLen = PUBKEY_START_LOCATION; 	
	unsigned char PubKeyEndStr[] = {0x02, 0x03, 0x01, 0x00, 0x01}; 	
	unsigned long PubKeyEndStrLen = 5; 
	memcpy(cert->body.pubKey.data, PubKeyTitleStr, PubKeyTitleStrLen); 
	memcpy(cert->body.pubKey.data+PubKeyTitleStrLen + 128, PubKeyEndStr, PubKeyEndStrLen);  	
    
	memset(cert->body.time.title, TYPE_SEQUENCE, 1);
	memset(cert->body.time.title+1, 0x1e, 1);
    
	memset(cert->body.time.startTime, TYPE_UTCTIME, 1);
	memset(cert->body.time.startTime+1, 0x0d, 1);
    
	memset(cert->body.time.stopTime, TYPE_UTCTIME, 1);
	memset(cert->body.time.stopTime+1, 0x0d, 1);
    
	memset(cert->signedData.title, TYPE_BITSTRING, 1);
	tempCharLenH = SIGNED_LEN / 256;
	tempCharLenL = SIGNED_LEN % 256;
	if (tempCharLenH == 0)
	{
		memset(cert->signedData.title+1, 0x81, 1);
		memcpy(cert->signedData.title+2, &tempCharLenL, 1);
	}
	else
	{
		memset(cert->signedData.title+1, 0x82, 1);
		memcpy(cert->signedData.title+2, &tempCharLenH, 1);
		memcpy(cert->signedData.title+3, &tempCharLenL, 1);
	}
    
	memcpy((unsigned char*)&(hardwareCert.signAlg), (unsigned char*)&(hardwareCert.body.signAlg), sizeof(hardwareCert.signAlg));
	unsigned char tempSignAlg []= SHA1_RSA_ENCRYPTION;
	memcpy(hardwareCert.signAlg.OID, tempSignAlg, sizeof(hardwareCert.signAlg.OID));
	memcpy(hardwareCert.signAlg.nullItem, nullStr, 2);
    
}

int generateCertBody()
{
    
	unsigned char printNumber[] = "123456789012345678";
	unsigned long printNumberLen = strlen((char*)printNumber);
	unsigned char OU_orged[] = "TEST";
	unsigned long OU_orged_LEN = 4;
	unsigned char O_orged[] = "TEST";
	unsigned long O_orged_LEN = 4;
	unsigned char L_orged[] = "BJ";
	unsigned long L_orged_LEN = 2;
	unsigned char ST_orged[] = "BJ";
	unsigned long ST_orged_LEN = 2;
	unsigned char C_orged[] = "CN";
	unsigned long C_orged_LEN = 2;
    
	unsigned char tempOrgLen = 0;
	initHardCert(&hardwareCert);
    
	tempOrgLen = printNumberLen;
	memcpy(hardwareCert.body.dn1.SET_CN_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_CN_VALUE+2, printNumber, tempOrgLen);
    
	tempOrgLen = OU_orged_LEN;
	memcpy(hardwareCert.body.dn1.SET_OU_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_OU_VALUE+2, OU_orged, tempOrgLen);
    
	tempOrgLen = O_orged_LEN;
	memcpy(hardwareCert.body.dn1.SET_O_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_O_VALUE+2, O_orged, tempOrgLen);
    
	tempOrgLen = L_orged_LEN;
	memcpy(hardwareCert.body.dn1.SET_L_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_L_VALUE+2, L_orged, tempOrgLen);
    
	tempOrgLen = ST_orged_LEN;
	memcpy(hardwareCert.body.dn1.SET_ST_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_ST_VALUE+2, ST_orged, tempOrgLen);
    
	tempOrgLen = C_orged_LEN;
	memcpy(hardwareCert.body.dn1.SET_C_VALUE+1, &tempOrgLen, 1);
	memcpy(hardwareCert.body.dn1.SET_C_VALUE+2, C_orged, tempOrgLen);
    
    
	memcpy((unsigned char*)&(hardwareCert.body.dn2), (unsigned char*)&(hardwareCert.body.dn1), sizeof(hardwareCert.body.dn2));
    
	struct tm *curTime; 
	time_t t; 
	t=time(0);
	curTime = localtime(&t);
	char tempTime[14];
	sprintf(tempTime,"%02d%02d%02d%s",curTime->tm_year%100, curTime->tm_mon+1, curTime->tm_mday, TIME_END);
	memcpy(hardwareCert.body.time.startTime+2, (unsigned char*)tempTime, 13);
	sprintf(tempTime,"%02d%02d%02d%s",curTime->tm_year%100 + DURATION_YEARS, curTime->tm_mon+1, curTime->tm_mday, TIME_END);
	memcpy(hardwareCert.body.time.stopTime+2, (unsigned char*)tempTime, 13);
    	
	memcpy(hardwareCert.body.pubKey.data+PUBKEY_START_LOCATION, tempPubKey, tempPubKeyLen);
    
    
	unsigned long i=0;
	return 0;
}


int generateCert(unsigned char* cert, unsigned long* certLen)
{
#if (!TARGET_IPHONE_SIMULATOR) 
	UT_Initialize();
#endif
	int i;	

	memset(hardwareCert.signedData.data, 0x00, 1);

	unsigned char tempSignedData[128];
	for (i=0; i<128; i++)
	{
		tempSignedData[i] = tempSignedResult[127-i];
	}
	//end
	memcpy(hardwareCert.signedData.data+1, tempSignedData, tempSignedResultLen);
    
	if (cert != NULL  && certLen != NULL)
	{
        memset(cert,0,1024);
		unsigned long tempLen = sizeof(hardwareCert);
		*certLen = tempLen;
		memcpy(cert, (unsigned char*)&hardwareCert, tempLen);
	}
#if (!TARGET_IPHONE_SIMULATOR) 
    UT_Finalize();
#endif
	return 0;
}


int generateKeyPair(unsigned long publicKeyLen)
{
#if (!TARGET_IPHONE_SIMULATOR) 
	UT_Initialize();
#endif
	unsigned long ret = 0;
	DHANDLE handles[MAX_DEVICE_COUNT];
	unsigned long handleCount = 0;
	unsigned char tempBigPubKey[200];
	unsigned long tempBigPubKeyLen = 200;
    
	ret = find_device(handles, &handleCount);
	if (ret !=0 || handleCount <= 0)
	{
		printf("get device error!\n");
#if (!TARGET_IPHONE_SIMULATOR) 
		UT_Finalize();
#endif
		return ret;
	}
    
	ret = verify_pin(handles[0], (CK_BYTE_PTR)"00000000", 8);
	printf("verify_pin : ret = %04x, currentHandle = %d\n", ret, handles[0]);
	if (ret != 0 && ret != CKR_USER_ANOTHER_ALREADY_LOGGED_IN)
	{
#if (!TARGET_IPHONE_SIMULATOR) 
		UT_Finalize();
#endif
		return ret;
	}
    
	ret = generate_rsa(handles[0], publicKeyLen*8, SIG_TYPE, (CK_BYTE_PTR)tempBigPubKey, &tempBigPubKeyLen);
	printf("generate_rsa : ret = %04x\n", ret);
	if (ret != 0)
	{
#if (!TARGET_IPHONE_SIMULATOR) 
		UT_Finalize();
#endif
		return ret;
	}
    
	memcpy(tempPubKey, tempBigPubKey+7, publicKeyLen);
	tempPubKeyLen = publicKeyLen;
#if (!TARGET_IPHONE_SIMULATOR) 
    UT_Finalize();
#endif
	return 0;
}

int importNewCert()
{
#if (!TARGET_IPHONE_SIMULATOR) 
	UT_Initialize();
#endif
	int ret;
	unsigned char HASH[20];
    
	SHA_CTX c;
	SHA1_Init(&c);
	SHA1_Update(&c, tempPubKey, tempPubKeyLen);
	SHA1_Final(HASH, &c);
    
	ret = import_cert(handles[0], HASH, 20, (CK_BYTE_PTR)&hardwareCert, sizeof(hardwareCert));
	if (ret != 0)
	{
#if (!TARGET_IPHONE_SIMULATOR) 
        UT_Finalize();
#endif
		return ret;
	}
#if (!TARGET_IPHONE_SIMULATOR) 
    UT_Finalize();
#endif
	return 0;
}

int signCert()
{
#if (!TARGET_IPHONE_SIMULATOR) 
	UT_Initialize();
#endif
	int ret;
	unsigned char HASH[20];
    
	SHA_CTX c;
	SHA1_Init(&c);
	SHA1_Update(&c, tempPubKey, tempPubKeyLen);
	SHA1_Final(HASH, &c);
    
	unsigned char* src = (unsigned char*)&(hardwareCert.body);
	unsigned long srcLen = sizeof(hardwareCert.body);
    
	ret = signature(handles[0],HASH, 20, HASH_SHA1, src, srcLen, tempSignedResult, &tempSignedResultLen);
	if (ret != 0)
	{
#if (!TARGET_IPHONE_SIMULATOR) 
        UT_Finalize();
#endif
		return ret;
	}
#if (!TARGET_IPHONE_SIMULATOR) 
    UT_Finalize();
#endif
	return 0;
}