#ifndef CREATE_CERT
#define CREATE_CERT

#define CN_LEN 18+2
#define OU_LEN 4+2
#define O_LEN 4+2
#define L_LEN 2+2
#define ST_LEN 2+2
#define C_LEN 2+2
#define PUBKEY_LEN 141 //1024 bit
#define SIGNED_LEN 129 //1024 bit
#define PUBKEY_START_LOCATION 8
#define PUBKEY_STRUCT_LEN 3+(PUBKEY_LEN/256) 
#define SIGNED_STRUCT_LEN 3+(SIGNED_LEN/256) 
//#define DN_C					"CN"
//#define DN_ST					"BJ"
//#define DN_L					"BJ"
//#define DN_O					"TEST"
//#define DN_OU					"TEST"

#define TIME_END				"091904Z"
#define DURATION_YEARS			20

#define CERT_VERSION			{0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
#define SHA1_RSA_ENCRYPTION		{0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05}
#define RSA_ENCRYPTION			{0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01}
#define NULL_STRING				{0x05, 0x00}															//3-4
#define SHA1_HASH_OID			{0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x05, 0x00, 0x04, 0x14}

#define DN_C_OID				{0x06, 0x03, 0x55, 0x04, 0x06}
#define DN_ST_OID				{0x06, 0x03, 0x55, 0x04, 0x08}
#define DN_L_OID				{0x06, 0x03, 0x55, 0x04, 0x07}
#define DN_O_OID				{0x06, 0x03, 0x55, 0x04, 0x0a}
#define DN_OU_OID				{0x06, 0x03, 0x55, 0x04, 0x0b}
#define DN_CN_OID				{0x06, 0x03, 0x55, 0x04, 0x03}

#define TYPE_PRINTABLESTRING	0x13
#define TYPE_UTF8STRING			0x0c
#define TYPE_SET				0x31
#define TYPE_SEQUENCE			0x30
#define TYPE_BITSTRING			0x03
#define TYPE_UTCTIME			0x17

struct DN_CHILD_TITLE_STRUCT{
	unsigned char set_title[2];
	unsigned char sq_title[2];
	unsigned char OID[5];
};

struct DN_STRUCT{
	unsigned char title[2];
	struct DN_CHILD_TITLE_STRUCT SET_C;
	unsigned char SET_C_VALUE[C_LEN];
	struct DN_CHILD_TITLE_STRUCT SET_ST;
	unsigned char SET_ST_VALUE[ST_LEN];
	struct DN_CHILD_TITLE_STRUCT SET_L;
	unsigned char SET_L_VALUE[L_LEN];
	struct DN_CHILD_TITLE_STRUCT SET_O;
	unsigned char SET_O_VALUE[O_LEN];
	struct DN_CHILD_TITLE_STRUCT SET_OU;
	unsigned char SET_OU_VALUE[OU_LEN];
	struct DN_CHILD_TITLE_STRUCT SET_CN;
	unsigned char SET_CN_VALUE[CN_LEN];
};
struct VALIDTIME_STRUCT{
	unsigned char title[2];
	unsigned char startTime[15];
	unsigned char stopTime[15];
};
struct SIGN_ALG_STRUCT{
	unsigned char title[2];
	unsigned char OID[11];
	unsigned char nullItem[2];
};
struct PUBLICKEY_STRUCT{
	unsigned char title[PUBKEY_STRUCT_LEN];
	struct SIGN_ALG_STRUCT Alg;
	unsigned char dataTitle[PUBKEY_STRUCT_LEN];
	unsigned char data[PUBKEY_LEN];
};
struct SIGNED_DATA_STRUCT{
	unsigned char title[SIGNED_STRUCT_LEN];
	unsigned char data[SIGNED_LEN];
};

struct CERT_BODY_STRUCT{
	unsigned char title[4];
	unsigned char version[11];
	struct SIGN_ALG_STRUCT signAlg;
	struct DN_STRUCT dn1;
	struct VALIDTIME_STRUCT time;
	struct DN_STRUCT dn2;
	struct PUBLICKEY_STRUCT pubKey;
};

struct HARD_CERT_STRUCT{
	unsigned char title[4];
	struct CERT_BODY_STRUCT body;
	struct SIGN_ALG_STRUCT signAlg;
	struct SIGNED_DATA_STRUCT signedData; 
};

struct SHA1_PADDING_STRUCT{
	unsigned char title[15];
	unsigned char data[20];
};



int generateKeyPair(unsigned long publicKeyLen);

int generateCertBody();

int signCert();


int generateCert(unsigned char* cert, unsigned long* certLen);

int importNewCert();


#endif