<?php

UniKeySample();

function UniKeySample(){
	$handle = array(16);
	//get version
	$output = UniKey_Get_Version($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Version error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey lib ver: " . $output['version'] . "<br>");

	// find dongle
	$lp1    = 1;
	$lp2    = 0;
	$output = UniKey_Find($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Find error code: " . $output['retcode'] . "<br>");
		return;
	}
	// return the hardware ID (HID)                             
	echo ("Find UniKey: " . $output['hid'] . "<br>");
	echo ("Number of UniKey's inserted: " . $output['donglenum'] . "<br>");
	$handle[0] = $output['handle'];
	// open dongle
	$p1        = 1234;
	$p2        = 1234;
	$output    = UniKey_User_Logon($handle[0], $p1, $p2);
	if ($output['retcode'] != 0) {
		echo ("UniKey_User_Logon error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Successfully logged in as User<br>");

	$p1     = 1234;
	$p2     = 1234;
	$p3     = 1234;
	$p4     = 1234;
	$output = UniKey_Vender_Logon($handle[0], $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Vender_Logon error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Successfully logged in as Admin<br>");

	//get type
	$lp1    = 0;
	$output = UniKey_Get_Type($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Type error code: " . $output['retcode'] . "<br>");
		return;
	} else {
		echo ("UniKey_Get_Type: " . $output['type'] . "<br>");
	}

	if ($output['type'] === 101){//UniKey Time type
		UniKeyTimeSample($handle[0]);//perform UniKey Time sample
	}

	// enumerate all the dongles
	$i = 0;
	while ($output['retcode'] === 0) {
		// find next dongle
		$output = UniKey_Find_Next($handle[$i]);
		if ($output['retcode'] == 214) {
			//214 is code for no dongles left
			break;
		}
		if ($output['retcode'] != 0) {
			echo ("UniKey_Find_Next error code: " . $output['retcode'] . "<br>");
			break;
		}
		// return the hardware ID (HID)                             
		echo ("Find UniKey: " . $output['hid'] . "<br>");
		echo ("Number of UniKey's inserted: " . $output['donglenum'] . "<br>");
		
		// open dongle
		$p1     = 1234;
		$p2     = 1234;
		$output = UniKey_User_Logon($handle[0], $p1, $p2);
		if ($output['retcode'] != 0) {
			echo ("UniKey_User_Logon error code: " . $output['retcode'] . "<br>");
		}
		echo ("Successfully logged in as User<br>");
		
		$p1     = 1234;
		$p2     = 1234;
		$p3     = 1234;
		$p4     = 1234;
		$output = UniKey_Vender_Logon($handle[0], $p1, $p2, $p3, $p4);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Vender_Logon error code: " . $output['retcode'] . "<br>");
		}
		echo ("Successfully logged in as Admin<br>");
		
		$i++;
	}
	echo ("<br>");

	$p1         = 0;//start
	$p2         = 15;//length
	//$byte_array = unpack('C*', 'teststarthere');
	$byte_array = 'ABCDEFGHIJKLMNO';
	// write dongle memory
	//printf("write dongle memory");
	$output     = UniKey_Write_Memory($handle[0], $p1, $p2, $byte_array);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_Memory error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write memory successful<br>");

	$p1     = 4;//start
	$p2     = 9;//length
	$output = UniKey_Read_Memory($handle[0], $p1, $p2);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_Memory error code: " . $output['retcode'] . "<br>");
		return;
	}

	echo ("Read: ");
	for ($i = 0; $i < $p2; $i++) {
		echo ($output['buffer'][$i]);
	}
	echo ("<br>");

	// random generation function
	$output = UniKey_Random($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Random error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Random 1: " . $output['random1'] . ", ");
	echo ("Random 2: " . $output['random2'] . ", ");
	echo ("Random 3: " . $output['random3'] . ", ");
	echo ("Random 4: " . $output['random4'] . "<br>");

	// seed function, you can use either hex or dec
	$lp1    = 1234;//Seed value
	$output = UniKey_Seed($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Seed error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Random 1: " . $output['random1'] . ", ");
	echo ("Random 2: " . $output['random2'] . ", ");
	echo ("Random 3: " . $output['random3'] . ", ");
	echo ("Random 4: " . $output['random4'] . "<br>");

	// write SoftID
	$lp1    = 1234;
	$output = UniKey_Write_SoftID($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_SoftID error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write SoftID successful<br>");

	// read SoftID
	$lp1    = 0;
	$output = UniKey_Read_SoftID($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_SoftID error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Read SoftID: " . $output['SID'] . "<br>");

	// set license module
	$p1     = 7;//license number
	$p2     = 10;//amount
	$p3     = 0;//decrement allowed = 1, not allowed =0
	$output = UniKey_Set_Module($handle[0], $p1, $p2, $p3);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Module error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Set License module 7, Decrease not allowed<br>");

	// check license module
	$p1     = 7;//license module
	$output = UniKey_Check_Module($handle[0], $p1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Check_Module error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Check MODULE 7: ");

	if ($output['valid'] === 1) {
		echo ("Valid and ");
	} else {
		echo ("Not valid and ");
	}
	if ($output['decrement'] === 1) {
		echo ("can be decreased<br>");
	} else {
		echo ("can not be decreased<br>");
	}

	// write user-defined algorithm
	$p1        = 0;//starting point
	$algorithm = "A=A+B, C=C+D";//algorithm, length calculated automatically
	$output    = UniKey_Write_Arithmetic($handle[0], $p1, $algorithm);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_Arithmetic error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write Arithmetic 1 successful: " . $algorithm . "<br>");

	// calculation 1
	$lp1    = 0;
	$lp2    = 0;
	$p1     = 1;
	$p2     = 2;
	$p3     = 3;
	$p4     = 4;
	$output = UniKey_Calculate1($handle[0], $lp1, $lp2, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Calculate1 error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Calculate 1 Input: p1=1, p2=2, p3=3, p4=4<br>");
	echo ("Expected result = 1+2, 2, 3+4, 4<br>");
	echo ("Calculate 1 Output: ");
	echo ("p1=" . $output['regA'] . " p2=" . $output['regB'] . " p3=" . $output['regC'] . " p4=" . $output['regD'] . "<br>");

	// Set License Module Decrease
	$p1     = 9;//license module
	$p2     = 5;//value
	$p3     = 1;//1 = decrease-able
	$output = UniKey_Set_Module($handle[0], $p1, $p2, $p3);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Module error code: " . $output['retcode'] . "<br>");
		return;
	}

	// Decrease License Module
	$p1     = 9;
	$output = UniKey_Module_Decrase($handle[0], $p1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Module_Decrase error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Decrease module 9<br>");

	/*
	//------------------------------------
	// Generate new password
	// If you really want to change password, please de-comment these codes
	// Please remember the generated passwords. One UniKey can only generate new passwords twice
	// Conctact support@esecutech.com or assistance.
	$lp1=65534;	//password seed
	echo ("Generate new passwords with seed: " . $lp1 . "<br>");
	$output = UniKey_Generate_New_Password($handle[0],$lp1) ; 
	if ($output['retcode'] != 0) {
	echo ("New password error code: " . $output['retcode'] . "<br>");
	return;
	}
	echo ("Generated new passwords successfully<br>");
	echo ("Password 1: " . $output['pw1'] . ", ");
	echo ("Password 2: " . $output['pw2'] . ", ");
	echo ("Password 3: " . $output['pw3'] . ", ");
	echo ("Password 4: " . $output['pw4'] . "<br>");
	*/

	//------------------------------
	// 	// generate key via seed 
	echo ("Generate new encryption key via seed for Key 1<br>");
	$lp1    = 1;//key container, 1~3
	$p1     = 1111;//seed 1
	$p2     = 2222;//seed 2
	$p3     = 3333;//seed 3
	$p4     = 4444;//seed 4
	$output = UniKey_Generate_Key_Via_Seed($handle[0], $lp1, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Generate_Key_Via_Seed error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Generate_Key_Via_Seed for key 1 successful<br>");

	// generate key via random
	echo ("Generate new encryption key for Key 1 by random<br>");
	$lp1    = 1;
	$output = UniKey_Generate_Key($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Generate key successful<br>");
	
	//encrypt
	$lp1 = 16;
	$lp2 = 1;
	//$byte_array = 'testingencryptor';
	$output     = UniKey_Encrypt($handle[0], $lp1, $lp2, 'testingencryptor');
	if ($output['retcode'] != 0) {
		echo ("UniKey Encryption error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Encryption successful, result: ");
	$encrypted_result           = array();
	$encrypted_result           = $output['buffer'];
	$encrypted_result_container = "";
	for ($i = 0; $i < $lp1; $i++) {
		$encrypted_result_container = $encrypted_result_container . $encrypted_result[$i];
	}
	echo ($encrypted_result_container . "<br>");

	// decrypt
	$lp1              = 16;
	$lp2              = 1;
	$decrypted_result = array();
	$output           = UniKey_Decrypt($handle[0], $lp1, $lp2, $encrypted_result);
	if ($output['retcode'] != 0) {
		echo ("UniKey Decryption error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Decryption successful, result: ");
	$decrypted_result = $output['buffer'];
	for ($i = 0; $i < $lp1; $i++) {
		echo ($decrypted_result[$i]);
	}
	echo ("<br>");

	// MD5
	$lp1        = 12;//length
	//$byte_array = unpack('C*', 'testingencryptor');
	$MD5output  = "";
	$MD5array   = array();
	$output     = UniKey_MD5($handle[0], $lp1,'test1234abcd');
	if ($output['retcode'] != 0) {
		echo ("UniKey MD5 error code: " . $output['retcode'] . "<br>");
		return;
	}
	$MD5array = $output['MD5'];
	echo ("MD5 generated, result: ");
	for ($i = 0; $i < 32; $i++) {
		echo($MD5output . $MD5array[$i]);
	}
	echo ("<br>");

	// write UpdateTag
	$lp1    = 1234;
	$output = UniKey_Write_UpdateTag($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write UpdateTag successful<br>");

	// read UpdateTag
	$output = UniKey_Read_UpdateTag($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_UpdateTag error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Read UpdateTag: " . $output['Uptag'] . "<br>");	

	// close dongle
	$output = UniKey_Logoff($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Logoff error code: " . $output['retcode'] . "<br>");
		return;
	}
	
	echo ("logged off successfully");
}

function UniKeyTimeSample($handle){

echo("<br>Start UniKey Time sample<br>");

	$output = UniKey_Get_Time($handle);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Time error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Get Time: ");
	echo ($output['day'] . "/" . $output['month'] . "/" . $output['year'] . " ");
	echo ($output['hour'] . ":" . $output['minute'] . ":" . $output['second'] . "<br>");

		$lp1 = 1;
		$output = UniKey_Erase_Time_Module($handle, $lp1);
		if ($output['retcode'] != 0) {
			echo("UniKey_Erase_Time_Module error code: " . $output['retcode'] . "<br>");
			return;
		}
		echo ("UniKey_Erase_Time_Module " . $lp1 . ", successful<br>");
		
		$output = UniKey_Set_Time_Module_Start_Time_Now($handle, $lp1);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Get_Time_Now error code: " . $output['retcode'] . "<br>");
			return;
		}
		echo ("UniKey_Set_Time_Module_Start_Time_Now " . $lp1 . ", successful<br>");
		$lp1=1;
		$lp2 = 10; // duration is 10 Day
		$p1  = 6; // and 6 hour
		$output = UniKey_Set_Time_Module_Duration($handle, $lp1, $lp2, $p1);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Set_Time_Now error code: " . $output['retcode'] . "<br>");
			return;
		}
		$lp1=1;
		$output = UniKey_Check_Time_Module_Now($handle, $lp1);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Check_Time_Module_Now, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
			return;
		}
		echo("UniKey_Check_Time_Module_Now Mudule: " . $lp1 . " Successful<br>");
		echo("Days left: " . $output['daysleft'] . " hours left: " . $output['hoursleft'] . "<br>");
		
		
		$lp1=1;
		$output = UniKey_Get_Module_Start_Time($handle, $lp1);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Get_Module_Start_Time, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
			return;
		}
		echo("UniKey_Get_Module_Start_Time Mudule: " . $lp1 . " Successful<br>");
		echo("Year: " . $output['year'] . " Month: " . $output['month'] . " Day: " . $output['day'] . " hour: " . $output['hour'] . "<br>");
		
		$output = UniKey_Get_Module_End_Time($handle, $lp1);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Get_Module_End_Time, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
			return;
		}
		echo("UniKey_Get_Module_End_Time Mudule: " . $lp1 . " Successful<br>");
		echo("Year: " . $output['year'] . " Month: " . $output['month'] . " Day: " . $output['day'] . " hour: " . $output['hour'] . "<br>");
		
		echo("End UniKey Time sample<br>");
	
}

?>
