package Key;	//modifed 2014-05-05

public class KeyObj //modifed 2014-05-05
{
	public static void main(String[] args) {

	}

	public KeyObj() {
		System.loadLibrary("KeyJava");
	}

	// 1. API reference
	public native int UniKey_SetNETINILocation(short[] pHandle, int[] pSetting1, int[] pSetting2, byte[] szINIPath);
	public native int UniKey_Find(short[] pHandle, int[] pSetting1, int[] pSetting2);
	public native int UniKey_Find_Next(short[] pHandle, int[] pSetting1, int[] pSetting2);

	public native int UniKey_User_Logon(short[] pHandle, short[] pPassword1, short[] pPassword2);
	public native int UniKey_Vender_Logon(short[] pHandle, short[] pPassword1, short[] pPassword2, short[] pPassword3, short[] pPassword4);
	public native int UniKey_Vendor_Logon(short[] pHandle, short[] pPassword1, short[] pPassword2, short[] pPassword3, short[] pPassword4);
	public native int UniKey_Logoff(short[] pHandle);

	public native int UniKey_Get_Version(short[] pHandle, int[] pVersion);
	public native int UniKey_Get_Type(short[] pHandle, int[] type);
	
	public native int UniKey_Lock(short[] pHandle);
	public native int UniKey_UnLock(short[] pHandle);

	public native int UniKey_Read_Memory(short[] pHandle, short[] pStartAddress, short[] pBufferLength, byte[] pBuffer);
	public native int UniKey_Write_Memory(short[] pHandle, short[] pStartAddress, short[] pBufferLength, byte[] pBuffer);

	public native int UniKey_Random(short[] pHandle, short[] pReturn1, short[] pReturn2, short[] pReturn3, short[] pReturn4);
	public native int UniKey_Seed(short[] pHandle, int[] pSeed, short[] pReturn1, short[] pReturn2, short[] pReturn3, short[] pReturn4);

	public native int UniKey_Write_SoftID(short[] pHandle, int[] pSoftID);
	public native int UniKey_Read_SoftID(short[] pHandle, int[] pSoftID);

	public native int UniKey_Set_Module(short[] pHandle, short[] pModule, short[] pValue, short[] pDecrease);
	public native int UniKey_Get_Module(short[] pHandle, short[] pModule, short[] pValue);
	public native int UniKey_Check_Module(short[] pHandle, short[] pModule, short[] pValue, short[] pDecrease);
	public native int UniKey_Module_Decrase(short[] pHandle, short[] pModule);
	public native int UniKey_Module_Decrease(short[] pHandle, short[] pModule);

	public native int UniKey_Write_Arithmetic(short[] pHandle, short[] pStartAddress, byte[] pBuffer);
	public native int UniKey_Calculate1(short[] pHandle, int[] pStartAddress, int[] pModule, short[] pRegA, short[] pRegB, short[] pRegC, short[] pRegD);
	public native int UniKey_Calculate2(short[] pHandle, int[] pStartAddress, int[] pSeed, short[] pRegA, short[] pRegB, short[] pRegC, short[] pRegD);
	public native int UniKey_Calculate3(short[] pHandle, int[] pStartAddress, int[] pModule, short[] pRegA, short[] pRegB, short[] pRegC, short[] pRegD);
	
	public native int UniKey_Generate_New_Password(short[] pHandle, int[] pSeed, short[] pPassword1, short[] pPassword2, short[] pPassword3, short[] pPassword4);
	public native int UniKey_Generate_New_Password_Advanced(short[] pHandle, int[] pSeed, int[] pSeed2, short[] pPassword1, short[] pPassword2, short[] pPassword3, short[] pPassword4);
	public native int UniKey_Generate_Key(short[] pHandle, int[] pKeyNumber);
	public native int UniKey_Generate_Key_Via_Seed(short[] pHandle, int[] pKeyNumber, short[] pSeed1, short[] pSeed2, short[] pSeed3, short[] pSeed4);
	public native int UniKey_Encrypt(short[] pHandle, int[] pBufferLength, int[] pKeyNumber, byte[] pBuffer);
	public native int UniKey_Decrypt(short[] pHandle, int[] pBufferLength, int[] pKeyNumber, byte[] pBuffer);
	public native int UniKey_MD5(short[] pHandle, int[] pBufferLength, byte[] pBuffer);

	public native int UniKey_Read_UpdateTag(short[] pHandle, int[] pUpdateTag);
	public native int UniKey_Write_UpdateTag(short[] pHandle, int[] pUpdateTag);


	// 2. UniKey Time only API
	public native int UniKey_Get_Time(short[] pHandle, int[] pYear, int[] pMonth, short[] pDay, short[] pHour, short[] pMinute, short[] pSecond);
	public native int UniKey_Set_Time(short[] pHandle, int[] pYear, int[] pMonth, short[] pDay, short[] pHour, short[] pMinute, short[] pSecond);
	public native int UniKey_Set_Time_Now(short[] pHandle);
	public native int UniKey_Erase_Time_Module(short[] pHandle, int[] pModule);
	public native int UniKey_Set_Time_Module_Start_Time(short[] pHandle, int[] pModule, short[] pYear, short[] pMonth, short[] pDay, short[] pHour);
	public native int UniKey_Set_Time_Module_Start_Time_Now(short[] pHandle, int[] pModule);
	public native int UniKey_Set_Time_Module_Start_Time_Now_PC(short[] pHandle, int[] pModule);
	public native int UniKey_Set_Time_Module_End_Time(short[] pHandle, int[] pModule, short[] pYear, short[] pMonth, short[] pDay, short[] pHour);
	public native int UniKey_Set_Time_Module_Duration(short[] pHandle, int[] pModule, int[] pYear, short[] pDay);
	public native int UniKey_Check_Time_Module(short[] pHandle, int[] pModule, int[] pRemainDays, short[] pYear, short[] pMonth, short[] pDay, short[] pHour);
	public native int UniKey_Check_Time_Module_Now(short[] pHandle, int[] pModule, int[] pRemainDays, short[] pRemainHours);
	public native int UniKey_Check_Time_Module_Now_PC(short[] pHandle, int[] pModule, int[] pRemainDays, short[] pRemainHours);
	public native int UniKey_Get_Module_Start_Time(short[] pHandle, int[] pModule, short[] pYear, short[] pMonth, short[] pDay, short[] pHour);
	public native int UniKey_Get_Module_End_Time(short[] pHandle, int[] pModule, short[] pYear, short[] pMonth, short[] pDay, short[] pHour);

	// Network Functions
	public native int UniKey_Get_Dongle_Location(short[] pHandle, int[] pIPAddress);
	public native int UniKey_Get_Cli_Num(short[] pHandle, int[] cnt);
	public native int UniKey_Get_Max_Num(short[] pHandle, short[] cnt);
	public native int UniKey_Set_Max_Num(short[] pHandle, short[] cnt);

	// define the standard NetUniKey API
	public native int UniKey(short Function, short[] handle, int[] lp1, int[] lp2, short[] p1, short[] p2, short[] p3, short[] p4, byte[] buffer);
	
	// function keywords
	final public short UNIKEY_FIND								= 1;		// Find UniKey
	final public short UNIKEY_FIND_NEXT		    				= 2;   	// Find next UniKey
	final public short UNIKEY_LOGON								= 3; 		// Open UniKey
	final public short UNIKEY_LOGOFF			    			= 4;		// Close UniKey
	final public short UNIKEY_READ_MEMORY						= 5;		// Read UniKey
	final public short UNIKEY_WRITE_MEMORY		    			= 6;		// Write UniKey
	final public short UNIKEY_RANDOM		    				= 7;		// Generate Random Number
	final public short UNIKEY_SEED								= 8;		// Generate Seed Code
	final public short UNIKEY_WRITE_SOFTID						= 9;		// Write Software ID
	final public short UNIKEY_READ_SOFTID						= 10;		// Read Software ID
	final public short UNIKEY_SET_MODULE						= 11;		// Set Module
	final public short UNIKEY_CHECK_MODULE						= 12;		// Check Module
	final public short UNIKEY_WRITE_ARITHMETIC					= 13;		// Write Arithmetic
	final public short UNIKEY_CALCULATE1		    			= 14;		// Calculate 1
	final public short UNIKEY_CALCULATE2		    			= 15;		// Calculate 2
	final public short UNIKEY_CALCULATE3		    			= 16;		// Calculate 3
	final public short UNIKEY_MODULE_DECRASE					= 17;		// Decrease Module Unit
	final public short UNIKEY_MODULE_DECREASE					= 17;		// Decrease Module Unit
	final public short UNIKEY_SET_NEW_PASSWORD					= 18;		// Set New Password via a New Seed
	final public short UNIKEY_GENERATE_KEY						= 19;		// Generate a New Key in specific Key Store
	final public short UNIKEY_SET_KEY							= 222;		// set/write the 128-bit key
	final public short UNIKEY_ENCRYPT							= 20;		// Encrypt the Buffer with a Specific Key
	final public short UNIKEY_DECRYPT							= 21;		// Decrypt the Buffer with a Specific Key
	final public short UNIKEY_MD5								= 22;		// Make an MD5 Digest for a Certain Content
	final public short UNIKEY_READ_UPDATETAG					= 23;		// Read UpdateTag from a Specific Key
	final public short UNIKEY_WRITE_UPDATETAG					= 24;		// Write UpdateTag to a Specific Key
	final public short UNIKEY_GET_MODULE						= 25;		// p1 [in] Number [p3] out Value

	//Real Time Clock Functions [if no comment, (lp1 = module index)]
	final public short UNIKEY_GET_TIME							= 26;		// read rtc time (lp1,lp2,p1,p2,p3,p4 = year,month,day,hour,minute,second)
	final public short UNIKEY_SET_TIME							= 27;		// write rtc time (lp1,lp2,p1,p2,p3,p4 = year,month,day,hour,minute,second)
	final public short UNIKEY_SET_TIME_NOW						= 28;		// write rtc time use host time
	final public short UNIKEY_ERASE_TIME_MODULE					= 29;		// ERASE TIME MODULE to NULL,
	final public short UNIKEY_SET_TIME_MODULE_START_TIME		= 30;		// write rtc time module start time(p1,p2,p3,p4 = year,month,day,hour)
	final public short UNIKEY_SET_TIME_MODULE_START_TIME_NOW	= 31;		// write rtc time module start time use dongle time
	final public short UNIKEY_SET_TIME_MODULE_START_TIME_NOW_PC	= 32;		// write rtc time module start time use host time
	final public short UNIKEY_SET_TIME_MODULE_END_TIME			= 33;		// write rtc time module end time (p1,p2,p3,p4 = year,month,day,hour)
	final public short UNIKEY_SET_TIME_MODULE_DURATION			= 34;		// write rtc time module duration (lp2,p1 = day,hour)=24*day+hour
	final public short UNIKEY_CHECK_TIME_MODULE					= 35;		// check if a time >START_TIME and the time < END_TIME(or START_TIME+DURATION) (p1,p2,p3,p4 = year,month,day,hour)
	final public short UNIKEY_CHECK_TIME_MODULE_NOW				= 36;		// check if now >START_TIME and now < END_TIME(or START_TIME+DURATION) use dongle time
	final public short UNIKEY_CHECK_TIME_MODULE_NOW_PC			= 37;		// check if now >START_TIME and now < END_TIME(or START_TIME+DURATION) use host time
	final public short UNIKEY_GET_MODULE_START_TIME				= 38;		// get module start time
	final public short UNIKEY_GET_MODULE_END_TIME				= 39;		// get module end time

	final public short UNIKEY_LOCK								= 41;		// Lock a dongle
	final public short UNIKEY_UNLOCK							= 42;		// UnLock a dongle
	
	// Unikey Type
	final public short UNIKEY_GET_TYPE							= 100;		//get the Unikey type
	final public short UNIKEY_TYPE_TIME							= 101;		//TIME_UNIKEY
	final public short UNIKEY_TYPE_PRO							= 102;		//PRO_UNIKEY
	final public short UNIKEY_TYPE_STD							= 103;		//STD_UNIKEY

	// Network Function
	final public short NET_UNIKEY_SET_NUM_CLIENT				= 225;		// set the number of client for netunikey
	final public short NET_UNIKEY_GET_NUM_CLIENT				= 226;		// get the number of client for netunikey

	final public short UNKEY_GET_CLI_NUM						= 101;		//get cli num now
	final public short UNKEY_GET_MAX_NUM						= 226;		//GET MAX NUM


	// Error Codes
	final public int SUCCESS									= 0;	//Success
	final public int ERROR_UNIKEY_NOT_FOUND						= 200;	//No UniKey Dongle
	final public int ERROR_UNIKEY_INVALID_PASSWORD				= 201;	//Found UniKey Dongle, But Basic Password[] Is Wrong
	final public int ERROR_UNIKEY_INVALID_PASSWORD_OR_ID		= 202;	//Wrong Password[] Or UniKey HID
	final public int ERROR_UNIKEY_SET_SOFTID_FAILED				= 203;	//Set UniKey ID Failed
	final public int ERROR_UNIKEY_INVALID_ADDR_OR_SIZE			= 204;	//Read/Write Address Or Length Is Wrong
	final public int ERROR_UNIKEY_UNKNOWN_COMMAND				= 205;	//No Such Command
	final public int ERROR_UNIKEY_NOTBELEVEL3                   = 206;  //Internal Error
	final public int ERROR_UNIKEY_READ_MEMORY					= 207;	//Read Memory Failed
	final public int ERROR_UNIKEY_WRITE_MEMORY					= 208;	//Write Memory Failed
	final public int ERROR_UNIKEY_RANDOM						= 209;	//Random Number Failed
	final public int ERROR_UNIKEY_SEED							= 210;	//Get Seed Code Failed
	final public int ERROR_UNIKEY_CALCULATE						= 211;	//Calculate Failed
	final public int ERROR_UNIKEY_NEED_OPEN						= 212;	//Need Open Dongle Before Operating Dongle
	final public int ERROR_UNIKEY_OPEN_OVERFLOW					= 213;	//Too Many Open Dongles (>16)
	final public int ERROR_UNIKEY_NOMORE						= 214;	//No More Dongle
	final public int ERROR_UNIKEY_NEED_FIND						= 215;	//No Find Before FindNext
	final public int ERROR_UNIKEY_MODULE						= 216;	//License Module Error
	final public int ERROR_UNIKEY_AR_BAD_COMMAND				= 217;	//Arithmetic Instruction Error
	final public int ERROR_UNIKEY_AR_UNKNOWN_OPCODE				= 218;	//Arithmetic Operator Error
	final public int ERROR_UNIKEY_AR_WRONG_BEGIN				= 219;	//Const Number Can't Use On First Arithmetic Instruction
	final public int ERROR_UNIKEY_AR_WRONG_END					= 220;	//Const Number Can't Use On Last Arithmetic Instruction
	final public int ERROR_UNIKEY_AR_VALUE_OVERFLOW				= 221;	//Const Number > 63
	final public int ERROR_UNIKEY_INVALID_KEY					= 222;	//The Key In The Key Storage Is Wrong
	final public int ERROR_UNIKEY_VERIFY_ADV_PASSWORD			= 223;	//Advanced Password[]s (Passshort[]3 and Password4) Not Verified
	final public int ERROR_UNIKEY_INVALID_KEY_STORE				= 224;	//Wrong Key Storage Number
	final public int ERROR_UNIKEY_GENERATE_NEW_PASSWORD			= 225;	//Generate New Passshort[] Failed
	final public int ERROR_UNIKEY_READ_UPDATETAG				= 226;	//Read UpdateTag Failed
	final public int ERROR_UNIKEY_WRITE_UPDATETAG				= 227;	//Write UpdateTag Failed
	final public int ERROR_UNIKEY_ENCRYPT_FAILED				= 228;	//Encrypt Data Failed
	final public int ERROR_UNIKEY_DECRYPT_FAILED				= 229;	//Decrypt Data Failed
	final public int ERROR_UNIKEY_READ_TIME						= 230;	//Get UniKey Time Failed
	final public int ERROR_UNIKEY_WRITE_TIME					= 231;	//Set UniKey Time Failed
	final public int ERROR_UNIKEY_WRITE_TIME_MODULE				= 232;	//Write Time Module Error
	final public int ERROR_UNIKEY_COMPARE_TIME_MODULE			= 233;	//The Specific Time Is Before The Module’s Start Time
	final public int ERROR_UNIKEY_TIME_MODULE_NOT_NULL			= 234;	//The Real Time Module Is Not Null, This Error is returned when write once flag is set
	final public int ERROR_UNIKEY_TIME_MODULE_OVERDUR			= 235;	//The Specific Time Is Later Than The Module's End Time, Or The Module Is Expired
	final public int ERROR_UNIKEY_ALREADY_LOCKED				= 236;	//Dongle Already Locked (When Lock Twice Or Open After Lock)

	// UniKey Drive Special Error Codes
	final public int ERROR_UNIKEY_MAX_USERS						= 237;  //Dongle Already Max Users(32) Logoned
	final public int ERROR_UNIKEY_MAX_KEYS						= 238;  //Dongle Already Max Keys, Need To Delete And The Regenerate, RSA_KEY :4 DES_KEY 15
	final public int ERROR_UNIKEY_KEY_INDEX						= 239;  //Dongle Over Keyindex, No Key To  Delete
	final public int ERROR_UNIKEY_FS_FILE_NAME					= 240;	//Wrong Or Invalid File Name
	final public int ERROR_UNIKEY_FS_NO_FILE					= 241;	//No Such File Name
	final public int ERROR_UNIKEY_FS_FILE_OFFSET				= 242;	//Offset Of File Error
	final public int ERROR_UNIKEY_FS_UNKONW						= 243;	//Unknown Error
	final public int ERROR_UNIKEY_FS_NO_MEMORY					= 244;	//Not Enough Free Memory
	final public int ERROR_UNIKEY_FS_FILE_EXIST					= 245;	//File Already Existed

	final public int ERROR_UNIKEY_FS_ERR_SYS_UNINIT				= 246;	//File Sys Is Not Initialized
	final public int ERROR_UNIKEY_FS_ERR_OPEN_FILE				= 247;	//Can't Open File
	final public int ERROR_UNIKEY_NO_ENCYYPT					= 248;	//No Secure Drive
	final public int ERROR_UNIKEY_PASSWORD						= 249;	//Password[] Error
	final public int ERROR_UNIKEY_USERLOCK						= 250;	//User Has Been Locked
	final public int ERROR_UNIKEY_LOGOUT						= 251;	//ERRO_LOGOUT
	final public int ERROR_UNIKEY_UNKNOW						= 252;	//ERRO_UNKNOW

	final public int ERROR_UNIKEY_WRITE_ARITHMETIC              = 253; //Dongle Write Arithmetic is ERROR
	final public int ERROR_UNIKEY_PARAMETER                     = 254;
	final public int ERROR_UNIKEY_TOO_MUCH_THREAD               = 255; //Too many (>100) threads in the single process open the dongle
	final public int ERROR_UNIKEY_GET_TYPE		                = 256;

	//add by liuzq 2015
	final public int ERROR_UNIKEY_FILE_LOCK_OPEN	            = 260;	//open lock file error
	final public int ERROR_UNIKEY_FILE_LOCK_CLOSE	            = 261;	//close lock file error

	// NetUniKey Error Codes (Network Function Error Code)*/
	final public int NET_UNIKEY_ERROR_BASE						= 100;							// NetUniKey Error Base
	final public int NET_UNIKEY_MEMORY_ERROR					= NET_UNIKEY_ERROR_BASE + 1;	// Memory Allocation Error
	final public int NET_UNIKEY_SEND_ERROR						= NET_UNIKEY_ERROR_BASE + 2;	// Send Error
	final public int NET_UNIKEY_RECEIVE_ERROR					= NET_UNIKEY_ERROR_BASE + 3;	// Receive Error
	final public int NET_UNIKEY_MESSAGE_WRONG					= NET_UNIKEY_ERROR_BASE + 4;	// Communication Message Is Modified
	final public int NET_UNIKEY_SETUP_SOCKET_ERROR				= NET_UNIKEY_ERROR_BASE + 5;	// Setup Socket Error
	final public int NET_UNIKEY_CLIENT_EXSIT					= NET_UNIKEY_ERROR_BASE + 6;	// The Client Already Exists, Per This Mode
	final public int NET_UNIKEY_TOO_MANY_CLIENT					= NET_UNIKEY_ERROR_BASE + 7;	// The Number Of Client Reach The Limitation
	final public int NET_UNIKEY_IN_BLACKLIST					= NET_UNIKEY_ERROR_BASE + 8;	// The Client Is In The Black List
	final public int NET_UNIKEY_OUT_WHITELIST					= NET_UNIKEY_ERROR_BASE + 9;	// The Client Is Not In The White List
	final public int NET_UNIKEY_MESSAGE_CHANGE					= NET_UNIKEY_ERROR_BASE + 10;	// The Message Packet Was Changed
	final public int NET_UNIKEY_AREADY_START					= NET_UNIKEY_ERROR_BASE + 11;	// The Server Has Already Started
	final public int NET_UNIKEY_SOCKET_INIT_FAILED				= NET_UNIKEY_ERROR_BASE + 12;	// Cannot Initialize The Socket
	final public int NET_UNIKEY_SOCKET_BIND_FAILED				= NET_UNIKEY_ERROR_BASE + 13;	// Cannot Bind The Port With The Socket
	final public int NET_UNIKEY_SOCKET_LISTEN_FAILED			= NET_UNIKEY_ERROR_BASE + 14;	// Cannot Start Listening With The Socket
	final public int NET_UNIKEY_START_UDP_SERVER_FAILED			= NET_UNIKEY_ERROR_BASE + 15;	// Start Udp Server Failed
	final public int NET_UNIKEY_TOO_LONG_MESSAGE				= NET_UNIKEY_ERROR_BASE + 16;	// Too Long Message
	final public int NET_UNIKEY_NOT_WORKING						= NET_UNIKEY_ERROR_BASE + 17;	// Cannot Connect Remote Netunikey Server
	final public int NET_UNIKEY_DISCARD_BY_SERVER				= NET_UNIKEY_ERROR_BASE + 18;	// The Client Is Discarded By The Server
	final public int NET_UNIKEY_SERVER_RESOURCE_INADEQUACY		= NET_UNIKEY_ERROR_BASE + 19;	// by lzm
	final public int NET_UNIKEY_INIFILE_NOT_EXISTS				= NET_UNIKEY_ERROR_BASE + 20;	// ZhaoHJ: 2015-08-13, INI file not exists
}



