unit unikey;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Dialogs;

const


// Error Code
 SUCCESS			= 0;	//Success
 ERROR_UNIKEY_NOT_FOUND				=200;	//No UniKey dongle
 ERROR_UNIKEY_INVALID_PASSWORD		=201;	//Found UniKey dongle, but basic password is wrong
 ERROR_UNIKEY_INVALID_PASSWORD_OR_ID		=202;	//Wrong password or UniKey HID
 ERROR_UNIKEY_SET_SOFTID_FAILED			=203;	//Set UniKey ID failed
 ERROR_INVALID_ADDR_OR_SIZE			=204;	//Read/Write address or length is wrong
 ERROR_UNIKEY_UNKNOWN_COMMAND			=205;	//No such command
 ERROR_UNIKEY_READ_MEMORY				=207;	//Read memory failed
 ERROR_UNIKEY_WRITE_MEMORY				=208;	//Write memory failed
 ERROR_UNIKEY_RANDOM						=209;	//Random number failed
 ERROR_UNIKEY_SEED						=210;	//Get seed code failed
 ERROR_UNIKEY_CALCULATE					=211;	//Calculate failed
 ERROR_UNIKEY_NEED_OPEN					=212;	//Need open dongle before operating dongle
 ERROR_UNIKEY_OPEN_OVERFLOW				=213;	//Too many open dongles (>16)
 ERROR_UNIKEY_NOMORE						=214;	//No more dongle
 ERROR_UNIKEY_UNIKEYNEED_FIND			=215;	//No Find before FindNext
 ERROR_UNIKEY_MODULE						=216;	//License module error
 ERROR_UNIKEY_AR_BAD_COMMAND				=217;	//Arithmetic instruction Error
 ERROR_UNIKEY_AR_UNKNOWN_OPCODE			=218;	//Arithmetic operator Error
 ERROR_UNIKEY_AR_WRON_GBEGIN				=219;	//Const number can't use on first arithmetic instruction
 ERROR_UNIKEY_AR_WRONG_END				=220;	//Const number can't use on last arithmetic instruction
 ERROR_UNIKEY_AR_VALUE_OVERFLOW			=221;	//Const number > 63
 ERROR_UNIKEY_INVALID_KEY				=222;	//The key in the key storage is wrong
 ERROR_UNIKEY_VERIFY_ADV_PASSWORD		=223;	//Advanced passwords (password3 and passowrd4) not verified
 ERROR_UNIKEY_INVALID_KEY_STORE			=224;	//Wrong key storage number
 EEROR_UNIKEY_GENERATE_NEW_PASSWORD		=225;	//Generate new password failed
 ERROR_UNIKEY_READ_UPDATETAG				=226;	//Read UpdateTag failed
 ERROR_UNIKEY_WRITE_UPDATETAG			=227;	//Write UpdateTag failed
 ERROR_UNIKEY_ENCRYPT_FAILED				=228;	//Encrypt data failed
 ERROR_UNIKEY_DECRYPT_FAILED				=229;	//Decrypt datafailed
 ERROR_UNIKEY_READ_TIME					=230;	//Get UniKey time failed
 ERROR_UNIKEY_WRITE_TIME					=231;	//Set UniKey time failed
 ERROR_UNIKEY_WRITE_TIME_MODULE			=232;	//Write time module error
 ERROR_UNIKEY_COMPARE_TIME_MODULE		=233;	//The specific time is before the module’s start time
 ERROR_UNIKEY_TIME_MODULE_NOT_NULL		=234;	//The real time module is not null, this error is returned when write once flag is set
 ERROR_UNIKEY_TIME_MODULE_OVERDUR		=235;	//The specific time is later than the module’s end time, or the module is expired
 ERROR_UNIKEY_ALREADY_LOCKED				=236;	//Dongle Already Locked (when lock twice or open after lock)
//NetUniKey Error Code
 NET_UNIEKY_ERROR_BASE				=100;							// net unikey error base
 NET_UNIKEY_MEMORY_ERROR				=NET_UNIEKY_ERROR_BASE+1;		// memory allocation error
 NET_UNIKEY_SEND_ERROR				=NET_UNIEKY_ERROR_BASE+2;		// send error
 NET_UNIEY_RECEIVE_ERROR				=NET_UNIEKY_ERROR_BASE+3;		// receive error
 NET_UNIKEY_MESSAGE_WRONG			=NET_UNIEKY_ERROR_BASE+4;		// communication message is modified
 NET_UNIKEY_SETUP_SOCKET_ERROR		=NET_UNIEKY_ERROR_BASE+5;		// setup socket error
 NET_UNIKEY_CLIENT_EXSIT				=NET_UNIEKY_ERROR_BASE+6;		// the client already exists, per this mode
 NET_UNIKEY_TOO_MANY_CLIENT			=NET_UNIEKY_ERROR_BASE+7;		// the number of client reach the limitation
 NET_UNIKEY_IN_BLACKLIST				=NET_UNIEKY_ERROR_BASE+8;		// the client is in the black list
 NET_UNIKEY_OUT_WHITELIST			=NET_UNIEKY_ERROR_BASE+9;		// the client is not in the white list
 NET_UNIKEY_MESSAGE_CHANGE			=NET_UNIEKY_ERROR_BASE+10;	// the message packet was changed
 NET_UNIKEY_AREADY_START				=NET_UNIEKY_ERROR_BASE+11;	// the server has already started
 NET_UNIKEY_SOCKET_INIT_FAILED		=NET_UNIEKY_ERROR_BASE+12;	// cannot initialize the socket
 NET_UNIKEY_SOCKET_BIND_FAILED		=NET_UNIEKY_ERROR_BASE+13;	// cannot bind the port with the socket
 NET_UNIKEY_SOCKET_LISTEN_FAILED		=NET_UNIEKY_ERROR_BASE+14;	// cannot start listening with the socket
 NET_UNIKEY_START_UDP_SERVER_FAILED	=NET_UNIEKY_ERROR_BASE+15;	// start udp server failed
 NET_UNIKEY_TOO_LONG_MESSAGE			=NET_UNIEKY_ERROR_BASE+16;	// too long message
 NET_UNIKEY_NOT_WORKING				=NET_UNIEKY_ERROR_BASE+17;	// cannot connect remote netunikey server
 NET_UNIKEY_DISCARD_BY_SERVER		=NET_UNIEKY_ERROR_BASE+18;	// the client is discarded by the server

	function UniKey (funcode: integer; handle: pWord; lp1: pLongWord; lp2: pLongWord; p1: pWord; p2: pWord; p3: pWord; p4: pWord; buffer: pByteArray): DWORD;stdcall;
	external 'UniKey.so' name 'UniKey';

	function UniKey__Find(pHandle:pWord;pSetting1:pLongWord;pSetting2:pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Find';
	function UniKey__Find_Next(pHandle:pWord;pSetting1:pLongWord;pSetting2:pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Find_Next';
	function UniKey__Lock(pHandle:pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Lock';
	function UniKey__UnLock(pHandle:pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_UnLock';
	function UniKey__User_Logon(pHandle:pWord; pPassword1: pWord; pPassword2: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_User_Logon';
	function UniKey__Vender_Logon(pHandle:pWord; pPassword1: pWord; pPassword2: pWord; pPassword3: pWord; pPassword4: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Vender_Logon';
	function UniKey__Logoff(pHandle:pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Logoff';
	function UniKey__Read_Memory(pHandle:pWord; pStartAddress: pWord; pBufferLength: pWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Read_Memory';
	function UniKey__Write_Memory(pHandle:pWord; pStartAddress: pWord; pBufferLength: pWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Write_Memory';
	function UniKey__Random(pHandle:pWord; pReturn1: pWord; pReturn2: pWord; pReturn3: pWord; pReturn4: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Random';
	function UniKey__Seed(pHandle:pWord; pSeed: pLongWord; pReturn1: pWord; pReturn2: pWord; pReturn3: pWord; pReturn4: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Seed';
	function UniKey__Write_SoftID(pHandle:pWord; lp1: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Write_SoftID';
	function UniKey__Read_SoftID(pHandle:pWord; pSoftID: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Read_SoftID';
	function UniKey__Set_Module(pHandle:pWord; pModule: pWord; pValue: pWord; pDecrease: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Module';
	function UniKey__Check_Module(pHandle:pWord; pModule: pWord; pValue: pWord; pDecrease: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Check_Module';
	function UniKey__Module_Decrase(pHandle:pWord; pModule: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Module_Decrase';
	function UniKey__Write_Arithmetic(pHandle:pWord; pStartAddress: pWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Write_Arithmetic';
	function UniKey__Calculate1(pHandle:pWord; pStartAddress: pLongWord; pModule: pLongWord; pRegisterA: pWord; pRegisterB: pWord; pRegisterC: pWord; pRegisterD: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Calculate1';
	function UniKey__Calculate2(pHandle:pWord; pStartAddress: pLongWord; pSeed: pLongWord; pRegisterA: pWord; pRegisterB: pWord; pRegisterC: pWord; pRegisterD: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Calculate2';
	function UniKey__Calculate3(pHandle:pWord; pStartAddress: pLongWord; pModule: pLongWord; pRegisterA: pWord; pRegisterB: pWord; pRegisterC: pWord; pRegisterD: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Calculate3';
	function UniKey__Generate_New_Password(pHandle:pWord; pSeed: pLongWord; pPassword1: pWord; pPassword2: pWord; pPassword3: pWord; pPassword4: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Generate_New_Password';
	function UniKey__Generate_Key(pHandle:pWord; lKeyNumber: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Generate_Key';
	function UniKey__Encrypt(pHandle:pWord; pBufferLength: pLongWord; pKeyNumber: pLongWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Encrypt';
	function UniKey__Decrypt(pHandle:pWord; pBufferLength: pLongWord; pKeyNumber: pLongWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Decrypt';
	function UniKey__MD5(pHandle:pWord; lp1: pLongWord; pBuffer: pByteArray):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_MD5';
	function UniKey__Write_UpdateTag(pHandle:pWord; pUpdateTag: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Write_UpdateTag';
	function UniKey__Read_UpdateTag(pHandle:pWord; pUpdateTag: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Read_UpdateTag';
	function UniKey__Set_Time(pHandle:pWord; pYear: pLongWord; pMonth: pLongWord; pDay: pWord; pHour: pWord; pMinute: pWord; pSecond: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time';
	function UniKey__Set_Time_Now(pHandle:pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Now';
	function UniKey__Get_Time(pHandle:pWord; pYear: pLongWord; pMonth: pLongWord; pDay: pWord; pHour: pWord; pMinute: pWord; pSecond: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Get_Time';
	function UniKey__Erase_Time_Module(pHandle:pWord; pModule: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Erase_Time_Module';
	function UniKey__Set_Time_Module_Start_Time(pHandle:pWord; pModule: pLongWord; pYear: pWord; pMonth: pWord; pDay: pWord; pHour: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Module_Start_Time';
	function UniKey__Set_Time_Module_Start_Time_Now(pHandle:pWord; pModule: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Module_Start_Time_Now';
	function UniKey__Set_Time_Module_Start_Time_Now_PC(pHandle:pWord; pModule: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Module_Start_Time_Now_PC';
	function UniKey__Set_Time_Module_End_Time(pHandle:pWord; pModule: pLongWord; pYear: pWord; pMonth: pWord; pDay: pWord; pHour: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Module_End_Time';
	function UniKey__Set_Time_Module_Duration(pHandle:pWord; pModule: pLongWord; pDay: pLongWord; pHour: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Set_Time_Module_Duration';
	function UniKey__Check_Time_Module(pHandle:pWord; pModule: pLongWord; pRemainDays: pLongWord; pYear: pWord; pMonth: pWord; pDay: pWord; pHour: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Check_Time_Module';
	function UniKey__Check_Time_Module_Now(pHandle:pWord; pModule: pLongWord;pRemainDays: pLongWord; pRemainHours: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Check_Time_Module_Now';
	function UniKey__Check_Time_Module_Now_PC(pHandle:pWord; pModule: pLongWord;pRemainDays: pLongWord; pRemainHours: pWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Check_Time_Module_Now_PC';
	function UniKey__Get_Version(pHandle:pWord; pVersion: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Get_Version';
	function UniKey__Get_Dongle_Location(pHandle:pWord; pDongleLocation: pLongWord):DWORD;stdcall;
	external 'UniKey.so' name 'UniKey_Get_Dongle_Location';


implementation

end.

