<?php
	//echo (confirm_UniKey_compiled("SKTBJ") . "<br><br>");

	UniKeySample();

function UniKeySample()
{
	$handle = array(16);

	//get version
	$output = UniKey_Get_Version($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Version error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey lib ver: " . $output['version'] . "<br><br>");

	$output = UniKey_Find($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Find Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("handle = " . $output['handle'] . ", hid = " . $output['hid'] . ", donglenum = " . $output['donglenum'] . "<br><br>");
	
	$handle[0] = $output['handle'];

	$p1 = 1234;
	$p2 = 1234;
	$output = UniKey_User_Logon($handle[0], $p1, $p2);
	if ($output['retcode'] != 0) {
		echo ("UniKey_User_Logon Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_User_Logon Successful!<br>");

	$p1 = 1234;
	$p2 = 1234;
	$p3 = 1234;
	$p4 = 1234;
	$output = UniKey_Vendor_Logon($handle[0], $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Vendor_Logon Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Vendor_Logon Successful!<br><br>");

	$output = UniKey_Get_Type($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Type Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	switch ($output['type']) {
	case 101:
		echo ("UniKey_Get_Type: UniKey_Type_Time!<br><br>");
		break;
	case 102:
		echo ("UniKey_Get_Type: UniKey_Type_Pro!<br><br>");
		break;
	case 103:
		echo ("UniKey_Get_Type: UniKey_Type_Std!<br><br>");
		break;
	default:
		echo ("UniKey_Get_Type: UniKey_Type_Error!<br><br>");
	}
	$dongle_type = $output['type'];

	$i = 0;
	while ($output['retcode'] === 0) {
		$output = UniKey_Find_Next($handle[$i]);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Find_Next error code: " . $output['retcode'] . "<br><br>");
			break;
		}
		echo ("UniKey_Find Successful! Handle = " . $output['handle'] . ", HID = " 
			. $output['hid'] . "<br>");
		$i++;
		$handle[$i] = $output['retcode'];

		$p1 = 1234;
		$p2 = 1234;
		$p3 = 1234;
		$p4 = 1234;
		$output = UniKey_Vendor_Logon($handle[$i], $p1, $p2, $p3, $p4);
		if ($output['retcode'] != 0) {
			echo ("UniKey_Vendor_Logon Failed! Error code: " . $output['retcode'] . "<br>");
			break;
		}
		echo ("UniKey_Vendor_Logon Successful!<br>");
	}

	$p1         = 0;   //start
	$p2         = 15;  //length
	$byte_array = 'ABCDEFGHIJKLMNO';
	$output     = UniKey_Write_Memory($handle[0], $p1, $p2, $byte_array);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_Memory Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Write_Memory Successful!<br>");

	$p1     = 2;	//start
	$p2     = 13;	//length
	$output = UniKey_Read_Memory($handle[0], $p1, $p2);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_Memory Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Read_Memory Successful! Result: ");
	for ($i = 0; $i < $p2; $i++) {
		echo ($output['buffer'][$i]);
	}
	echo ("<br><br>");


	$output = UniKey_Random($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Random Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Random Successful! Result: <br>");
	echo ("Random 1 = " . $output['random1'] . "<br>");
	echo ("Random 2 = " . $output['random2'] . "<br>");
	echo ("Random 3 = " . $output['random3'] . "<br>");
	echo ("Random 4 = " . $output['random4'] . "<br><br>");

	// seed function, you can use either hex or dec
	$lp1    = 1234;  // Seed value
	$output = UniKey_Seed($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Seed Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Seed Successful! Result: <br>");
	echo ("Random 1: " . $output['random1'] . "<br>");
	echo ("Random 2: " . $output['random2'] . "<br>");
	echo ("Random 3: " . $output['random3'] . "<br>");
	echo ("Random 4: " . $output['random4'] . "<br><br>");

	// write SoftID
	$lp1    = 12345678;
	$output = UniKey_Write_SoftID($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_SoftID Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Write_SoftID Successful<br>");

	// read SoftID
	$output = UniKey_Read_SoftID($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_SoftID Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Read_SoftID Successful! SoftID = " . $output['SID'] . "<br><br>");


	// set license module
	$p1     = 7;  // license number
	$p2     = 10; // amount
	$p3     = 1;  // decrement allowed = 1, not allowed =0
	$output = UniKey_Set_Module($handle[0], $p1, $p2, $p3);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Module Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Module module = " . $p1 . ", Decrease allowed<br>");

	// check license module
	$p1     = 7;  // license module
	$output = UniKey_Check_Module($handle[0], $p1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Check_Module error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Check_Module Successful! module = " . $p1 . ", Result: ");
	if ($output['valid'] === 1) {
		echo ("Valid and ");
	} else {
		echo ("Not valid and ");
	}
	if ($output['decrement'] === 1) {
		echo ("can be decreased<br>");
	} else {
		echo ("can not be decreased<br>");
	}

	// Decrease License Module
	$p1     = 7;
	$output = UniKey_Module_Decrease($handle[0], $p1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Module_Decrease Failed!error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Module_Decrease Successful! module = " . $p1 . "<br>");

	// get license module
	$p1 = 7;
	$output = UniKey_Get_Module($handle[0], $p1);
	if ($output['retcode'] != 0) {
		echo("UniKey_Get_Module Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Get_Module Successful! module = " . $p1 . ", value = " . $output['valid'] . "<br><br>");

	// write user-defined algorithm
	$p1        = 0;//starting point
	$algorithm = 'A=A+B,C=C+D,D=A+C';//algorithm, length calculated automatically
	$output    = UniKey_Write_Arithmetic($handle[0], $p1, $algorithm);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Write_Arithmetic error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write Arithmetic 1 successful: " . $algorithm . "<br>");

	// calculation 1
	$lp1    = 0;
	$lp2    = 0;
	$p1     = 1;
	$p2     = 2;
	$p3     = 3;
	$p4     = 4;
	$output = UniKey_Calculate1($handle[0], $lp1, $lp2, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Calculate1 error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Calculate 1 Input: p1=1, p2=2, p3=3, p4=4<br>");
	echo ("Expected result = 1+2, 2, 3+4, 4<br>");
	echo ("Calculate 1 Output: ");
	echo ("p1=" . $output['regA'] . " p2=" . $output['regB'] . " p3=" . $output['regC'] . " p4=" . $output['regD'] . "<br>");

	// calculation 2
	$lp1    = 0;
	$lp2    = 0;
	$p1     = 1;
	$p2     = 2;
	$p3     = 3;
	$p4     = 4;
	$output = UniKey_Calculate2($handle[0], $lp1, $lp2, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Calculate2 error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Calculate 2 Input: p1=1, p2=2, p3=3, p4=4<br>");
	echo ("Expected result = 1+2, 2, 3+4, 4<br>");
	echo ("Calculate 2 Output: ");
	echo ("p1=" . $output['regA'] . " p2=" . $output['regB'] . " p3=" . $output['regC'] . " p4=" . $output['regD'] . "<br>");

	// calculation 3
	$lp1    = 0;
	$lp2    = 0;
	$p1     = 1;
	$p2     = 2;
	$p3     = 3;
	$p4     = 4;
	$output = UniKey_Calculate3($handle[0], $lp1, $lp2, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Calculate3 error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Calculate 3 Input: p1=1, p2=2, p3=3, p4=4<br>");
	echo ("Expected result = 1+2, 2, 3+4, 4<br>");
	echo ("Calculate 3 Output: ");
	echo ("p1=" . $output['regA'] . " p2=" . $output['regB'] . " p3=" . $output['regC'] . " p4=" . $output['regD'] . "<br><br>");

	//------------------------------------
	// Generate new password
	// If you really want to change password, please de-comment these codes
	// Please remember the generated passwords. One UniKey can only generate new passwords twice
	// Conctact support@esecutech.com or assistance.
	/*$lp1=65534;	//password seed
	echo ("Generate new passwords with seed: " . $lp1 . "<br>");
	$output = UniKey_Generate_New_Password($handle[0],$lp1) ; 
	if ($output['retcode'] != 0) {
		echo ("New password error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Generated new passwords successfully<br>");
	echo ("Password 1: " . $output['pw1'] . ", ");
	echo ("Password 2: " . $output['pw2'] . ", ");
	echo ("Password 3: " . $output['pw3'] . ", ");
	echo ("Password 4: " . $output['pw4'] . "<br>");

	$p1     = $output['pw1'];
	$p2     = $output['pw2'];
	$p3     = $output['pw3'];
	$p4     = $output['pw4'];
	$output = UniKey_Vendor_Logon($handle[0], $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Vendor_Logon error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Successfully logged in as Admin<br><br>");*/


	//------------------------------
	// generate key via seed 
	echo ("Generate new encryption key via seed for Key 1<br>");
	$lp1    = 1;//key container, 1~3
	$p1     = 1111;//seed 1
	$p2     = 2222;//seed 2
	$p3     = 3333;//seed 3
	$p4     = 4444;//seed 4
	$output = UniKey_Generate_Key_Via_Seed($handle[0], $lp1, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Generate_Key_Via_Seed error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Generate_Key_Via_Seed Result：" . $output['seed1'] . ", "
		. $output['seed2'] . ", " . $output['seed3'] . ", " . $output['seed4'] . "<br>");

	// generate key via random
	echo ("Generate new encryption key for Key 1 by random<br>");
	$lp1    = 1;
	$output = UniKey_Generate_Key($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Generate key successful<br><br>");

	$lp1 = 16;
	$lp2 = 1;
	$output = UniKey_Encrypt($handle[0], $lp1, $lp2, 'testingencrypt12');
	if ($output['retcode'] != 0) {
		echo ("UniKey_Encrypt Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Encrypt Successful! Result: " . $output['buffer'] . "<br>");

	$lp1 = 16;
	$lp2 = 1;
	$output = UniKey_Decrypt($handle[0], $lp1, $lp2, $output['buffer']);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Decrypt Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Decrypt Successful! Result: " . $output['buffer'] . "<br><br>");

	// MD5
	$lp1        = 16; //length
	$output     = UniKey_MD5($handle[0], $lp1, 'testingencryptor');
	if ($output['retcode'] != 0) {
		echo ("UniKey MD5 error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("MD5 generated, result: " . $output['MD5'] . "<br><br>");

	// write UpdateTag
	$lp1    = 45516;
	$output = UniKey_Write_UpdateTag($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Write UpdateTag successful<br>");

	// read UpdateTag
	$output = UniKey_Read_UpdateTag($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Read_UpdateTag error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Read UpdateTag: " . $output['Uptag'] . "<br><br>");

	/*$lp1 = 7;
	$output = UniKey_Set_Max_Num($handle[0], $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Max_Num error code: " . $output['retcode'] . "<br>");
		return;
	}	
	echo ("UniKey_Set_Max_Num successfully<br>");*/

	/*$output = UniKey_Get_Max_Num($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Max_Num error code: " . $output['retcode'] . "<br>");
		return;
	}	
	echo ("UniKey_Get_Max_Num successfully! Client Number = " . $output['cnt']. "<br><br>");*/

	if ($dongle_type == 101)
	{
		UniKeyTimeSample($handle[0]);
	}	

	$output = UniKey_Logoff($handle[0]);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Logoff Failed! Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Logoff Successful!<br><br>");
}


function UniKeyTimeSample($handle){
	echo("Start UniKey Time sample<br>");

	$output = UniKey_Get_Time($handle);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Time error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("Get Time: ");
	echo ($output['day'] . "/" . $output['month'] . "/" . ($output['year'] + 2000) . " ");
	echo ($output['hour'] . ":" . $output['minute'] . ":" . $output['second'] . "<br>");


	$lp1 = 16;
	$lp2 = 5;
	$p1 = 16;
	$p2 = 15;
	$p3 = 30;
	$p4 = 22;
	$output = UniKey_Set_Time($handle, $lp1, $lp2, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time Successful!<br>");
	
	$output = UniKey_Set_Time_Now($handle);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Now error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time_Now Successful!<br>");


	$lp1 = 1;
	$output = UniKey_Erase_Time_Module($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo("UniKey_Erase_Time_Module error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Erase_Time_Module successful<br>");
	
	$lp1 = 1;
	$p1 = 16;
	$p2 = 5;
	$p3 = 16;
	$p4 = 15;
	$output = UniKey_Set_Time_Module_Start_Time($handle, $lp1, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Module_Start_Time error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time_Module_Start_Time successful<br>");

	/*$lp1 = 1;
	$output = UniKey_Set_Time_Module_Start_Time_Now($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Module_Start_Time_Now error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time_Module_Start_Time_Now " . $lp1 . ", successful<br>");*/

	/*$lp1 = 1;
	$output = UniKey_Set_Time_Module_Start_Time_Now_PC($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Module_Start_Time_Now_PC error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time_Module_Start_Time_Now_PC " . $lp1 . ", successful<br>");*/

	$lp1=1;
	$lp2 = 10; // duration is 10 Day
	$p1  = 6; // and 6 hour
	$output = UniKey_Set_Time_Module_Duration($handle, $lp1, $lp2, $p1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Module_Duration error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo("UniKey_Set_Time_Module_Duration Successful!<br>");

	$lp1 = 1;
	$p1 = 17;
	$p2 = 5;
	$p3 = 16;
	$p4 = 15;
	$output = UniKey_Set_Time_Module_End_Time($handle, $lp1, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Set_Time_Module_End_Time error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Set_Time_Module_End_Time successful<br>");

	$lp1 = 1;
	$p1 = 17;
	$p2 = 3;
	$p3 = 16;
	$p4 = 15;
	$output = UniKey_Check_Time_Module($handle, $lp1, $p1, $p2, $p3, $p4);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Check_Time_Module error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo ("UniKey_Check_Time_Module successful! ");
	echo ("Days left: " . $output['daysleft'] . "<br>");

	$lp1=1;
	$output = UniKey_Check_Time_Module_Now($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Check_Time_Module_Now, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo("UniKey_Check_Time_Module_Now Mudule:  Successful! ");
	echo("Days left: " . $output['daysleft'] . " hours left: " . $output['hoursleft'] . "<br>");

	$lp1=1;
	$output = UniKey_Check_Time_Module_Now_PC($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Check_Time_Module_Now_PC, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo("UniKey_Check_Time_Module_Now_PC Mudule: " . $lp1 . " Successful<br>");
	echo("Days left: " . $output['daysleft'] . " hours left: " . $output['hoursleft'] . "<br>");
		
	$lp1=1;
	$output = UniKey_Get_Module_Start_Time($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Module_Start_Time, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo("UniKey_Get_Module_Start_Time Mudule: " . $lp1 . " Successful<br>");
	echo("Year: " . $output['year'] . " Month: " . $output['month'] . " Day: " . $output['day'] . " hour: " . $output['hour'] . "<br>");
		
	$output = UniKey_Get_Module_End_Time($handle, $lp1);
	if ($output['retcode'] != 0) {
		echo ("UniKey_Get_Module_End_Time, Mudule: " . $lp1 . "  Error code: " . $output['retcode'] . "<br>");
		return;
	}
	echo("UniKey_Get_Module_End_Time Mudule: " . $lp1 . " Successful<br>");
	echo("Year: " . $output['year'] . " Month: " . $output['month'] . " Day: " . $output['day'] . " hour: " . $output['hour'] . "<br>");
		
	echo("End UniKey Time sample<br><br>");	
}

?>
