#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "UniKey.h"

#define MemorySize  4096

void UniKeySample();
void UniKeyTimeSample(WORD handle);

int main()
{
	UniKeySample();

	system("pause");
	return 0;
}

void UniKeySample()
{
	DWORD lp1 = 0, lp2 = 0;
	WORD handle[16] = {0}, p1 = 0, p2 = 0, p3 = 0, p4 = 0;
	BYTE buffer[MemorySize] = {0};

	long retcode = UniKey_Get_Version(&handle[0], &lp1);
	if (SUCCESS != retcode) {
		printf("UniKey_Get_Version Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Get_Version: LibVersion = %u\n", lp1);
	}

	lp1 = lp2 = 0;
	retcode = UniKey_Find(&handle[0], &lp1, &lp2);
	if (SUCCESS != retcode) {
		printf("UniKey_Find Failed! Error code: %ld\n", retcode);
		return;
	}
	else {
		printf("UniKey_Find: handle[0] = %d, hid = 0X%08X, donglenum = %d\n", handle[0], lp1, lp2);
	}
	return;

	/*p1 = 50117;
	p2 = 6521;*/
	p1 = p2 = 1234;
	retcode = UniKey_User_Logon(&handle[0], &p1, &p2);
	if (SUCCESS != retcode) {
		printf("UniKey_User_Logon Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_User_Logon Successful!\n");
	}

	p1 = 50117;
	p2 = 6521;
	p3 = 63545;
	p4 = 26304;
	p1 = p2 = p3 = p4 = 1234;
	retcode = UniKey_Vendor_Logon(&handle[0], &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Vendor_Logon Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Vendor_Logon Successful!\n");
	}

	int donglenum = 1;
	while (1) {
		retcode = UniKey_Find_Next(&handle[donglenum], &lp1, &lp2);
		if (SUCCESS != retcode) {
			printf("UniKey_Find_Next Failed! Error code: %ld\n", retcode);
			break;
		}
		else {
			printf("UniKey_Find_Next: handle[%d] = %d, hid = %d, donglenum = %d\n", donglenum, handle[donglenum], lp1, lp2);
		}
		p1 = 1234;
		p2 = 1234;
		retcode = UniKey_User_Logon(&handle[donglenum], &p1, &p2);
		if (SUCCESS != retcode) {
			printf("UniKey_User_Logon Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_User_Logon Successful!\n");
		}

		p1 = 1234;
		p2 = 1234;
		p3 = 1234;
		p4 = 1234;
		retcode = UniKey_Vendor_Logon(&handle[donglenum], &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Vendor_Logon Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Vendor_Logon Successful!\n");
		}

		donglenum++;
	}

	int i = 0;
	for (i = 0; i < donglenum; i++) {
		retcode = UniKey_Get_Type(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Get_Type Failed! Error code: %ld\n", retcode);
		}
		else {
			switch (lp1) {
			case UNIKEY_TYPE_STD:
				printf("UniKey_Get_Type: dongle type = STD\n");
				break;
			case UNIKEY_TYPE_PRO:
				printf("UniKey_Get_Type: dongle type = Pro\n");
				break;
			case UNIKEY_TYPE_TIME:
				printf("UniKey_Get_Type: dongle type = Time\n");
				UniKeyTimeSample(handle[i]);
				break;
			default:
				break;
			}
		}

		p1 = 5;
		p2 = 10;
		memset(buffer, 0, MemorySize);
		strcpy((char *)buffer, "helloworld");
		retcode = UniKey_Write_Memory(&handle[i], &p1, &p2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Write_Memory Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Write_Memory: StartAddr = %d, Length = %d, Data = %s\n", p1, p2, buffer);
		}

		p1 = 0;
		p2 = 13;
		memset(buffer, 0, MemorySize);
		retcode = UniKey_Read_Memory(&handle[i], &p1, &p2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Read_Memory Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Read_Memory: StartAddr = %d, Length = %d, Data = %s\n", p1, p2, buffer);
		}

		retcode = UniKey_Random(&handle[i], &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Random Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Random: %d, %d, %d, %d\n", p1, p2, p3, p4);
		}

		lp1 = 147;
		retcode = UniKey_Seed(&handle[i], &lp1, &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Seed Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Seed: Seed = %d, Return = %d, %d, %d, %d\n", lp1, p1, p2, p3, p4);
		}

		lp1 = 531;
		retcode = UniKey_Write_SoftID(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Write_SoftID Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Write_SoftID: softid = %d\n", lp1);
		}

		retcode = UniKey_Read_SoftID(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Read_SoftID Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Read_SoftID: softid = %d\n", lp1);
		}

		p1 = 3;
		p2 = 25;
		p3 = 1;
		retcode = UniKey_Set_Module(&handle[i], &p1, &p2, &p3);
		if (SUCCESS != retcode) {
			printf("UniKey_Set_Module Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Set_Module: Moudule = %d, Value = %d, Decrease = %d\n", p1, p2, p3);
		}

		retcode = UniKey_Check_Module(&handle[i], &p1, &p2, &p3);
		if (SUCCESS != retcode) {
			printf("UniKey_Check_Module Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Check_Module: Module = %d, Value = %s, Decrease = %s\n",
				p1, p2 ? "Allow" : "No Allow", p3 ? "Allow Decrease" : "Not Allow Decrease");
		}

		retcode = UniKey_Get_Module(&handle[i], &p1, &p2);
		if (SUCCESS != retcode) {
			printf("UniKey_Get_Module Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Get_Module: Module = %d, Value = %d\n", p1, p2);
		}

		retcode = UniKey_Module_Decrease(&handle[i], &p1);
		if (SUCCESS != retcode) {
			printf("UniKey_Module_Decrease Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Module_Decrease Successful!\n");

			retcode = UniKey_Get_Module(&handle[i], &p1, &p2);
			if (SUCCESS != retcode) {
				printf("UniKey_Get_Module Failed! Error code: %ld\n", retcode);
			}
			else {
				printf("UniKey_Get_Module: Module = %d, Value = %d\n", p1, p2);
			}
		}

		char cmd[] = "A=E|E, B=F|F, C=G|G, D=H|H";
		memset(buffer, 0, MemorySize);
		strcpy((char *)buffer, cmd);
		p1 = 0;
		retcode = UniKey_Write_Arithmetic(&handle[i], &p1, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Write_Arithmetic Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Write_Arithmetic: arithmetic = %s\n", buffer);
		}

		lp1 = 0;
		lp2 = 3;
		p1 = 1;
		p2 = 2;
		p3 = 3;
		p4 = 4;
		retcode = UniKey_Calculate1(&handle[i], &lp1, &lp2, &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Calculate1 Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Calculate1: StartAddr = %d, Module = %d, Return = 0X%04X, 0X%04X, %d, %d\n", lp1, lp2, p1, p2, p3, p4);
		}

		lp1 = 0;
		lp2 = 147;
		p1 = 1;
		p2 = 2;
		p3 = 3;
		p4 = 4;
		retcode = UniKey_Calculate2(&handle[i], &lp1, &lp2, &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Calculate2 Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Calculate2: StartAddr = %d, Module = %d, Return = %d, %d, %d, %d\n", lp1, lp2, p1, p2, p3, p4);
		}

		lp1 = 0;
		lp2 = 3;
		p1 = 1;
		p2 = 2;
		p3 = 3;
		p4 = 4;
		retcode = UniKey_Calculate3(&handle[i], &lp1, &lp2, &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Calculate3 Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Calculate3: StartAddr = %d, Module = %d, Return = %d, %d, %d, %d\n", lp1, lp2, p1, p2, p3, p4);
		}

		lp1 = 1;
		retcode = UniKey_Generate_Key(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Generate_Key Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Generate_Key: KeyNumber = %d Successful!\n", lp1);
		}

		strcpy((char *)buffer, "abcdefghijklmnop");
		lp1 = (DWORD)strlen((char *)buffer);
		lp2 = 1;
		retcode = UniKey_Encrypt(&handle[i], &lp1, &lp2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Encrypt Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Encrypt: result = %s\n", buffer);
		}

		retcode = UniKey_Decrypt(&handle[i], &lp1, &lp2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Decrypt Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Decrypt: result = %s\n", buffer);
		}

		lp1 = 1;
		p1 = 1001;
		p2 = 1002;
		p3 = 1003;
		p4 = 1004;
		retcode = UniKey_Generate_Key_Via_Seed(&handle[i], &lp1, &p1, &p2, &p3, &p4);
		if (SUCCESS != retcode) {
			printf("UniKey_Generate_Key_Via_Seed Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Generate_Key_Via_Seed: KeyNumber = %d, Result = %d, %d, %d, %d\n", lp1, p1, p2, p3, p4);
		}

		strcpy((char *)buffer, "abcdefghijklmnop");
		lp1 = (DWORD)strlen((char *)buffer);
		lp2 = 1;
		retcode = UniKey_Encrypt(&handle[i], &lp1, &lp2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Encrypt Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Encrypt: result = %s\n", buffer);
		}

		retcode = UniKey_Decrypt(&handle[i], &lp1, &lp2, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_Decrypt Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Decrypt: result = %s\n", buffer);
		}

		strcpy((char *)buffer, "abcdefghijklmnop");
		lp1 = (DWORD)strlen((char *)buffer);
		retcode = UniKey_MD5(&handle[i], &lp1, buffer);
		if (SUCCESS != retcode) {
			printf("UniKey_MD5 Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_MD5: result = %s\n", buffer);
		}

		lp1 = 123456;
		retcode = UniKey_Write_UpdateTag(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Write_UpdateTag Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Write_UpdateTag: UpdateTag = %d\n", lp1);
		}

		retcode = UniKey_Read_UpdateTag(&handle[i], &lp1);
		if (SUCCESS != retcode) {
			printf("UniKey_Read_UpdateTag Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Read_UpdateTag: UpdateTag = %d\n", lp1);
		}

		p1 = 23;
		retcode = UniKey_Set_Max_Num(&handle[i], &p1);
		if (SUCCESS != retcode) {
			printf("UniKey_Set_Max_Num Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Set_Max_Num: %d\n", p1);
		}

		retcode = UniKey_Get_Max_Num(&handle[i], &p1);
		if (SUCCESS != retcode) {
			printf("UniKey_Get_Max_Num Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Get_Max_Num: %d\n", p1);
		}


		retcode = UniKey_Logoff(&handle[i]);
		if (SUCCESS != retcode) {
			printf("UniKey_Logoff Failed! Error code: %ld\n", retcode);
		}
		else {
			printf("UniKey_Logoff Successful!\n");
		}
	}
}


void UniKeyTimeSample(WORD handle)
{
	DWORD lp1, lp2;
	WORD p1, p2, p3, p4;

	printf("\n==================================\n");

	lp1 = 19;
	lp2 = 6;
	p1 = 2;
	p2 = 9;
	p3 = 12;
	p4 = 15;
	long retcode = UniKey_Set_Time(&handle, &lp1, &lp2, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time: Date = 20%02d-%02d-%02d, Time = %02d:%02d:%02d\n", lp1, lp2, p1, p2, p3, p4);
	}

	retcode = UniKey_Get_Time(&handle, &lp1, &lp2, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Get_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Get_Time: 20%02d-%02d-%02d %02d:%02d:%02d\n", lp1, lp2, p1, p2, p3, p4);
	}

	retcode = UniKey_Set_Time_Now(&handle);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Now Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Now Successful!\n");
	}

	retcode = UniKey_Get_Time(&handle, &lp1, &lp2, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Get_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Get_Time: 20%02d-%02d-%02d %02d:%02d:%02d\n", lp1, lp2, p1, p2, p3, p4);
	}

	lp1 = 0;
	retcode = UniKey_Erase_Time_Module(&handle, &lp1);
	if (SUCCESS != retcode) {
		printf("UniKey_Erase_Time_Module Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Erase_Time_Module: Module = %d\n", lp1);
	}

	p1 = 17;
	p2 = 5;
	p3 = 1;
	p4 = 12;
	retcode = UniKey_Set_Time_Module_Start_Time(&handle, &lp1, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Module_Start_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Module_Start_Time: Module = %d, 20%02d-%02d-%02d %02dH\n", lp1, p1, p2, p3, p4);
	}

	p1 = 19;
	p2 = 5;
	p3 = 1;
	p4 = 12;
	retcode = UniKey_Set_Time_Module_End_Time(&handle, &lp1, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Module_End_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Module_End_Time: Module = %d, 20%02d-%02d-%02d %02dH\n", lp1, p1, p2, p3, p4);
	}

	retcode = UniKey_Get_Module_Start_Time(&handle, &lp1, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Get_Module_Start_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Get_Module_Start_Time: Module = %d, 20%02d-%02d-%02d %02dH\n", lp1, p1, p2, p3, p4);
	}

	retcode = UniKey_Get_Module_End_Time(&handle, &lp1, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Get_Module_End_Time Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Get_Module_End_Time: Module = %d, 20%02d-%02d-%02d %02dH\n", lp1, p1, p2, p3, p4);
	}

	p1 = 19;
	p2 = 4;
	p3 = 30;
	p4 = 12;
	retcode = UniKey_Check_Time_Module(&handle, &lp1, &lp2, &p1, &p2, &p3, &p4);
	if (SUCCESS != retcode) {
		printf("UniKey_Check_Time_Module Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Check_Time_Module: Module = %d, RemainDays = %d, 20%02d-%02d-%02d %02dH\n", lp1, lp2, p1, p2, p3, p4);
	}

	retcode = UniKey_Set_Time_Module_Start_Time_Now(&handle, &lp1);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Module_Start_Time_Now Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Module_Start_Time_Now Successful!\n");
	}

	retcode = UniKey_Check_Time_Module_Now(&handle, &lp1, &lp2, &p1);
	if (SUCCESS != retcode) {
		printf("UniKey_Check_Time_Module_Now Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Check_Time_Module_Now: Module = %d, RemainDays = %d, RemainHours = %d\n", lp1, lp2, p1);
	}

	retcode = UniKey_Set_Time_Module_Start_Time_Now_PC(&handle, &lp1);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Module_Start_Time_Now_PC Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Module_Start_Time_Now_PC Successful!\n");
	}

	retcode = UniKey_Check_Time_Module_Now_PC(&handle, &lp1, &lp2, &p1);
	if (SUCCESS != retcode) {
		printf("UniKey_Check_Time_Module_Now_PC Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Check_Time_Module_Now_PC: Module = %d, RemainDays = %d, RemainHours = %d\n", lp1, lp2, p1);
	}

	lp2 = 1;
	p1 = 37;
	retcode = UniKey_Set_Time_Module_Duration(&handle, &lp1, &lp2, &p1);
	if (SUCCESS != retcode) {
		printf("UniKey_Set_Time_Module_Duration Failed! Error code: %ld\n", retcode);
	}
	else {
		printf("UniKey_Set_Time_Module_Duration: Year = %d, Day = %d\n", lp2, p1);
	}

	printf("==================================\n\n");
}


