package UniKeyDrive;

public class UniKeyDriveObj
{
	public static void main(String[] args)
	{

	}

	public UniKeyDriveObj()
	{
		System.loadLibrary("UniKeyDriveObj"); //对应的DLL
	}

	/*UniKey and UniKey Drive Functions*/
	public native int UniKey_Find(int[] pHandle, long[] pSetting1, long[] pSetting2);
	public native int UniKey_Find_Next(int[] pHandle, long[] pSetting1, long[] pSetting2);

	public native int UniKey_Lock(int[] pHandle);
	public native int UniKey_UnLock(int[] pHandle);

	public native int UniKey_User_Logon(int[] pHandle, long[] pPassword1, long[] pPassword2);
	public native int UniKey_Vender_Logon(int[] pHandle, long[] pPassword1, long[] pPassword2, long[] pPassword3, long[] pPassword4);
	
	public native int UniKey_Read_Memory(int[] pHandle, int[] pStartAddress, int[] pBufferLength, byte[] pBuffer);
	public native int UniKey_Write_Memory(int[] pHandle, int[] pStartAddress, int[] pBufferLength, byte[] pBuffer);
	
	public native int UniKey_Random(int[] pHandle, int[] pRandom1, int[] pRandom2, int[] pRandom3, int[] pRandom4);
	public native int UniKey_Seed(int[] pHandle, long[] pSeed, int[] pReturn1, int[] pReturn2, int[] pReturn3, int[] pReturn4);

	public native int UniKey_Write_SoftID(int[] pHandle, long[] pSoftID);
	public native int UniKey_Read_SoftID(int[] pHandle, long[] pSoftID);
	
	public native int UniKey_Set_Module(int[] pHandle, int[] pModule, int[] pValue, int[] pDecrease);
	public native int UniKey_Get_Module(int[] pHandle, int[] pModule, int[] pValue);
	public native int UniKey_Check_Module(int[] pHandle, int[] pModule, int[] pValue, int[] pDecrease);
	public native int UniKey_Module_Decrase(int[] pHandle, int[] pModule);
	
	public native int UniKey_Write_Arithmetic(int[] pHandle, int[] pStartAddress, byte[] pBuffer);
	public native int UniKey_Calculate1(int[] pHandle, long[] pStartAddress, long[] pModule, int[] pRegisterA, int[] pRegisterB, int[] pRegisterC, int[] pRegisterD);//start, seed, register
	public native int UniKey_Calculate2(int[] pHandle, long[] pStartAddress, long[] pSeed, int[] pRegisterA, int[] pRegisterB, int[] pRegisterC, int[] pRegisterD);
	public native int UniKey_Calculate3(int[] pHandle, long[] pStartAddress, long[] pModule, int[] pRegisterA, int[] pRegisterB, int[] pRegisterC, int[] pRegisterD);

	public native int UniKey_Generate_New_Password(int[] pHandle, long[] pSeed1, long[] pPassword1, long[] pPassword2, long[] pPassword3, long[] pPassword4);
	public native int UniKey_Generate_Key(int[] pHandle, long[] pKeyNumber);
	public native int UniKey_Generate_Key_Via_Seed(int[] pHandle, long[] pSeed, int[] pPassword1, int[] pPassword2, int[] pPassword3, int[] pPassword4);

	public native int UniKey_Encrypt(int[] pHandle, long[] pBufferLength, long[] pKeyNumber, byte[] pBuffer);
	public native int UniKey_Decrypt(int[] pHandle, long[] pBufferLength, long[] pKeyNumber, byte[] pBuffer);
	public native int UniKey_MD5(int[] pHandle, long[] pBufferLength, byte[] pBuffer);
	
	public native int UniKey_Write_UpdateTag(int[] pHandle, long[] pUpdateTag);
	public native int UniKey_Read_UpdateTag(int[] pHandle, long[] pUpdateTag);
	
	public native int UniKey_Get_Version(int[] pHandle, long[] pVersion);
	public native int UniKey_Get_FirmwareVersion(int[] pHandle,byte[] pFirmwareVersion);
	
	public native int UniKey_Write_CD_ROM(int[] pHandle, long pAddress, byte[] Data);
	public native int UniKey_Set_Com_Size(int[] pHandle, int CommonPercent,int EncryptPercent,int HiddenSize,int CDSize);
	public native int UniKey_Secu_Change_PW_Admin(int[] pHandle,byte[] pPassword);
	
	// Network Functions
	public native int UniKey_Get_Dongle_Location(int[] pHandle, long[] pLocation);
	public native int UniKey_Get_Type(int[] pHandle, long[] pType);
	public native int UniKey_Get_Cli_Num(int[] pHandle, long[] pCount);
	public native int UniKey_Get_Max_Num(int[] pHandle, int[] pCount);
	
	// UniKey Drive Functions
	public native int UniKey_FS_Init(int[] pHandle,long[] pPassword1, long[] pPassword2, long[] pPassword3, long[] pPassword4);
	public native int UniKey_FS_Format(int[] pHandle);
	public native int UniKey_FS_CreateFile(int[] pHandle, byte[] pFileName);
	public native int UniKey_FS_DeleteFile(int[] pHandle, byte[] pFileName);
	public native int UniKey_FS_File_Open(int[] pHandle, byte[] pFileName);
	public native int UniKey_FS_Get_Free_Size(int[] pHandle, long[] pUsedSize, long[] pFreeSize);
	public native int UniKey_FS_File_Modify_Data(int[] pHandle, long[] pOffset, long[] pLength, byte[] pBuffer);
	public native int UniKey_FS_File_Append_Data(int[] pHandle, long[] pLength, byte[] pBuffer);
	public native int UniKey_FS_File_Read_Data(int[] pHandle, long[]  pOffset,long[] pLength, byte[] pBuffer);
	public native int UniKey_FS_File_Close(int[] pHandle, byte[]  pFileName);
	public native int UniKey_FS_File_Get_List(int[] pHandle, long[] pFileCount, byte[] pFileList);
	public native int UniKey_FS_File_Get_Size(int[] pHandle, long[] pFileSize);
	public native int UniKey_FS_Set_Password(int[] pHandle, long[] pPassword1, long[] pPassword2, long[] pPassword3, long[] pPassword4);
	
	public native int UniKey_RSA_Generate_Key(int[] pHandle, int[] KeyIndex);
	public native int UniKey_DES_Generate_Key(int[] pHandle, int[] KeyIndex);
	public native int UniKey_RSA_Get_Key_Counts(int[] pHandle,long[] KeyIndexs);
	public native int UniKey_DES_Get_Key_Counts(int[] pHandle,long[] KeyIndexs);
	public native int UniKey_RSA_Encrypt(int[] pHandle,int[] KeyIndex,long[] Encrypt_Len,byte[] Buffer);
	public native int UniKey_RSA_Decrypt(int[] pHandle,int[] KeyIndex,long[] Decrypt_Len,byte[] Buffer);

	public native int UniKey_DES1_Encrypt(int[] pHandle,int[] EncryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);
	public native int UniKey_DES2_Encrypt(int[] pHandle,int[] EncryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);
	public native int UniKey_DES3_Encrypt(int[] pHandle,int[] EncryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);
	public native int UniKey_DES1_Decrypt(int[] pHandle,int[] DecryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);
	public native int UniKey_DES2_Decrypt(int[] pHandle,int[] DecryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);
	public native int UniKey_DES3_Decrypt(int[] pHandle,int[] DecryptMode,int[] KeyIndex,long[] Length,byte[] Buffer);

	public native int UniKey_RSA_Del_Key(int[] pHandle,int[] KeyIndex);
	public native int UniKey_DES_Del_Key(int[] pHandle,int[] KeyIndex);

	public native int UniKey_Get_UserCount(int[] pHandle,int[] Count);
	public native int UniKey_Logon_Single(int[] pHandle, long[] pPassword1, long[] pPassword2, long[] pPassword3, long[] pPassword4);
	public native int UniKey_Logoff(int[] pHandle);
	public native int UniKey_Logoff_All(int[] pHandle);
	public native int UniKey_Get_CD(int[] pHandle, byte[] cd);
	public native int UniKey_Get_Capacity(int[] pHandle,byte[] buffer);

	public native int UniKey_RSA_Generate_KeyPair(int[] pHandle,int[] KeyIndex,int[] KeyLength,long[] E);
	public native int UniKey_RSA_Export_Public_Key(int[] pHandle,int[] KeyIndex,int[] KeyLength,byte[] PublicKeyBuffer);
	public native int UniKey_RSA_Import_Public_Key(int[] pHandle,int[] KeyIndex,int[] KeyLength,long[] E,byte[] PublicKeyBuffer);
	public native int UniKey_RSA_Sign(int[] pHandle, int[] HashAlgrithm,int[] KeyIndex,int[] DataLength,byte[] EncryptData);
	public native int UniKey_RSA_HashEncrypt(int[] pHandle,int[] HashAlgrithm,int[] DataLength,byte[] EncryptData);
	public native int UniKey_RSA_DecryptSignedValue(int[] pHandle,int[] KeyIndex,byte[] EncryptData);
	public native int UniKey_RSA_Verify(int[] pHandle,int[] KeyIndex,int[] HashAlgrithm,int[] DataLength,byte[] DataBuffer);
	public native int UniKey_RSA_Delete_KeyPair(int[] pHandle,int[] KeyIndex);

	public native int UniKey(int Function, int[] handle, long[] lp1, long[] lp2, int[] p1, int[] p2, int[] p3, int[] p4, byte[] buffer);
	

	// function keywords
	final public int UNIKEY_FIND								= 1;	// Find UniKey
	final public int UNIKEY_FIND_NEXT							= 2;   	// Find next UniKey
	final public int UNIKEY_LOGON								= 3; 	// Open UniKey
	final public int UNIKEY_LOGOFF								= 4;	// Close UniKey
	final public int UNIKEY_READ_MEMORY							= 5;	// Read UniKey
	final public int UNIKEY_WRITE_MEMORY						= 6;	// Write UniKey
	final public int UNIKEY_RANDOM		    					= 7;	// Generate Random Number
	final public int UNIKEY_SEED								= 8;	// Generate Seed Code
	final public int UNIKEY_WRITE_SOFTID						= 9;	// Write Software ID
	final public int UNIKEY_READ_SOFTID							= 10;	// Read Software ID
	final public int UNIKEY_SET_MODULE							= 11;	// Set Module
	final public int UNIKEY_CHECK_MODULE						= 12;	// Check Module
	final public int UNIKEY_WRITE_ARITHMETIC					= 13;	// Write Arithmetic
	final public int UNIKEY_CALCULATE1							= 14;	// Calculate 1
	final public int UNIKEY_CALCULATE2						    = 15;	// Calculate 2
	final public int UNIKEY_CALCULATE3							= 16;	// Calculate 3
	final public int UNIKEY_MODULE_DECRASE						= 17;	// Decrease Module Unit
	final public int UNIKEY_SET_NEW_PASSWORD					= 18;	// Set New Password via a New Seed
	final public int UNIKEY_GENERATE_KEY						= 19;	// Generate a New Key in specific Key Store
	final public int UNIKEY_ENCRYPT								= 20;	// Encrypt the Buffer with a Specific Key
	final public int UNIKEY_DECRYPT								= 21;	// Decrypt the Buffer with a Specific Key
	final public int UNIKEY_MD5				                	= 22;	// Make an MD5 Digest for a Certain Content
	final public int UNIKEY_READ_UPDATETAG	                	= 23;	// Read UpdateTag from a Specific Key
	final public int UNIKEY_WRITE_UPDATETAG	                	= 24;	// Write UpdateTag to a Specific Key
	final public int UNIKEY_GET_TIME							= 26;	// read rtc time (lp1,lp2,p1,p2,p3,p4 = year,month,day,hour,minute,second)
	final public int UNIKEY_SET_TIME							= 27;	// write rtc time (lp1,lp2,p1,p2,p3,p4 = year,month,day,hour,minute,second)
	final public int UNIKEY_SET_TIME_NOW						= 28;	// write rtc time use host time
	final public int UNIKEY_ERASE_TIME_MODULE					= 29;	// ERASE TIME MODULE to NULL,
	final public int UNIKEY_SET_TIME_MODULE_START_TIME			= 30;	// write rtc time module start time(p1,p2,p3,p4 = year,month,day,hour)
	final public int UNIKEY_SET_TIME_MODULE_START_TIME_NOW		= 31;	// write rtc time module start time use dongle time
	final public int UNIKEY_SET_TIME_MODULE_START_TIME_NOW_PC	= 32;	// write rtc time module start time use host time
	final public int UNIKEY_SET_TIME_MODULE_END_TIME			= 33;	// write rtc time module end time (p1,p2,p3,p4 = year,month,day,hour)
	final public int UNIKEY_SET_TIME_MODULE_DURATION			= 34;	// write rtc time module duration (lp2,p1 = day,hour)=24*day+hour
	final public int UNIKEY_CHECK_TIME_MODULE					= 35;	// check if a time >START_TIME and the time < END_TIME(or START_TIME+DURATION) (p1,p2,p3,p4 = year,month,day,hour)
	final public int UNIKEY_CHECK_TIME_MODULE_NOW				= 36;	// check if mow >START_TIME and now < END_TIME(or START_TIME+DURATION) use dongle time
	final public int UNIKEY_CHECK_TIME_MODULE_NOW_PC			= 37;	// check if mow >START_TIME and now < END_TIME(or START_TIME+DURATION) use host time
	final public int UNIKEY_LOCK								= 41;	// Lock a dongle
	final public int UNIKEY_UNLOCK								= 42;	// Lock a dongle
	final public int UNIKEY_LOGON_SINGLE						= 44;

	/*Encryption Modes*/
	final public int ECB_MODE									= 1;
	final public int CBC_MODE									= 2;
	final public int RSA_KEY_LEN								= 1408;
	final public int DES_KEY_LEN								= 24;
	final public int DES1										= 1;
	final public int DES2										= 2;
	final public int DES3										= 3;
	final public int RSA										= 4;
	final public int RSA_KEY									= 1;
	final public int DES_KEY									= 2;
	final public int RSA_KEY_1024								= 3;
	final public int RSA_KEY_2048								= 4;
	final public int SHA256HashValueLength						= 32;
	final public int RSA_PublickKey_Length						= 514;
	final public int MD5										= 0;
	final public int SHA1										= 1;
	final public int SHA224										= 2;
	final public int SHA256										= 3;
	final public int SHA384										= 4;
	final public int SHA512										= 5;

// Error Codes
	final public int SUCCESS									= 0;	//Success
	final public int ERROR_UNIKEY_NOT_FOUND						= 200;	//No UniKey Dongle
	final public int ERROR_UNIKEY_INVALID_PASSWORD				= 201;	//Found UniKey Dongle, But Basic Password Is Wrong
	final public int ERROR_UNIKEY_INVALID_PASSWORD_OR_ID		= 202;	//Wrong Password Or UniKey HID
	final public int ERROR_UNIKEY_SET_SOFTID_FAILED				= 203;	//Set UniKey ID Failed
	final public int ERROR_UNIKEY_INVALID_ADDR_OR_SIZE			= 204;	//Read/Write Address Or Length Is Wrong
	final public int ERROR_UNIKEY_UNKNOWN_COMMAND				= 205;	//No Such Command
	final public int ERROR_UNIKEY_READ_MEMORY					= 207;	//Read Memory Failed
	final public int ERROR_UNIKEY_WRITE_MEMORY					= 208;	//Write Memory Failed
	final public int ERROR_UNIKEY_RANDOM						= 209;	//Random Number Failed
	final public int ERROR_UNIKEY_SEED							= 210;	//Get Seed Code Failed
	final public int ERROR_UNIKEY_CALCULATE						= 211;	//Calculate Failed
	final public int ERROR_UNIKEY_NEED_OPEN						= 212;	//Need Open Dongle Before Operating Dongle
	final public int ERROR_UNIKEY_OPEN_OVERFLOW					= 213;	//Too Many Open Dongles (>16)
	final public int ERROR_UNIKEY_NOMORE						= 214;	//No More Dongle
	final public int ERROR_UNIKEY_NEED_FIND						= 215;	//No Find Before FindNext
	final public int ERROR_UNIKEY_MODULE						= 216;	//License Module Error
	final public int ERROR_UNIKEY_AR_BAD_COMMAND				= 217;	//Arithmetic Instruction Error
	final public int ERROR_UNIKEY_AR_UNKNOWN_OPCODE				= 218;	//Arithmetic Operator Error
	final public int ERROR_UNIKEY_AR_WRON_GBEGIN				= 219;	//Const Number Can't Use On First Arithmetic Instruction
	final public int ERROR_UNIKEY_AR_WRONG_END					= 220;	//Const Number Can't Use On Last Arithmetic Instruction
	final public int ERROR_UNIKEY_AR_VALUE_OVERFLOW				= 221;	//Const Number > 63
	final public int ERROR_UNIKEY_INVALID_KEY					= 222;	//The Key In The Key Storage Is Wrong
	final public int ERROR_UNIKEY_VERIFY_ADV_PASSWORD			= 223;	//Advanced Passwords (Password3 and Passowrd4) Not Verified
	final public int ERROR_UNIKEY_INVALID_KEY_STORE				= 224;	//Wrong Key Storage Number
	final public int ERROR_UNIKEY_GENERATE_NEW_PASSWORD			= 225;	//Generate New Password Failed
	final public int ERROR_UNIKEY_READ_UPDATETAG				= 226;	//Read UpdateTag Failed
	final public int ERROR_UNIKEY_WRITE_UPDATETAG				= 227;	//Write UpdateTag Failed
	final public int ERROR_UNIKEY_ENCRYPT_FAILED				= 228;	//Encrypt Data Failed
	final public int ERROR_UNIKEY_DECRYPT_FAILED				= 229;	//Decrypt Data Failed
	final public int ERROR_UNIKEY_READ_TIME						= 230;	//Get UniKey Time Failed
	final public int ERROR_UNIKEY_WRITE_TIME					= 231;	//Set UniKey Time Failed
	final public int ERROR_UNIKEY_WRITE_TIME_MODULE				= 232;	//Write Time Module Error
	final public int ERROR_UNIKEY_COMPARE_TIME_MODULE			= 233;	//The Specific Time Is Before The Module’s Start Time
	final public int ERROR_UNIKEY_TIME_MODULE_NOT_NULL			= 234;	//The Real Time Module Is Not Null, This Error is returned when write once flag is set
	final public int ERROR_UNIKEY_TIME_MODULE_OVERDUR			= 235;	//The Specific Time Is Later Than The Module's End Time, Or The Module Is Expired
	final public int ERROR_UNIKEY_ALREADY_LOCKED				= 236;	//Dongle Already Locked (When Lock Twice Or Open After Lock)
	final public int ERROR_UNIKEY_MAX_USERS						= 237;	//Dongle Already Max Users Logoned
	final public int ERROR_UNIKEY_MAX_KEYS						= 238;	//Dongle Already Max Keys, Need To Delete And The Regenerate
	final public int ERROR_UNIKEY_KEY_INDEX						= 239;	//Dongle Over Keyindex, No Key To  Delete
	final public int ERROR_UNIKEY_FS_FILE_NAME					= 240;	//Wrong Or Invalid File Name
	final public int ERROR_UNIKEY_FS_NO_FILE					= 241;	//No Such File Name
	final public int ERROR_UNIKEY_FS_FILE_OFFSET				= 242;	//Offset Of File Error
	final public int ERROR_UNIKEY_FS_UNKONW						= 243;	//Unknown Error
	final public int ERROR_UNIKEY_FS_NO_MEMORY					= 244;	//Not Enough Free Memory
	final public int ERROR_UNIKEY_FS_FILE_EXIST					= 245;	//File Already Existed
	final public int ERROR_UNIKEY_FS_ERR_SYS_UNINIT				= 246;	//File Sys Is Not Initialized
	final public int ERROR_UNIKEY_FS_ERR_OPEN_FILE				= 247;	//Can't Open File
	final public int ERROR_UNIKEY_NO_ENCYYPT					= 248;	//No Secure Drive
	final public int ERROR_UNIKEY_PASSWORD						= 249;	//Password Error
	final public int ERROR_UNIKEY_USERLOCK						= 250;	//User Has Been Locked
	final public int ERROR_UNIKEY_LOGOUT						= 251;	//ERRO_LOGOUT
	final public int ERROR_UNIKEY_UNKNOW						= 252;	//ERRO_UNKNOW

	final public int ERROR_UNIKEY_RSA_GENERATE_KEYPAIR			= 253;	//Can't Generate RSA KeyPair
	final public int ERROR_UNIKEY_RSA_EXPORT_PUBLIC_KEY			= 254;	//Can't Export RSA Public Key
	final public int ERROR_UNIKEY_RSA_IMPORT_PUBLIC_KEY			= 255;	//Can't Import RSA Public Key
	final public int ERROR_UNIKEY_RSA_SIGN						= 256;	//Signature Failure
	final public int ERROR_UNIKEY_RSA_VERIFY					= 257;	//Verification Signature Failure
	final public int ERROR_UNIKEY_RSA_HASHENCRYPT				= 258;	//Hash Encryption Failed
	final public int ERROR_UNIKEY_RSA_DELETE_KEYPAIR			= 259;	//Delete RSA KeyPair Failed
	final public int ERROR_UNIKEY_RSA_GET_KEYTYPE				= 260;	//Get RSA KeyPair Failed
	final public int ERROR_UNIKEY_INVALID_KEYINDEX				= 261;	//Invalid KeyPair Position
	final public int ERROR_UNIKEY_GET_FIRMWAREVERSION			= 262;	//Get Firmware Version Error
	final public int ERROR_UNIKEY_TYPE							= 263;	//Wrong Type Of Dongle
	final public int ERROR_E_VALUE								= 264;	//Error In Value Of E
	final public int ERROR_UNIKEY_RSA_GET_KEYPAIR_TYPE			= 265;	//Gets The Current Location KeyPair Type Failed
	final public int ERROR_UNIKEY_RSA_DECRYPTSIGNVALUE			= 266;	//Failed To Decrypt The Signature

	//error code Only NetUniKey
	final public int ERROR_RECEIVE_NULL							= 0x100;	//Receive null
	final public int ERROR_UNKNOWN_SYSTEM						= 0x102;	//Unknown operating system
	final public int ERROR_UNKNOWN_ERROR						= 0xffff;	//Unknown Error

	//error code Only UniKey
	final public int ERROR_MAX_USERS							= 42;		//Dongle Already MAX Users(32) Logon
	final public int ERROR_MAX_KEYS								= 43;		//Dongle Already MAX KEYS   RSA_KEY :4 DES_KEY 15
	final public int ERROR_KEY_INDEX							= 44;		//Dongle Key Index Error

	// NetUniKey Error
	final public int NET_UNIEKY_ERROR_BASE						= 100;							// NetUniKey error base
	final public int NET_UNIKEY_MEMORY_ERROR					= NET_UNIEKY_ERROR_BASE + 1;	// memory allocation error
	final public int NET_UNIKEY_SEND_ERROR						= NET_UNIEKY_ERROR_BASE + 2;	// send error
	final public int NET_UNIEY_RECEIVE_ERROR					= NET_UNIEKY_ERROR_BASE + 3;	// receive error
	final public int NET_UNIKEY_MESSAGE_WRONG					= NET_UNIEKY_ERROR_BASE + 4;	// communication message is modified
	final public int NET_UNIKEY_SETUP_SOCKET_ERROR				= NET_UNIEKY_ERROR_BASE + 5;	// setup socket error
	final public int NET_UNIKEY_CLIENT_EXSIT					= NET_UNIEKY_ERROR_BASE + 6;	// the client already exists, per this mode
	final public int NET_UNIKEY_TOO_MANY_CLIENT					= NET_UNIEKY_ERROR_BASE + 7;	// the number of client reach the limitation
	final public int NET_UNIKEY_IN_BLACKLIST					= NET_UNIEKY_ERROR_BASE + 8;	// the client is in the black list
	final public int NET_UNIKEY_OUT_WHITELIST					= NET_UNIEKY_ERROR_BASE + 9;	// the client is not in the white list
	final public int NET_UNIKEY_MESSAGE_CHANGE					= NET_UNIEKY_ERROR_BASE + 10;	// the message packet was changed
	final public int NET_UNIKEY_AREADY_START					= NET_UNIEKY_ERROR_BASE + 11;	// the server has already started
	final public int NET_UNIKEY_SOCKET_INIT_FAILED				= NET_UNIEKY_ERROR_BASE + 12;	// cannot initialize the socket
	final public int NET_UNIKEY_SOCKET_BIND_FAILED				= NET_UNIEKY_ERROR_BASE + 13;	// cannot bind the port with the socket
	final public int NET_UNIKEY_SOCKET_LISTEN_FAILED			= NET_UNIEKY_ERROR_BASE + 14;	// cannot start listening with the socket
	final public int NET_UNIKEY_START_UDP_SERVER_FAILED			= NET_UNIEKY_ERROR_BASE + 15;	// start udp server failed
	final public int NET_UNIKEY_TOO_LONG_MESSAGE				= NET_UNIEKY_ERROR_BASE + 16;	// too long message
	final public int NET_UNIKEY_NOT_WORKING						= NET_UNIEKY_ERROR_BASE + 17;	// cannot connect remote netunikey server
	final public int NET_UNIKEY_DISCARD_BY_SERVER				= NET_UNIEKY_ERROR_BASE + 18;	// the client is discarded by the server
	final public int NET_UNIKEY_SERVER_RESOURCE_INADEQUACY		= NET_UNIEKY_ERROR_BASE + 19;	// by lzm
}
